/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.Annotated;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedCreatorCollector;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedFieldCollector;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedMethodCollector;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedMethodMap;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotationCollector;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.TypeResolutionContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.type.TypeBindings;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.type.TypeFactory;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.Annotations;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.ClassUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;

public final class AnnotatedClass
extends Annotated
implements TypeResolutionContext {
    private static final Creators NO_CREATORS = new Creators(null, Collections.emptyList(), Collections.emptyList());
    protected final JavaType _type;
    protected final Class<?> _class;
    protected final TypeBindings _bindings;
    protected final List<JavaType> _superTypes;
    protected final AnnotationIntrospector _annotationIntrospector;
    protected final TypeFactory _typeFactory;
    protected final ClassIntrospector.MixInResolver _mixInResolver;
    protected final Class<?> _primaryMixIn;
    protected final boolean _collectAnnotations;
    protected final Annotations _classAnnotations;
    protected Creators _creators;
    protected AnnotatedMethodMap _memberMethods;
    protected List<AnnotatedField> _fields;
    protected transient Boolean _nonStaticInnerClass;

    AnnotatedClass(JavaType javaType, Class<?> clazz, List<JavaType> list, Class<?> clazz2, Annotations annotations, TypeBindings typeBindings, AnnotationIntrospector annotationIntrospector, ClassIntrospector.MixInResolver mixInResolver, TypeFactory typeFactory, boolean bl2) {
        this._type = javaType;
        this._class = clazz;
        this._superTypes = list;
        this._primaryMixIn = clazz2;
        this._classAnnotations = annotations;
        this._bindings = typeBindings;
        this._annotationIntrospector = annotationIntrospector;
        this._mixInResolver = mixInResolver;
        this._typeFactory = typeFactory;
        this._collectAnnotations = bl2;
    }

    AnnotatedClass(Class<?> clazz) {
        this._type = null;
        this._class = clazz;
        this._superTypes = Collections.emptyList();
        this._primaryMixIn = null;
        this._classAnnotations = AnnotationCollector.emptyAnnotations();
        this._bindings = TypeBindings.emptyBindings();
        this._annotationIntrospector = null;
        this._mixInResolver = null;
        this._typeFactory = null;
        this._collectAnnotations = false;
    }

    @Override
    public JavaType resolveType(Type type) {
        return this._typeFactory.resolveMemberType(type, this._bindings);
    }

    @Override
    public Class<?> getAnnotated() {
        return this._class;
    }

    @Override
    public String getName() {
        return this._class.getName();
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> clazz) {
        return this._classAnnotations.get(clazz);
    }

    @Override
    public boolean hasAnnotation(Class<?> clazz) {
        return this._classAnnotations.has(clazz);
    }

    @Override
    public boolean hasOneOf(Class<? extends Annotation>[] classArray) {
        return this._classAnnotations.hasOneOf(classArray);
    }

    @Override
    public Class<?> getRawType() {
        return this._class;
    }

    @Override
    public JavaType getType() {
        return this._type;
    }

    public Annotations getAnnotations() {
        return this._classAnnotations;
    }

    public boolean hasAnnotations() {
        return this._classAnnotations.size() > 0;
    }

    public AnnotatedConstructor getDefaultConstructor() {
        return this._creators().defaultConstructor;
    }

    public List<AnnotatedConstructor> getConstructors() {
        return this._creators().constructors;
    }

    public List<AnnotatedMethod> getFactoryMethods() {
        return this._creators().creatorMethods;
    }

    public Iterable<AnnotatedMethod> memberMethods() {
        return this._methods();
    }

    public AnnotatedMethod findMethod(String string, Class<?>[] classArray) {
        return this._methods().find(string, classArray);
    }

    public Iterable<AnnotatedField> fields() {
        return this._fields();
    }

    public boolean isNonStaticInnerClass() {
        Boolean bl2 = this._nonStaticInnerClass;
        if (bl2 == null) {
            this._nonStaticInnerClass = bl2 = Boolean.valueOf(ClassUtil.isNonStaticInnerClass(this._class));
        }
        return bl2;
    }

    private final List<AnnotatedField> _fields() {
        List<AnnotatedField> list = this._fields;
        if (list == null) {
            list = this._type == null ? Collections.emptyList() : AnnotatedFieldCollector.collectFields(this._annotationIntrospector, this, this._mixInResolver, this._typeFactory, this._type, this._collectAnnotations);
            this._fields = list;
        }
        return list;
    }

    private final AnnotatedMethodMap _methods() {
        AnnotatedMethodMap annotatedMethodMap = this._memberMethods;
        if (annotatedMethodMap == null) {
            annotatedMethodMap = this._type == null ? new AnnotatedMethodMap() : AnnotatedMethodCollector.collectMethods(this._annotationIntrospector, this, this._mixInResolver, this._typeFactory, this._type, this._superTypes, this._primaryMixIn, this._collectAnnotations);
            this._memberMethods = annotatedMethodMap;
        }
        return annotatedMethodMap;
    }

    private final Creators _creators() {
        Creators creators = this._creators;
        if (creators == null) {
            creators = this._type == null ? NO_CREATORS : AnnotatedCreatorCollector.collectCreators(this._annotationIntrospector, this._typeFactory, this, this._type, this._primaryMixIn, this._collectAnnotations);
            this._creators = creators;
        }
        return creators;
    }

    @Override
    public String toString() {
        return "[AnnotedClass " + this._class.getName() + "]";
    }

    @Override
    public int hashCode() {
        return this._class.getName().hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!ClassUtil.hasClass(object, this.getClass())) {
            return false;
        }
        return ((AnnotatedClass)object)._class == this._class;
    }

    public static final class Creators {
        public final AnnotatedConstructor defaultConstructor;
        public final List<AnnotatedConstructor> constructors;
        public final List<AnnotatedMethod> creatorMethods;

        public Creators(AnnotatedConstructor annotatedConstructor, List<AnnotatedConstructor> list, List<AnnotatedMethod> list2) {
            this.defaultConstructor = annotatedConstructor;
            this.constructors = list;
            this.creatorMethods = list2;
        }
    }
}

