/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.smile;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonLocation;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParseException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.StreamReadCapability;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.StreamReadConstraints;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.StreamReadFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.base.ParserMinimalBase;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.io.ContentReference;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.io.IOContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.io.NumberInput;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.json.DupDetector;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.json.JsonReadContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.sym.ByteQuadsCanonicalizer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.util.JacksonFeatureSet;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.util.TextBuffer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.smile.SmileBufferRecycler;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;

public abstract class SmileParserBase
extends ParserMinimalBase {
    protected static final String[] NO_STRINGS = new String[0];
    protected static final JacksonFeatureSet<StreamReadCapability> SMILE_READ_CAPABILITIES = DEFAULT_READ_CAPABILITIES.with(StreamReadCapability.EXACT_FLOATS);
    protected int _formatFeatures;
    protected boolean _mayContainRawBinary;
    protected final IOContext _ioContext;
    protected boolean _closed;
    protected int _inputPtr = 0;
    protected int _inputEnd = 0;
    protected long _currInputProcessed;
    protected int _tokenOffsetForTotal;
    protected JsonReadContext _streamReadContext;
    protected final TextBuffer _textBuffer;
    protected char[] _nameCopyBuffer;
    protected boolean _nameCopied;
    protected byte[] _binaryValue;
    protected JsonParser.NumberType _numberType;
    protected int _numTypesValid = 0;
    protected BigInteger _numberBigInt;
    protected BigDecimal _numberBigDecimal;
    protected int _numberInt;
    protected float _numberFloat;
    protected long _numberLong;
    protected double _numberDouble;
    protected final ByteQuadsCanonicalizer _symbols;
    protected int[] _quadBuffer = NO_INTS;
    protected int _quad1;
    protected int _quad2;
    protected int _quad3;
    protected String[] _seenNames = NO_STRINGS;
    protected int _seenNameCount = 0;
    protected String[] _seenStringValues = null;
    protected int _seenStringValueCount = -1;
    protected final boolean _symbolsCanonical;
    protected static final ThreadLocal<SoftReference<SmileBufferRecycler<String>>> _smileRecyclerRef = new ThreadLocal();
    protected final SmileBufferRecycler<String> _smileBufferRecycler;

    public SmileParserBase(IOContext iOContext, int n2, int n3, ByteQuadsCanonicalizer byteQuadsCanonicalizer) {
        super(n2);
        this._formatFeatures = n3;
        this._ioContext = iOContext;
        this._symbols = byteQuadsCanonicalizer;
        this._symbolsCanonical = byteQuadsCanonicalizer.isCanonicalizing();
        DupDetector dupDetector = JsonParser.Feature.STRICT_DUPLICATE_DETECTION.enabledIn(n2) ? DupDetector.rootDetector(this) : null;
        this._streamReadContext = JsonReadContext.createRootContext(dupDetector);
        this._textBuffer = iOContext.constructReadConstrainedTextBuffer();
        this._smileBufferRecycler = SmileParserBase._smileBufferRecycler();
    }

    @Override
    public StreamReadConstraints streamReadConstraints() {
        return this._ioContext.streamReadConstraints();
    }

    protected static final SmileBufferRecycler<String> _smileBufferRecycler() {
        SmileBufferRecycler<String> smileBufferRecycler;
        SoftReference<SmileBufferRecycler<String>> softReference = _smileRecyclerRef.get();
        SmileBufferRecycler<String> smileBufferRecycler2 = smileBufferRecycler = softReference == null ? null : softReference.get();
        if (smileBufferRecycler == null) {
            smileBufferRecycler = new SmileBufferRecycler();
            _smileRecyclerRef.set(new SoftReference<SmileBufferRecycler<String>>(smileBufferRecycler));
        }
        return smileBufferRecycler;
    }

    @Override
    public final JsonParser overrideFormatFeatures(int n2, int n3) {
        this._formatFeatures = this._formatFeatures & ~n3 | n2 & n3;
        return this;
    }

    @Override
    public JacksonFeatureSet<StreamReadCapability> getReadCapabilities() {
        return SMILE_READ_CAPABILITIES;
    }

    protected abstract void _closeInput() throws IOException;

    protected abstract void _parseNumericValue() throws IOException;

    @Override
    public final JsonLocation getTokenLocation() {
        long l2 = this._currInputProcessed + (long)this._tokenOffsetForTotal;
        return new JsonLocation(this._ioContext.contentReference(), l2, -1L, -1, (int)l2);
    }

    @Override
    public final JsonLocation getCurrentLocation() {
        long l2 = this._currInputProcessed + (long)this._inputPtr;
        return new JsonLocation(this._ioContext.contentReference(), l2, -1L, -1, (int)l2);
    }

    @Override
    public final String getCurrentName() throws IOException {
        if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
            return this._streamReadContext.getParent().getCurrentName();
        }
        return this._streamReadContext.getCurrentName();
    }

    @Override
    public final void close() throws IOException {
        if (!this._closed) {
            this._closed = true;
            this._inputEnd = 0;
            this._symbols.release();
            try {
                this._closeInput();
            }
            finally {
                this._releaseBuffers();
            }
        }
    }

    protected final void _releaseBuffers() throws IOException {
        Object[] objectArray;
        Object[] objectArray2;
        this._textBuffer.releaseBuffers();
        char[] cArray = this._nameCopyBuffer;
        if (cArray != null) {
            this._nameCopyBuffer = null;
            this._ioContext.releaseNameCopyBuffer(cArray);
        }
        if ((objectArray2 = this._seenNames) != null && objectArray2.length > 0) {
            this._seenNames = null;
            if (this._seenNameCount > 0) {
                Arrays.fill(objectArray2, 0, this._seenNameCount, null);
            }
            this._smileBufferRecycler.releaseSeenNamesBuffer((String[])objectArray2);
        }
        if ((objectArray = this._seenStringValues) != null && objectArray.length > 0) {
            this._seenStringValues = null;
            if (this._seenStringValueCount > 0) {
                Arrays.fill(objectArray, 0, this._seenStringValueCount, null);
            }
            this._smileBufferRecycler.releaseSeenStringValuesBuffer((String[])objectArray);
        }
        this._releaseBuffers2();
    }

    protected abstract void _releaseBuffers2();

    @Override
    public final JsonReadContext getParsingContext() {
        return this._streamReadContext;
    }

    @Override
    public final boolean isNaN() throws IOException {
        if (this._currToken == JsonToken.VALUE_NUMBER_FLOAT) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue();
            }
            if (this._numberType == JsonParser.NumberType.DOUBLE) {
                double d2 = this._numberDouble;
                return Double.isNaN(d2) || Double.isInfinite(d2);
            }
            if (this._numberType == JsonParser.NumberType.FLOAT) {
                float f2 = this._numberFloat;
                return Float.isNaN(f2) || Float.isInfinite(f2);
            }
        }
        return false;
    }

    @Override
    public final Number getNumberValue() throws IOException {
        if (this._numTypesValid == 0) {
            this._parseNumericValue();
        }
        switch (this._numberType) {
            case INT: {
                return this._numberInt;
            }
            case LONG: {
                return this._numberLong;
            }
            case BIG_INTEGER: {
                return this._numberBigInt;
            }
            case FLOAT: {
                return Float.valueOf(this._numberFloat);
            }
            case DOUBLE: {
                return this._numberDouble;
            }
        }
        return this._numberBigDecimal;
    }

    @Override
    public final JsonParser.NumberType getNumberType() throws IOException {
        if (this._numTypesValid == 0) {
            this._parseNumericValue();
        }
        return this._numberType;
    }

    @Override
    public final int getIntValue() throws IOException {
        if ((this._numTypesValid & 1) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue();
            }
            if ((this._numTypesValid & 1) == 0) {
                this.convertNumberToInt();
            }
        }
        return this._numberInt;
    }

    @Override
    public final long getLongValue() throws IOException {
        if ((this._numTypesValid & 2) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue();
            }
            if ((this._numTypesValid & 2) == 0) {
                this.convertNumberToLong();
            }
        }
        return this._numberLong;
    }

    @Override
    public final BigInteger getBigIntegerValue() throws IOException {
        if ((this._numTypesValid & 4) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue();
            }
            if ((this._numTypesValid & 4) == 0) {
                this.convertNumberToBigInteger();
            }
        }
        return this._numberBigInt;
    }

    @Override
    public final float getFloatValue() throws IOException {
        if ((this._numTypesValid & 0x20) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue();
            }
            if ((this._numTypesValid & 0x20) == 0) {
                this.convertNumberToFloat();
            }
        }
        return this._numberFloat;
    }

    @Override
    public final double getDoubleValue() throws IOException {
        if ((this._numTypesValid & 8) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue();
            }
            if ((this._numTypesValid & 8) == 0) {
                this.convertNumberToDouble();
            }
        }
        return this._numberDouble;
    }

    @Override
    public final BigDecimal getDecimalValue() throws IOException {
        if ((this._numTypesValid & 0x10) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue();
            }
            if ((this._numTypesValid & 0x10) == 0) {
                this.convertNumberToBigDecimal();
            }
        }
        return this._numberBigDecimal;
    }

    protected final void convertNumberToInt() throws IOException {
        if ((this._numTypesValid & 2) != 0) {
            int n2 = (int)this._numberLong;
            if ((long)n2 != this._numberLong) {
                this._reportError("Numeric value (%s) out of range of int", this.getText());
            }
            this._numberInt = n2;
        } else if ((this._numTypesValid & 4) != 0) {
            if (BI_MIN_INT.compareTo(this._numberBigInt) > 0 || BI_MAX_INT.compareTo(this._numberBigInt) < 0) {
                this.reportOverflowInt();
            }
            this._numberInt = this._numberBigInt.intValue();
        } else if ((this._numTypesValid & 8) != 0) {
            if (this._numberDouble < -2.147483648E9 || this._numberDouble > 2.147483647E9) {
                this.reportOverflowInt();
            }
            this._numberInt = (int)this._numberDouble;
        } else if ((this._numTypesValid & 0x20) != 0) {
            if ((double)this._numberFloat < -2.147483648E9 || (double)this._numberFloat > 2.147483647E9) {
                this.reportOverflowInt();
            }
            this._numberInt = (int)this._numberFloat;
        } else if ((this._numTypesValid & 0x10) != 0) {
            if (BD_MIN_INT.compareTo(this._numberBigDecimal) > 0 || BD_MAX_INT.compareTo(this._numberBigDecimal) < 0) {
                this.reportOverflowInt();
            }
            this._numberInt = this._numberBigDecimal.intValue();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 1;
    }

    protected final void convertNumberToLong() throws IOException {
        int n2 = this._numTypesValid;
        if ((n2 & 1) != 0) {
            this._numberLong = this._numberInt;
        } else if ((n2 & 4) != 0) {
            if (BI_MIN_LONG.compareTo(this._numberBigInt) > 0 || BI_MAX_LONG.compareTo(this._numberBigInt) < 0) {
                this.reportOverflowLong();
            }
            this._numberLong = this._numberBigInt.longValue();
        } else if ((n2 & 8) != 0) {
            if (this._numberDouble < -9.223372036854776E18 || this._numberDouble > 9.223372036854776E18) {
                this.reportOverflowLong();
            }
            this._numberLong = (long)this._numberDouble;
        } else if ((n2 & 0x20) != 0) {
            if ((double)this._numberFloat < -9.223372036854776E18 || (double)this._numberFloat > 9.223372036854776E18) {
                this.reportOverflowInt();
            }
            this._numberLong = (long)this._numberFloat;
        } else if ((n2 & 0x10) != 0) {
            if (BD_MIN_LONG.compareTo(this._numberBigDecimal) > 0 || BD_MAX_LONG.compareTo(this._numberBigDecimal) < 0) {
                this.reportOverflowLong();
            }
            this._numberLong = this._numberBigDecimal.longValue();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 2;
    }

    protected final void convertNumberToBigInteger() throws IOException {
        if ((this._numTypesValid & 0x10) != 0) {
            this.streamReadConstraints().validateBigIntegerScale(this._numberBigDecimal.scale());
            this._numberBigInt = this._numberBigDecimal.toBigInteger();
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberBigInt = BigInteger.valueOf(this._numberLong);
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberBigInt = BigInteger.valueOf(this._numberInt);
        } else if ((this._numTypesValid & 8) != 0) {
            this._numberBigInt = BigDecimal.valueOf(this._numberDouble).toBigInteger();
        } else if ((this._numTypesValid & 0x20) != 0) {
            this._numberBigInt = BigDecimal.valueOf(this._numberFloat).toBigInteger();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 4;
    }

    protected final void convertNumberToFloat() throws IOException {
        if ((this._numTypesValid & 0x10) != 0) {
            this._numberFloat = this._numberBigDecimal.floatValue();
        } else if ((this._numTypesValid & 4) != 0) {
            this._numberFloat = this._numberBigInt.floatValue();
        } else if ((this._numTypesValid & 8) != 0) {
            this._numberFloat = (float)this._numberDouble;
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberFloat = this._numberLong;
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberFloat = this._numberInt;
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 0x20;
    }

    protected final void convertNumberToDouble() throws IOException {
        if ((this._numTypesValid & 0x10) != 0) {
            this._numberDouble = this._numberBigDecimal.doubleValue();
        } else if ((this._numTypesValid & 0x20) != 0) {
            this._numberDouble = this._numberFloat;
        } else if ((this._numTypesValid & 4) != 0) {
            this._numberDouble = this._numberBigInt.doubleValue();
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberDouble = this._numberLong;
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberDouble = this._numberInt;
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 8;
    }

    protected final void convertNumberToBigDecimal() throws IOException {
        if ((this._numTypesValid & 0x28) != 0) {
            String string = this.getText();
            this.streamReadConstraints().validateFPLength(string.length());
            this._numberBigDecimal = NumberInput.parseBigDecimal(string, this.isEnabled(StreamReadFeature.USE_FAST_BIG_NUMBER_PARSER));
        } else if ((this._numTypesValid & 4) != 0) {
            this._numberBigDecimal = new BigDecimal(this._numberBigInt);
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberBigDecimal = BigDecimal.valueOf(this._numberLong);
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberBigDecimal = BigDecimal.valueOf(this._numberInt);
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 0x10;
    }

    @Override
    protected void _handleEOF() throws JsonParseException {
        if (!this._streamReadContext.inRoot()) {
            String string = this._streamReadContext.inArray() ? "Array" : "Object";
            this._reportInvalidEOF(String.format(": expected close marker for %s (start marker at %s)", string, this._streamReadContext.startLocation(this._sourceReference())), null);
        }
    }

    protected void _reportMismatchedEndMarker(int n2, char c2) throws JsonParseException {
        JsonReadContext jsonReadContext = this.getParsingContext();
        this._reportError(String.format("Unexpected close marker '%s': expected '%c' (for %s starting at %s)", Character.valueOf((char)n2), Character.valueOf(c2), jsonReadContext.typeDesc(), jsonReadContext.startLocation(this._sourceReference())));
    }

    protected ContentReference _sourceReference() {
        if (this.isEnabled(StreamReadFeature.INCLUDE_SOURCE_IN_LOCATION)) {
            return this._ioContext.contentReference();
        }
        return ContentReference.unknown();
    }
}

