/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.base;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class Throwables {
    private static final Object jla = Throwables.getJLA();
    private static final Method getStackTraceElementMethod = jla == null ? null : Throwables.getGetMethod();
    private static final Method getStackTraceDepthMethod = jla == null ? null : Throwables.getSizeMethod(jla);

    public static <X extends Throwable> void throwIfInstanceOf(Throwable throwable, Class<X> clazz) throws X {
        Preconditions.checkNotNull(throwable);
        if (clazz.isInstance(throwable)) {
            throw (Throwable)clazz.cast(throwable);
        }
    }

    @Deprecated
    public static <X extends Throwable> void propagateIfInstanceOf(Throwable throwable, Class<X> clazz) throws X {
        if (throwable != null) {
            Throwables.throwIfInstanceOf(throwable, clazz);
        }
    }

    public static void throwIfUnchecked(Throwable throwable) {
        Preconditions.checkNotNull(throwable);
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
    }

    @Deprecated
    public static void propagateIfPossible(Throwable throwable) {
        if (throwable != null) {
            Throwables.throwIfUnchecked(throwable);
        }
    }

    public static <X extends Throwable> void propagateIfPossible(Throwable throwable, Class<X> clazz) throws X {
        Throwables.propagateIfInstanceOf(throwable, clazz);
        Throwables.propagateIfPossible(throwable);
    }

    public static Throwable getRootCause(Throwable throwable) {
        Throwable throwable2;
        Throwable throwable3 = throwable;
        boolean bl2 = false;
        while ((throwable2 = throwable.getCause()) != null) {
            throwable = throwable2;
            if (throwable == throwable3) {
                throw new IllegalArgumentException("Loop in causal chain detected.", throwable);
            }
            if (bl2) {
                throwable3 = throwable3.getCause();
            }
            bl2 = !bl2;
        }
        return throwable;
    }

    private static Object getJLA() {
        try {
            Class<?> clazz = Class.forName("sun.misc.SharedSecrets", false, null);
            Method method = clazz.getMethod("getJavaLangAccess", new Class[0]);
            return method.invoke(null, new Object[0]);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Method getGetMethod() {
        return Throwables.getJlaMethod("getStackTraceElement", Throwable.class, Integer.TYPE);
    }

    private static Method getSizeMethod(Object object) {
        try {
            Method method = Throwables.getJlaMethod("getStackTraceDepth", Throwable.class);
            if (method == null) {
                return null;
            }
            method.invoke(object, new Throwable());
            return method;
        }
        catch (IllegalAccessException | UnsupportedOperationException | InvocationTargetException exception) {
            return null;
        }
    }

    private static Method getJlaMethod(String string, Class<?> ... classArray) throws ThreadDeath {
        try {
            return Class.forName("sun.misc.JavaLangAccess", false, null).getMethod(string, classArray);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

