/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.io;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.io.AppendableWriter;
import com.gradle.maven.extension.internal.dep.com.google.common.io.Java8Compatibility;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.CharBuffer;

public final class CharStreams {
    static CharBuffer createBuffer() {
        return CharBuffer.allocate(2048);
    }

    public static long copy(Readable readable, Appendable appendable) throws IOException {
        if (readable instanceof Reader) {
            if (appendable instanceof StringBuilder) {
                return CharStreams.copyReaderToBuilder((Reader)readable, (StringBuilder)appendable);
            }
            return CharStreams.copyReaderToWriter((Reader)readable, CharStreams.asWriter(appendable));
        }
        Preconditions.checkNotNull(readable);
        Preconditions.checkNotNull(appendable);
        long l2 = 0L;
        CharBuffer charBuffer = CharStreams.createBuffer();
        while (readable.read(charBuffer) != -1) {
            Java8Compatibility.flip(charBuffer);
            appendable.append(charBuffer);
            l2 += (long)charBuffer.remaining();
            Java8Compatibility.clear(charBuffer);
        }
        return l2;
    }

    static long copyReaderToBuilder(Reader reader, StringBuilder stringBuilder) throws IOException {
        int n2;
        Preconditions.checkNotNull(reader);
        Preconditions.checkNotNull(stringBuilder);
        char[] cArray = new char[2048];
        long l2 = 0L;
        while ((n2 = reader.read(cArray)) != -1) {
            stringBuilder.append(cArray, 0, n2);
            l2 += (long)n2;
        }
        return l2;
    }

    static long copyReaderToWriter(Reader reader, Writer writer) throws IOException {
        int n2;
        Preconditions.checkNotNull(reader);
        Preconditions.checkNotNull(writer);
        char[] cArray = new char[2048];
        long l2 = 0L;
        while ((n2 = reader.read(cArray)) != -1) {
            writer.write(cArray, 0, n2);
            l2 += (long)n2;
        }
        return l2;
    }

    public static String toString(Readable readable) throws IOException {
        return CharStreams.toStringBuilder(readable).toString();
    }

    private static StringBuilder toStringBuilder(Readable readable) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        if (readable instanceof Reader) {
            CharStreams.copyReaderToBuilder((Reader)readable, stringBuilder);
        } else {
            CharStreams.copy(readable, stringBuilder);
        }
        return stringBuilder;
    }

    public static Writer asWriter(Appendable appendable) {
        if (appendable instanceof Writer) {
            return (Writer)appendable;
        }
        return new AppendableWriter(appendable);
    }
}

