/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.impl;

import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaType;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaWildcardType;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.impl.DefaultJavaType;
import java.util.Collections;
import java.util.List;

public class DefaultJavaWildcardType
extends DefaultJavaType
implements JavaWildcardType {
    private BoundType boundType;
    private List<JavaType> bounds = Collections.emptyList();

    public DefaultJavaWildcardType() {
        super("?");
    }

    public DefaultJavaWildcardType(JavaType javaType, BoundType boundType) {
        this();
        this.bounds = Collections.singletonList(javaType);
        this.boundType = boundType;
    }

    @Override
    public String getFullyQualifiedName() {
        StringBuilder stringBuilder = this.getPreparedStringBuilder();
        for (JavaType javaType : this.bounds) {
            stringBuilder.append(javaType.getFullyQualifiedName());
        }
        return stringBuilder.toString();
    }

    @Override
    public String getCanonicalName() {
        StringBuilder stringBuilder = this.getPreparedStringBuilder();
        for (JavaType javaType : this.bounds) {
            stringBuilder.append(javaType.getCanonicalName());
        }
        return stringBuilder.toString();
    }

    @Override
    public String getGenericCanonicalName() {
        StringBuilder stringBuilder = this.getPreparedStringBuilder();
        for (JavaType javaType : this.bounds) {
            stringBuilder.append(javaType.getGenericCanonicalName());
        }
        return stringBuilder.toString();
    }

    @Override
    public String getValue() {
        StringBuilder stringBuilder = this.getPreparedStringBuilder();
        for (JavaType javaType : this.bounds) {
            stringBuilder.append(javaType.getValue());
        }
        return stringBuilder.toString();
    }

    private StringBuilder getPreparedStringBuilder() {
        StringBuilder stringBuilder = new StringBuilder("?");
        if (BoundType.EXTENDS.equals((Object)this.boundType)) {
            stringBuilder.append(" extends ");
        } else if (BoundType.SUPER.equals((Object)this.boundType)) {
            stringBuilder.append(" super ");
        }
        return stringBuilder;
    }

    public static enum BoundType {
        EXTENDS,
        SUPER;

    }
}

