/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.http.client.entity;

import com.gradle.maven.extension.internal.dep.org.apache.http.Header;
import com.gradle.maven.extension.internal.dep.org.apache.http.HttpEntity;
import com.gradle.maven.extension.internal.dep.org.apache.http.client.entity.InputStreamFactory;
import com.gradle.maven.extension.internal.dep.org.apache.http.client.entity.LazyDecompressingInputStream;
import com.gradle.maven.extension.internal.dep.org.apache.http.entity.HttpEntityWrapper;
import com.gradle.maven.extension.internal.dep.org.apache.http.util.Args;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DecompressingEntity
extends HttpEntityWrapper {
    private final InputStreamFactory inputStreamFactory;
    private InputStream content;

    public DecompressingEntity(HttpEntity httpEntity, InputStreamFactory inputStreamFactory) {
        super(httpEntity);
        this.inputStreamFactory = inputStreamFactory;
    }

    private InputStream getDecompressingStream() throws IOException {
        InputStream inputStream = this.wrappedEntity.getContent();
        return new LazyDecompressingInputStream(inputStream, this.inputStreamFactory);
    }

    @Override
    public InputStream getContent() throws IOException {
        if (this.wrappedEntity.isStreaming()) {
            if (this.content == null) {
                this.content = this.getDecompressingStream();
            }
            return this.content;
        }
        return this.getDecompressingStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        Args.notNull(outputStream, "Output stream");
        InputStream inputStream = this.getContent();
        try {
            int n2;
            byte[] byArray = new byte[2048];
            while ((n2 = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n2);
            }
        }
        finally {
            inputStream.close();
        }
    }

    @Override
    public Header getContentEncoding() {
        return null;
    }

    @Override
    public long getContentLength() {
        return -1L;
    }
}

