/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.util;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api.Authentication;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api.ContentResponse;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api.Request;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.util.AbstractAuthentication;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpHeader;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.Attributes;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class BasicAuthentication
extends AbstractAuthentication {
    private final String user;
    private final String password;

    public BasicAuthentication(URI uRI, String string, String string2, String string3) {
        super(uRI, string);
        this.user = string2;
        this.password = string3;
    }

    @Override
    public String getType() {
        return "Basic";
    }

    @Override
    public Authentication.Result authenticate(Request request, ContentResponse contentResponse, Authentication.HeaderInfo headerInfo, Attributes attributes) {
        String string = headerInfo.getParameter("charset");
        Charset charset = string == null ? null : Charset.forName(string);
        return new BasicResult(this.getURI(), headerInfo.getHeader(), this.user, this.password, charset);
    }

    public static class BasicResult
    implements Authentication.Result {
        private final URI uri;
        private final HttpHeader header;
        private final String value;

        public BasicResult(URI uRI, HttpHeader httpHeader, String string, String string2, Charset charset) {
            this.uri = uRI;
            this.header = httpHeader;
            if (charset == null) {
                charset = StandardCharsets.ISO_8859_1;
            }
            byte[] byArray = (string + ":" + string2).getBytes(charset);
            this.value = "Basic " + Base64.getEncoder().encodeToString(byArray);
        }

        @Override
        public URI getURI() {
            return this.uri;
        }

        @Override
        public void apply(Request request) {
            if (!request.getHeaders().contains(this.header, this.value)) {
                request.header(this.header, this.value);
            }
        }

        public String toString() {
            return String.format("Basic authentication result for %s", this.getURI());
        }
    }
}

