/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.util;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.HttpContentResponse;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api.ContentResponse;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api.Request;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api.Result;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.util.BufferingResponseListener;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class FutureResponseListener
extends BufferingResponseListener
implements Future<ContentResponse> {
    private final CountDownLatch latch = new CountDownLatch(1);
    private final Request request;
    private ContentResponse response;
    private Throwable failure;
    private volatile boolean cancelled;

    public FutureResponseListener(Request request) {
        this(request, 0x200000);
    }

    public FutureResponseListener(Request request, int n2) {
        super(n2);
        this.request = request;
    }

    @Override
    public void onComplete(Result result) {
        this.response = new HttpContentResponse(result.getResponse(), this.getContent(), this.getMediaType(), this.getEncoding());
        this.failure = result.getFailure();
        this.latch.countDown();
    }

    @Override
    public boolean cancel(boolean bl2) {
        this.cancelled = true;
        return this.request.abort(new CancellationException());
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        return this.latch.getCount() == 0L || this.isCancelled();
    }

    @Override
    public ContentResponse get() throws InterruptedException, ExecutionException {
        this.latch.await();
        return this.getResult();
    }

    @Override
    public ContentResponse get(long l2, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        boolean bl2;
        boolean bl3 = bl2 = !this.latch.await(l2, timeUnit);
        if (bl2) {
            throw new TimeoutException();
        }
        return this.getResult();
    }

    private ContentResponse getResult() throws ExecutionException {
        if (this.isCancelled()) {
            throw (CancellationException)new CancellationException().initCause(this.failure);
        }
        if (this.failure != null) {
            throw new ExecutionException(this.failure);
        }
        return this.response;
    }
}

