/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.ssl;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.ssl.SslContextFactory;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.ssl.X509;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.net.ssl.SNIMatcher;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509ExtendedKeyManager;

public class SniX509ExtendedKeyManager
extends X509ExtendedKeyManager {
    private static final Logger LOG = Log.getLogger(SniX509ExtendedKeyManager.class);
    private final X509ExtendedKeyManager _delegate;
    private final SslContextFactory.Server _sslContextFactory;
    private UnaryOperator<String> _aliasMapper = UnaryOperator.identity();

    public SniX509ExtendedKeyManager(X509ExtendedKeyManager x509ExtendedKeyManager, SslContextFactory.Server server) {
        this._delegate = x509ExtendedKeyManager;
        this._sslContextFactory = Objects.requireNonNull(server, "SslContextFactory.Server must be provided");
    }

    public UnaryOperator<String> getAliasMapper() {
        return this._aliasMapper;
    }

    @Override
    public String chooseClientAlias(String[] stringArray, Principal[] principalArray, Socket socket) {
        return this._delegate.chooseClientAlias(stringArray, principalArray, socket);
    }

    @Override
    public String chooseEngineClientAlias(String[] stringArray, Principal[] principalArray, SSLEngine sSLEngine) {
        return this._delegate.chooseEngineClientAlias(stringArray, principalArray, sSLEngine);
    }

    protected String chooseServerAlias(String string2, Principal[] principalArray, Collection<SNIMatcher> collection, SSLSession sSLSession) {
        String[] stringArray = this._delegate.getServerAliases(string2, principalArray);
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        Arrays.stream(stringArray).forEach(string -> linkedHashMap.put((String)this.getAliasMapper().apply((String)string), string));
        String string3 = collection == null ? null : (String)collection.stream().filter(SslContextFactory.AliasSNIMatcher.class::isInstance).map(SslContextFactory.AliasSNIMatcher.class::cast).findFirst().map(SslContextFactory.AliasSNIMatcher::getHost).orElse(null);
        try {
            String string4;
            Collection collection2 = linkedHashMap.keySet().stream().map(this._sslContextFactory::getX509).filter(Objects::nonNull).collect(Collectors.toList());
            SniSelector sniSelector = this._sslContextFactory.getSNISelector();
            if (sniSelector == null) {
                sniSelector = this._sslContextFactory;
            }
            if ((string4 = sniSelector.sniSelect(string2, principalArray, sSLSession, string3, collection2)) == null || string4 == "delegate_no_sni_match") {
                return string4;
            }
            X509 x509 = this._sslContextFactory.getX509(string4);
            if (!linkedHashMap.containsKey(string4) || x509 == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Invalid X509 match for SNI {}: {}", string3, string4);
                }
                return null;
            }
            if (sSLSession != null) {
                sSLSession.putValue("com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.ssl.snix509", x509);
            }
            String string5 = (String)linkedHashMap.get(string4);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Matched SNI {} with alias {}, certificate {} from aliases {}", string3, string5, x509, linkedHashMap.keySet());
            }
            return string5;
        }
        catch (Throwable throwable) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Failure matching X509 for SNI " + string3, throwable);
            }
            return null;
        }
    }

    @Override
    public String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
        boolean bl2;
        SSLSocket sSLSocket = (SSLSocket)socket;
        String string2 = socket == null ? this.chooseServerAlias(string, principalArray, Collections.emptyList(), null) : this.chooseServerAlias(string, principalArray, sSLSocket.getSSLParameters().getSNIMatchers(), sSLSocket.getHandshakeSession());
        boolean bl3 = bl2 = string2 == "delegate_no_sni_match";
        if (bl2) {
            string2 = this._delegate.chooseServerAlias(string, principalArray, socket);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Chose {} alias={} keyType={} on {}", bl2 ? "delegate" : "explicit", String.valueOf(string2), string, socket);
        }
        return string2;
    }

    @Override
    public String chooseEngineServerAlias(String string, Principal[] principalArray, SSLEngine sSLEngine) {
        boolean bl2;
        String string2 = sSLEngine == null ? this.chooseServerAlias(string, principalArray, Collections.emptyList(), null) : this.chooseServerAlias(string, principalArray, sSLEngine.getSSLParameters().getSNIMatchers(), sSLEngine.getHandshakeSession());
        boolean bl3 = bl2 = string2 == "delegate_no_sni_match";
        if (bl2) {
            string2 = this._delegate.chooseEngineServerAlias(string, principalArray, sSLEngine);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Chose {} alias={} keyType={} on {}", bl2 ? "delegate" : "explicit", String.valueOf(string2), string, sSLEngine);
        }
        return string2;
    }

    @Override
    public X509Certificate[] getCertificateChain(String string) {
        return this._delegate.getCertificateChain(string);
    }

    @Override
    public String[] getClientAliases(String string, Principal[] principalArray) {
        return this._delegate.getClientAliases(string, principalArray);
    }

    @Override
    public PrivateKey getPrivateKey(String string) {
        return this._delegate.getPrivateKey(string);
    }

    @Override
    public String[] getServerAliases(String string, Principal[] principalArray) {
        return this._delegate.getServerAliases(string, principalArray);
    }

    @FunctionalInterface
    public static interface SniSelector {
        public String sniSelect(String var1, Principal[] var2, SSLSession var3, String var4, Collection<X509> var5) throws SSLHandshakeException;
    }
}

