/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.ssl;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.StringUtil;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.component.AbstractLifeCycle;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.component.Dumpable;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.resource.Resource;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.security.CertificateUtils;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.security.CertificateValidator;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.security.Password;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.ssl.AliasedX509ExtendedKeyManager;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.ssl.SniX509ExtendedKeyManager;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.ssl.SslSelectionDump;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.ssl.X509;
import java.io.IOException;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CRL;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIMatcher;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;

public class SslContextFactory
extends AbstractLifeCycle
implements Dumpable {
    public static final TrustManager[] TRUST_ALL_CERTS = new X509TrustManager[]{new X509ExtendedTrustManagerWrapper(null)};
    public static final String DEFAULT_KEYMANAGERFACTORY_ALGORITHM = KeyManagerFactory.getDefaultAlgorithm();
    public static final String DEFAULT_TRUSTMANAGERFACTORY_ALGORITHM = TrustManagerFactory.getDefaultAlgorithm();
    private static final Logger LOG = Log.getLogger(SslContextFactory.class);
    private static final Logger LOG_CONFIG = LOG.getLogger("config");
    private static final String[] DEFAULT_EXCLUDED_PROTOCOLS = new String[]{"SSL", "SSLv2", "SSLv2Hello", "SSLv3"};
    private static final String[] DEFAULT_EXCLUDED_CIPHER_SUITES = new String[]{"^.*_(MD5|SHA|SHA1)$", "^TLS_RSA_.*$", "^SSL_.*$", "^.*_NULL_.*$", "^.*_anon_.*$"};
    private final Set<String> _excludeProtocols = new LinkedHashSet<String>();
    private final Set<String> _includeProtocols = new LinkedHashSet<String>();
    private final Set<String> _excludeCipherSuites = new LinkedHashSet<String>();
    private final Set<String> _includeCipherSuites = new LinkedHashSet<String>();
    private final Map<String, X509> _aliasX509 = new HashMap<String, X509>();
    private final Map<String, X509> _certHosts = new HashMap<String, X509>();
    private final Map<String, X509> _certWilds = new HashMap<String, X509>();
    private String[] _selectedProtocols;
    private boolean _useCipherSuitesOrder = true;
    private Comparator<String> _cipherComparator;
    private String[] _selectedCipherSuites;
    private Resource _keyStoreResource;
    private String _keyStoreProvider;
    private String _keyStoreType = "JKS";
    private String _certAlias;
    private Resource _trustStoreResource;
    private String _trustStoreProvider;
    private String _trustStoreType;
    private boolean _needClientAuth = false;
    private boolean _wantClientAuth = false;
    private Password _keyStorePassword;
    private Password _keyManagerPassword;
    private Password _trustStorePassword;
    private String _sslProvider;
    private String _sslProtocol = "TLS";
    private String _secureRandomAlgorithm;
    private String _keyManagerFactoryAlgorithm = DEFAULT_KEYMANAGERFACTORY_ALGORITHM;
    private String _trustManagerFactoryAlgorithm = DEFAULT_TRUSTMANAGERFACTORY_ALGORITHM;
    private boolean _validateCerts;
    private boolean _validatePeerCerts;
    private int _maxCertPathLength = -1;
    private String _crlPath;
    private boolean _enableCRLDP = false;
    private boolean _enableOCSP = false;
    private String _ocspResponderURL;
    private KeyStore _setKeyStore;
    private KeyStore _setTrustStore;
    private boolean _sessionCachingEnabled = true;
    private int _sslSessionCacheSize = -1;
    private int _sslSessionTimeout = -1;
    private SSLContext _setContext;
    private String _endpointIdentificationAlgorithm = "HTTPS";
    private boolean _trustAll;
    private boolean _renegotiationAllowed = true;
    private int _renegotiationLimit = 5;
    private Factory _factory;
    private PKIXCertPathChecker _pkixCertPathChecker;
    private HostnameVerifier _hostnameVerifier;

    @Deprecated
    public SslContextFactory() {
        this(false);
    }

    @Deprecated
    public SslContextFactory(boolean bl2) {
        this(bl2, null);
    }

    private SslContextFactory(boolean bl2, String string) {
        this.setTrustAll(bl2);
        this.setExcludeProtocols(DEFAULT_EXCLUDED_PROTOCOLS);
        this.setExcludeCipherSuites(DEFAULT_EXCLUDED_CIPHER_SUITES);
        if (string != null) {
            this.setKeyStorePath(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStart() throws Exception {
        super.doStart();
        SslContextFactory sslContextFactory = this;
        synchronized (sslContextFactory) {
            this.load();
        }
        this.checkConfiguration();
    }

    protected void checkConfiguration() {
        SSLEngine sSLEngine = this._factory._context.createSSLEngine();
        this.customize(sSLEngine);
        SSLParameters sSLParameters = sSLEngine.getSSLParameters();
        this.checkProtocols(sSLParameters);
        this.checkCiphers(sSLParameters);
    }

    protected void checkTrustAll() {
        if (this.isTrustAll()) {
            LOG_CONFIG.warn("Trusting all certificates configured for {}", this);
        }
    }

    protected void checkEndPointIdentificationAlgorithm() {
        if (this.getEndpointIdentificationAlgorithm() == null) {
            LOG_CONFIG.warn("No Client EndPointIdentificationAlgorithm configured for {}", this);
        }
    }

    protected void checkProtocols(SSLParameters sSLParameters) {
        for (String string : sSLParameters.getProtocols()) {
            for (String string2 : DEFAULT_EXCLUDED_PROTOCOLS) {
                if (!string2.equals(string)) continue;
                LOG_CONFIG.warn("Protocol {} not excluded for {}", string, this);
            }
        }
    }

    protected void checkCiphers(SSLParameters sSLParameters) {
        for (String string : sSLParameters.getCipherSuites()) {
            for (String string2 : DEFAULT_EXCLUDED_CIPHER_SUITES) {
                if (!string.matches(string2)) continue;
                LOG_CONFIG.warn("Weak cipher suite {} enabled for {}", string, this);
            }
        }
    }

    private void load() throws Exception {
        Object object;
        TrustManager[] trustManagerArray;
        SSLContext sSLContext = this._setContext;
        KeyStore keyStore = this._setKeyStore;
        KeyStore keyStore2 = this._setTrustStore;
        if (sSLContext == null) {
            if (keyStore == null && this._keyStoreResource == null && keyStore2 == null && this._trustStoreResource == null) {
                trustManagerArray = null;
                if (this.isTrustAll()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("No keystore or trust store configured.  ACCEPTING UNTRUSTED CERTIFICATES!!!!!", new Object[0]);
                    }
                    trustManagerArray = TRUST_ALL_CERTS;
                }
                sSLContext = this.getSSLContextInstance();
                sSLContext.init(null, trustManagerArray, this.getSecureRandomInstance());
            } else {
                if (keyStore == null) {
                    keyStore = this.loadKeyStore(this._keyStoreResource);
                }
                if (keyStore2 == null) {
                    keyStore2 = this.loadTrustStore(this._trustStoreResource);
                }
                trustManagerArray = this.loadCRL(this.getCrlPath());
                if (keyStore != null) {
                    for (String object22 : Collections.list(keyStore.aliases())) {
                        Certificate certificate = keyStore.getCertificate(object22);
                        if (certificate == null || !"X.509".equals(certificate.getType())) continue;
                        X509Certificate x509Certificate = (X509Certificate)certificate;
                        if (X509.isCertSign(x509Certificate)) {
                            if (!LOG.isDebugEnabled()) continue;
                            LOG.debug("Skipping " + x509Certificate, new Object[0]);
                            continue;
                        }
                        X509 x509 = new X509(object22, x509Certificate);
                        this._aliasX509.put(object22, x509);
                        if (this.isValidateCerts()) {
                            Iterator<String> iterator = new CertificateValidator(keyStore2, (Collection<? extends CRL>)trustManagerArray);
                            ((CertificateValidator)((Object)iterator)).setMaxCertPathLength(this.getMaxCertPathLength());
                            ((CertificateValidator)((Object)iterator)).setEnableCRLDP(this.isEnableCRLDP());
                            ((CertificateValidator)((Object)iterator)).setEnableOCSP(this.isEnableOCSP());
                            ((CertificateValidator)((Object)iterator)).setOcspResponderURL(this.getOcspResponderURL());
                            ((CertificateValidator)((Object)iterator)).validate(keyStore, x509Certificate);
                        }
                        LOG.info("x509={} for {}", x509, this);
                        for (String string : x509.getHosts()) {
                            this._certHosts.put(string, x509);
                        }
                        for (String string : x509.getWilds()) {
                            this._certWilds.put(string, x509);
                        }
                    }
                }
                object = this.getKeyManagers(keyStore);
                TrustManager[] trustManagerArray2 = this.getTrustManagers(keyStore2, (Collection<? extends CRL>)trustManagerArray);
                sSLContext = this.getSSLContextInstance();
                sSLContext.init((KeyManager[])object, trustManagerArray2, this.getSecureRandomInstance());
            }
        }
        if ((trustManagerArray = sSLContext.getServerSessionContext()) != null) {
            if (this.getSslSessionCacheSize() > -1) {
                trustManagerArray.setSessionCacheSize(this.getSslSessionCacheSize());
            }
            if (this.getSslSessionTimeout() > -1) {
                trustManagerArray.setSessionTimeout(this.getSslSessionTimeout());
            }
        }
        object = sSLContext.getDefaultSSLParameters();
        SSLParameters sSLParameters = sSLContext.getSupportedSSLParameters();
        this.selectCipherSuites(((SSLParameters)object).getCipherSuites(), sSLParameters.getCipherSuites());
        this.selectProtocols(((SSLParameters)object).getProtocols(), sSLParameters.getProtocols());
        this._factory = new Factory(keyStore, keyStore2, sSLContext);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Selected Protocols {} of {}", Arrays.asList(this._selectedProtocols), Arrays.asList(sSLParameters.getProtocols()));
            LOG.debug("Selected Ciphers   {} of {}", Arrays.asList(this._selectedCipherSuites), Arrays.asList(sSLParameters.getCipherSuites()));
        }
    }

    @Override
    public void dump(Appendable appendable, String string) throws IOException {
        try {
            SSLEngine sSLEngine = SSLContext.getDefault().createSSLEngine();
            Dumpable.dumpObjects(appendable, string, this, "trustAll=" + this._trustAll, new SslSelectionDump("Protocol", sSLEngine.getSupportedProtocols(), sSLEngine.getEnabledProtocols(), this.getExcludeProtocols(), this.getIncludeProtocols()), new SslSelectionDump("Cipher Suite", sSLEngine.getSupportedCipherSuites(), sSLEngine.getEnabledCipherSuites(), this.getExcludeCipherSuites(), this.getIncludeCipherSuites()));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            LOG.ignore(noSuchAlgorithmException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() throws Exception {
        SslContextFactory sslContextFactory = this;
        synchronized (sslContextFactory) {
            this.unload();
        }
        super.doStop();
    }

    private void unload() {
        this._factory = null;
        this._selectedProtocols = null;
        this._selectedCipherSuites = null;
        this._aliasX509.clear();
        this._certHosts.clear();
        this._certWilds.clear();
    }

    Map<String, X509> aliasCerts() {
        return this._aliasX509;
    }

    public Comparator<String> getCipherComparator() {
        return this._cipherComparator;
    }

    public X509 getX509(String string) {
        return this._aliasX509.get(string);
    }

    public String[] getExcludeProtocols() {
        return this._excludeProtocols.toArray(new String[0]);
    }

    public void setExcludeProtocols(String ... stringArray) {
        this._excludeProtocols.clear();
        this._excludeProtocols.addAll(Arrays.asList(stringArray));
    }

    public String[] getIncludeProtocols() {
        return this._includeProtocols.toArray(new String[0]);
    }

    public String[] getExcludeCipherSuites() {
        return this._excludeCipherSuites.toArray(new String[0]);
    }

    public void setExcludeCipherSuites(String ... stringArray) {
        this._excludeCipherSuites.clear();
        this._excludeCipherSuites.addAll(Arrays.asList(stringArray));
    }

    public String[] getIncludeCipherSuites() {
        return this._includeCipherSuites.toArray(new String[0]);
    }

    public boolean isUseCipherSuitesOrder() {
        return this._useCipherSuitesOrder;
    }

    public void setKeyStorePath(String string) {
        try {
            this._keyStoreResource = Resource.newResource(string);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    public String getKeyStoreProvider() {
        return this._keyStoreProvider;
    }

    public String getKeyStoreType() {
        return this._keyStoreType;
    }

    public String getCertAlias() {
        return this._certAlias;
    }

    public String getTrustStoreProvider() {
        return this._trustStoreProvider;
    }

    public String getTrustStoreType() {
        return this._trustStoreType;
    }

    @Deprecated
    public boolean getNeedClientAuth() {
        return this._needClientAuth;
    }

    @Deprecated
    public boolean getWantClientAuth() {
        return this._wantClientAuth;
    }

    public boolean isValidateCerts() {
        return this._validateCerts;
    }

    public boolean isValidatePeerCerts() {
        return this._validatePeerCerts;
    }

    public String getProvider() {
        return this._sslProvider;
    }

    public String getProtocol() {
        return this._sslProtocol;
    }

    public String getSecureRandomAlgorithm() {
        return this._secureRandomAlgorithm;
    }

    public String getKeyManagerFactoryAlgorithm() {
        return this._keyManagerFactoryAlgorithm;
    }

    public String getTrustManagerFactoryAlgorithm() {
        return this._trustManagerFactoryAlgorithm;
    }

    public boolean isTrustAll() {
        return this._trustAll;
    }

    public void setTrustAll(boolean bl2) {
        this._trustAll = bl2;
        if (bl2) {
            this.setEndpointIdentificationAlgorithm(null);
        }
    }

    public boolean isRenegotiationAllowed() {
        return this._renegotiationAllowed;
    }

    public int getRenegotiationLimit() {
        return this._renegotiationLimit;
    }

    public String getCrlPath() {
        return this._crlPath;
    }

    public int getMaxCertPathLength() {
        return this._maxCertPathLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLContext getSslContext() {
        if (!this.isStarted()) {
            return this._setContext;
        }
        SslContextFactory sslContextFactory = this;
        synchronized (sslContextFactory) {
            if (this._factory == null) {
                throw new IllegalStateException("SslContextFactory reload failed");
            }
            return this._factory._context;
        }
    }

    public String getEndpointIdentificationAlgorithm() {
        return this._endpointIdentificationAlgorithm;
    }

    public void setEndpointIdentificationAlgorithm(String string) {
        this._endpointIdentificationAlgorithm = string;
    }

    protected KeyStore loadKeyStore(Resource resource) throws Exception {
        String string = Objects.toString(this._keyStorePassword, null);
        return CertificateUtils.getKeyStore(resource, this.getKeyStoreType(), this.getKeyStoreProvider(), string);
    }

    protected KeyStore loadTrustStore(Resource resource) throws Exception {
        String string = Objects.toString(this.getTrustStoreType(), this.getKeyStoreType());
        String string2 = Objects.toString(this.getTrustStoreProvider(), this.getKeyStoreProvider());
        Password password = this._trustStorePassword;
        if (resource == null || resource.equals(this._keyStoreResource)) {
            resource = this._keyStoreResource;
            if (password == null) {
                password = this._keyStorePassword;
            }
        }
        return CertificateUtils.getKeyStore(resource, string, string2, Objects.toString(password, null));
    }

    protected Collection<? extends CRL> loadCRL(String string) throws Exception {
        return CertificateUtils.loadCRL(string);
    }

    protected KeyManager[] getKeyManagers(KeyStore keyStore) throws Exception {
        KeyManager[] keyManagerArray = null;
        if (keyStore != null) {
            KeyManagerFactory keyManagerFactory = this.getKeyManagerFactoryInstance();
            keyManagerFactory.init(keyStore, this._keyManagerPassword == null ? (this._keyStorePassword == null ? null : this._keyStorePassword.toString().toCharArray()) : this._keyManagerPassword.toString().toCharArray());
            keyManagerArray = keyManagerFactory.getKeyManagers();
            if (keyManagerArray != null) {
                int n2;
                String string = this.getCertAlias();
                if (string != null) {
                    for (n2 = 0; n2 < keyManagerArray.length; ++n2) {
                        if (!(keyManagerArray[n2] instanceof X509ExtendedKeyManager)) continue;
                        keyManagerArray[n2] = new AliasedX509ExtendedKeyManager((X509ExtendedKeyManager)keyManagerArray[n2], string);
                    }
                }
                int n3 = n2 = this instanceof Server && ((Server)this).isSniRequired() ? 1 : 0;
                if (n2 != 0 || !this._certWilds.isEmpty() || this._certHosts.size() > 1 || this._certHosts.size() == 1 && this._aliasX509.size() > 1) {
                    for (int i2 = 0; i2 < keyManagerArray.length; ++i2) {
                        if (!(keyManagerArray[i2] instanceof X509ExtendedKeyManager)) continue;
                        keyManagerArray[i2] = this.newSniX509ExtendedKeyManager((X509ExtendedKeyManager)keyManagerArray[i2]);
                    }
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("managers={} for {}", keyManagerArray, this);
        }
        return keyManagerArray;
    }

    @Deprecated
    protected X509ExtendedKeyManager newSniX509ExtendedKeyManager(X509ExtendedKeyManager x509ExtendedKeyManager) {
        throw new IllegalStateException(String.format("KeyStores with multiple certificates are not supported on the base class %s. (Use %s or %s instead)", SslContextFactory.class.getName(), Server.class.getName(), Client.class.getName()));
    }

    protected TrustManager[] getTrustManagers(KeyStore keyStore, Collection<? extends CRL> collection) throws Exception {
        TrustManager[] trustManagerArray = null;
        if (keyStore != null) {
            if (this.isValidatePeerCerts() && "PKIX".equalsIgnoreCase(this.getTrustManagerFactoryAlgorithm())) {
                PKIXBuilderParameters pKIXBuilderParameters = this.newPKIXBuilderParameters(keyStore, collection);
                TrustManagerFactory trustManagerFactory = this.getTrustManagerFactoryInstance();
                trustManagerFactory.init(new CertPathTrustManagerParameters(pKIXBuilderParameters));
                trustManagerArray = trustManagerFactory.getTrustManagers();
            } else {
                TrustManagerFactory trustManagerFactory = this.getTrustManagerFactoryInstance();
                trustManagerFactory.init(keyStore);
                trustManagerArray = trustManagerFactory.getTrustManagers();
            }
        }
        return trustManagerArray;
    }

    protected PKIXBuilderParameters newPKIXBuilderParameters(KeyStore keyStore, Collection<? extends CRL> collection) throws Exception {
        PKIXBuilderParameters pKIXBuilderParameters = new PKIXBuilderParameters(keyStore, (CertSelector)new X509CertSelector());
        pKIXBuilderParameters.setMaxPathLength(this._maxCertPathLength);
        pKIXBuilderParameters.setRevocationEnabled(true);
        if (this._pkixCertPathChecker != null) {
            pKIXBuilderParameters.addCertPathChecker(this._pkixCertPathChecker);
        }
        if (collection != null && !collection.isEmpty()) {
            pKIXBuilderParameters.addCertStore(this.getCertStoreInstance(collection));
        }
        if (this._enableCRLDP) {
            System.setProperty("com.sun.security.enableCRLDP", "true");
        }
        if (this._enableOCSP) {
            Security.setProperty("ocsp.enable", "true");
            if (this._ocspResponderURL != null) {
                Security.setProperty("ocsp.responderURL", this._ocspResponderURL);
            }
        }
        return pKIXBuilderParameters;
    }

    public void selectProtocols(String[] stringArray, String[] stringArray2) {
        List<String> list = this.processIncludeExcludePatterns("Protocols", stringArray, stringArray2, this._includeProtocols, this._excludeProtocols);
        if (list.isEmpty()) {
            LOG.warn("No selected Protocols from {}", Arrays.asList(stringArray2));
        }
        this._selectedProtocols = list.toArray(new String[0]);
    }

    protected void selectCipherSuites(String[] stringArray, String[] stringArray2) {
        Comparator<String> comparator;
        List<String> list = this.processIncludeExcludePatterns("Cipher Suite", stringArray, stringArray2, this._includeCipherSuites, this._excludeCipherSuites);
        if (list.isEmpty()) {
            LOG.warn("No supported Cipher Suite from {}", Arrays.asList(stringArray2));
        }
        if ((comparator = this.getCipherComparator()) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sorting selected ciphers with {}", comparator);
            }
            list.sort(comparator);
        }
        this._selectedCipherSuites = list.toArray(new String[0]);
    }

    private List<String> processIncludeExcludePatterns(String string2, String[] stringArray, String[] stringArray2, Set<String> set, Set<String> set2) {
        Pattern pattern;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (set.isEmpty()) {
            arrayList.addAll(Arrays.asList(stringArray));
        } else {
            for (String string3 : set) {
                pattern = Pattern.compile(string3);
                boolean bl2 = false;
                for (String string4 : stringArray2) {
                    if (!pattern.matcher(string4).matches()) continue;
                    bl2 = true;
                    arrayList.add(string4);
                }
                if (bl2) continue;
                LOG.info("No {} matching '{}' is supported", string2, string3);
            }
        }
        for (String string3 : set2) {
            pattern = Pattern.compile(string3);
            arrayList.removeIf(string -> pattern.matcher((CharSequence)string).matches());
        }
        return arrayList;
    }

    private void checkIsStarted() {
        if (!this.isStarted()) {
            throw new IllegalStateException("!STARTED: " + this);
        }
    }

    public boolean isEnableCRLDP() {
        return this._enableCRLDP;
    }

    public boolean isEnableOCSP() {
        return this._enableOCSP;
    }

    public String getOcspResponderURL() {
        return this._ocspResponderURL;
    }

    public boolean isSessionCachingEnabled() {
        return this._sessionCachingEnabled;
    }

    public int getSslSessionCacheSize() {
        return this._sslSessionCacheSize;
    }

    public int getSslSessionTimeout() {
        return this._sslSessionTimeout;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this._hostnameVerifier;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this._hostnameVerifier = hostnameVerifier;
    }

    protected CertStore getCertStoreInstance(Collection<? extends CRL> collection) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        String string;
        block3: {
            string = "Collection";
            String string2 = this.getProvider();
            try {
                if (string2 != null) {
                    return CertStore.getInstance(string, (CertStoreParameters)new CollectionCertStoreParameters(collection), string2);
                }
            }
            catch (Throwable throwable) {
                LOG.info("Unable to get CertStore instance for type [{}] on provider [{}], using default", string, string2);
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug(throwable);
            }
        }
        return CertStore.getInstance(string, new CollectionCertStoreParameters(collection));
    }

    protected KeyManagerFactory getKeyManagerFactoryInstance() throws NoSuchAlgorithmException {
        String string;
        block3: {
            string = this.getKeyManagerFactoryAlgorithm();
            String string2 = this.getProvider();
            try {
                if (string2 != null) {
                    return KeyManagerFactory.getInstance(string, string2);
                }
            }
            catch (Throwable throwable) {
                LOG.info("Unable to get KeyManagerFactory instance for algorithm [{}] on provider [{}], using default", string, string2);
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug(throwable);
            }
        }
        return KeyManagerFactory.getInstance(string);
    }

    protected SecureRandom getSecureRandomInstance() throws NoSuchAlgorithmException {
        String string = this.getSecureRandomAlgorithm();
        if (string != null) {
            block4: {
                String string2 = this.getProvider();
                try {
                    if (string2 != null) {
                        return SecureRandom.getInstance(string, string2);
                    }
                }
                catch (Throwable throwable) {
                    LOG.info("Unable to get SecureRandom instance for algorithm [{}] on provider [{}], using default", string, string2);
                    if (!LOG.isDebugEnabled()) break block4;
                    LOG.debug(throwable);
                }
            }
            return SecureRandom.getInstance(string);
        }
        return null;
    }

    protected SSLContext getSSLContextInstance() throws NoSuchAlgorithmException {
        String string;
        block3: {
            string = this.getProtocol();
            String string2 = this.getProvider();
            try {
                if (string2 != null) {
                    return SSLContext.getInstance(string, string2);
                }
            }
            catch (Throwable throwable) {
                LOG.info("Unable to get SSLContext instance for protocol [{}] on provider [{}], using default", string, string2);
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug(throwable);
            }
        }
        return SSLContext.getInstance(string);
    }

    protected TrustManagerFactory getTrustManagerFactoryInstance() throws NoSuchAlgorithmException {
        String string;
        block3: {
            string = this.getTrustManagerFactoryAlgorithm();
            String string2 = this.getProvider();
            try {
                if (string2 != null) {
                    return TrustManagerFactory.getInstance(string, string2);
                }
            }
            catch (Throwable throwable) {
                LOG.info("Unable to get TrustManagerFactory instance for algorithm [{}] on provider [{}], using default", string, string2);
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug(throwable);
            }
        }
        return TrustManagerFactory.getInstance(string);
    }

    public SSLEngine newSSLEngine(String string, int n2) {
        this.checkIsStarted();
        SSLContext sSLContext = this.getSslContext();
        SSLEngine sSLEngine = this.isSessionCachingEnabled() ? sSLContext.createSSLEngine(string, n2) : sSLContext.createSSLEngine();
        this.customize(sSLEngine);
        return sSLEngine;
    }

    public void customize(SSLEngine sSLEngine) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Customize {}", sSLEngine);
        }
        sSLEngine.setSSLParameters(this.customize(sSLEngine.getSSLParameters()));
    }

    public SSLParameters customize(SSLParameters sSLParameters) {
        sSLParameters.setEndpointIdentificationAlgorithm(this.getEndpointIdentificationAlgorithm());
        sSLParameters.setUseCipherSuitesOrder(this.isUseCipherSuitesOrder());
        if (!this._certHosts.isEmpty() || !this._certWilds.isEmpty()) {
            sSLParameters.setSNIMatchers(Collections.singletonList(new AliasSNIMatcher()));
        }
        if (this._selectedCipherSuites != null) {
            sSLParameters.setCipherSuites(this._selectedCipherSuites);
        }
        if (this._selectedProtocols != null) {
            sSLParameters.setProtocols(this._selectedProtocols);
        }
        if (!(this instanceof Client)) {
            if (this.getWantClientAuth()) {
                sSLParameters.setWantClientAuth(true);
            }
            if (this.getNeedClientAuth()) {
                sSLParameters.setNeedClientAuth(true);
            }
        }
        return sSLParameters;
    }

    @Override
    public String toString() {
        return String.format("%s@%x[provider=%s,keyStore=%s,trustStore=%s]", this.getClass().getSimpleName(), this.hashCode(), this._sslProvider, this._keyStoreResource, this._trustStoreResource);
    }

    public static class X509ExtendedTrustManagerWrapper
    extends X509ExtendedTrustManager {
        private final X509ExtendedTrustManager trustManager;

        public X509ExtendedTrustManagerWrapper(X509ExtendedTrustManager x509ExtendedTrustManager) {
            this.trustManager = x509ExtendedTrustManager;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.trustManager == null ? new X509Certificate[]{} : this.trustManager.getAcceptedIssuers();
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            if (this.trustManager != null) {
                this.trustManager.checkClientTrusted(x509CertificateArray, string);
            }
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket) throws CertificateException {
            if (this.trustManager != null) {
                this.trustManager.checkClientTrusted(x509CertificateArray, string, socket);
            }
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine) throws CertificateException {
            if (this.trustManager != null) {
                this.trustManager.checkClientTrusted(x509CertificateArray, string, sSLEngine);
            }
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            if (this.trustManager != null) {
                this.trustManager.checkServerTrusted(x509CertificateArray, string);
            }
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket) throws CertificateException {
            if (this.trustManager != null) {
                this.trustManager.checkServerTrusted(x509CertificateArray, string, socket);
            }
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine) throws CertificateException {
            if (this.trustManager != null) {
                this.trustManager.checkServerTrusted(x509CertificateArray, string, sSLEngine);
            }
        }
    }

    public static class Server
    extends SslContextFactory
    implements SniX509ExtendedKeyManager.SniSelector {
        private boolean _sniRequired;
        private SniX509ExtendedKeyManager.SniSelector _sniSelector;

        public Server() {
            this.setEndpointIdentificationAlgorithm(null);
        }

        @Override
        public boolean getWantClientAuth() {
            return super.getWantClientAuth();
        }

        @Override
        public boolean getNeedClientAuth() {
            return super.getNeedClientAuth();
        }

        public boolean isSniRequired() {
            return this._sniRequired;
        }

        @Override
        protected KeyManager[] getKeyManagers(KeyStore keyStore) throws Exception {
            KeyManager[] keyManagerArray;
            block2: {
                block3: {
                    keyManagerArray = super.getKeyManagers(keyStore);
                    if (!this.isSniRequired()) break block2;
                    if (keyManagerArray == null) break block3;
                    if (!Arrays.stream(keyManagerArray).noneMatch(SniX509ExtendedKeyManager.class::isInstance)) break block2;
                }
                throw new IllegalStateException("No SNI Key managers when SNI is required");
            }
            return keyManagerArray;
        }

        public SniX509ExtendedKeyManager.SniSelector getSNISelector() {
            return this._sniSelector;
        }

        @Override
        public String sniSelect(String string, Principal[] principalArray, SSLSession sSLSession, String string2, Collection<X509> collection) {
            String string3;
            boolean bl2 = this.isSniRequired();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Selecting alias: keyType={}, sni={}, sniRequired={}, certs={}", string, String.valueOf(string2), bl2, collection);
            }
            if (string2 == null) {
                string3 = bl2 ? null : "delegate_no_sni_match";
            } else {
                List list = collection.stream().filter(x509 -> x509.matches(string2)).collect(Collectors.toList());
                if (list.isEmpty()) {
                    boolean bl3 = this.aliasCerts().values().stream().anyMatch(x509 -> x509.matches(string2));
                    string3 = bl2 || bl3 ? null : "delegate_no_sni_match";
                } else {
                    string3 = ((X509)list.get(0)).getAlias();
                    if (list.size() > 1) {
                        string3 = list.stream().min(Comparator.comparingInt(x509 -> x509.getWilds().size())).map(X509::getAlias).orElse(string3);
                    }
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Selected alias={}", String.valueOf(string3));
            }
            return string3;
        }

        @Override
        protected X509ExtendedKeyManager newSniX509ExtendedKeyManager(X509ExtendedKeyManager x509ExtendedKeyManager) {
            return new SniX509ExtendedKeyManager(x509ExtendedKeyManager, this);
        }
    }

    public static class Client
    extends SslContextFactory {
        private SniProvider sniProvider = (sSLEngine, list) -> list;

        public Client() {
            this(false);
        }

        public Client(boolean bl2) {
            super(bl2);
        }

        @Override
        protected void checkConfiguration() {
            this.checkTrustAll();
            this.checkEndPointIdentificationAlgorithm();
            super.checkConfiguration();
        }

        @Override
        protected X509ExtendedKeyManager newSniX509ExtendedKeyManager(X509ExtendedKeyManager x509ExtendedKeyManager) {
            return x509ExtendedKeyManager;
        }

        @Override
        public void customize(SSLEngine sSLEngine) {
            List<SNIServerName> list;
            SSLParameters sSLParameters = sSLEngine.getSSLParameters();
            List<SNIServerName> list2 = sSLParameters.getServerNames();
            if (list2 == null) {
                list2 = Collections.emptyList();
            }
            if ((list = this.getSNIProvider().apply(sSLEngine, list2)) != null && list != list2) {
                sSLParameters.setServerNames(list);
                sSLEngine.setSSLParameters(sSLParameters);
            }
            super.customize(sSLEngine);
        }

        public SniProvider getSNIProvider() {
            return this.sniProvider;
        }

        private static List<SNIServerName> getSniServerNames(SSLEngine sSLEngine, List<SNIServerName> list) {
            String string;
            if (list.isEmpty() && (string = sSLEngine.getPeerHost()) != null) {
                return Collections.singletonList(new SNIHostName(string.getBytes(StandardCharsets.US_ASCII)));
            }
            return list;
        }

        @FunctionalInterface
        public static interface SniProvider {
            public static final SniProvider NON_DOMAIN_SNI_PROVIDER = (sSLEngine, list) -> Client.access$400(sSLEngine, list);

            public List<SNIServerName> apply(SSLEngine var1, List<SNIServerName> var2);
        }
    }

    static class AliasSNIMatcher
    extends SNIMatcher {
        private String _host;

        AliasSNIMatcher() {
            super(0);
        }

        @Override
        public boolean matches(SNIServerName sNIServerName) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("SNI matching for {}", sNIServerName);
            }
            if (sNIServerName instanceof SNIHostName) {
                this._host = StringUtil.asciiToLowerCase(((SNIHostName)sNIServerName).getAsciiName());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("SNI host name {}", this._host);
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("No SNI host name for {}", sNIServerName);
            }
            return true;
        }

        public String getHost() {
            return this._host;
        }
    }

    private static class Factory {
        private final KeyStore _keyStore;
        private final KeyStore _trustStore;
        private final SSLContext _context;

        Factory(KeyStore keyStore, KeyStore keyStore2, SSLContext sSLContext) {
            this._keyStore = keyStore;
            this._trustStore = keyStore2;
            this._context = sSLContext;
        }
    }
}

