/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.thread;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.StringUtil;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.component.AbstractLifeCycle;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.component.Dumpable;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.thread.Scheduler;
import java.io.IOException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ScheduledExecutorScheduler
extends AbstractLifeCycle
implements Dumpable,
Scheduler {
    private final String name;
    private final boolean daemon;
    private final ClassLoader classloader;
    private final ThreadGroup threadGroup;
    private final int threads;
    private final AtomicInteger count = new AtomicInteger();
    private volatile ScheduledThreadPoolExecutor scheduler;
    private volatile Thread thread;

    public ScheduledExecutorScheduler() {
        this(null, false);
    }

    public ScheduledExecutorScheduler(String string, boolean bl2) {
        this(string, bl2, null);
    }

    public ScheduledExecutorScheduler(String string, boolean bl2, ClassLoader classLoader) {
        this(string, bl2, classLoader, null);
    }

    public ScheduledExecutorScheduler(String string, boolean bl2, ClassLoader classLoader, ThreadGroup threadGroup) {
        this(string, bl2, classLoader, threadGroup, -1);
    }

    public ScheduledExecutorScheduler(String string, boolean bl2, ClassLoader classLoader, ThreadGroup threadGroup, int n2) {
        this.name = StringUtil.isBlank(string) ? "Scheduler-" + this.hashCode() : string;
        this.daemon = bl2;
        this.classloader = classLoader == null ? Thread.currentThread().getContextClassLoader() : classLoader;
        this.threadGroup = threadGroup;
        this.threads = n2;
    }

    @Override
    protected void doStart() throws Exception {
        int n2 = this.threads > 0 ? this.threads : 1;
        this.scheduler = new ScheduledThreadPoolExecutor(n2, runnable -> {
            Thread thread = this.thread = new Thread(this.threadGroup, runnable, this.name + "-" + this.count.incrementAndGet());
            thread.setDaemon(this.daemon);
            thread.setContextClassLoader(this.classloader);
            return thread;
        });
        this.scheduler.setRemoveOnCancelPolicy(true);
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        this.scheduler.shutdownNow();
        super.doStop();
        this.scheduler = null;
    }

    @Override
    public Scheduler.Task schedule(Runnable runnable, long l2, TimeUnit timeUnit) {
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = this.scheduler;
        if (scheduledThreadPoolExecutor == null) {
            return () -> false;
        }
        ScheduledFuture<?> scheduledFuture = scheduledThreadPoolExecutor.schedule(runnable, l2, timeUnit);
        return new ScheduledFutureTask(scheduledFuture);
    }

    @Override
    public void dump(Appendable appendable, String string) throws IOException {
        Thread thread = this.thread;
        if (thread == null) {
            Dumpable.dumpObject(appendable, this);
        } else {
            Dumpable.dumpObjects(appendable, string, this, thread.getStackTrace());
        }
    }

    private static class ScheduledFutureTask
    implements Scheduler.Task {
        private final ScheduledFuture<?> scheduledFuture;

        ScheduledFutureTask(ScheduledFuture<?> scheduledFuture) {
            this.scheduledFuture = scheduledFuture;
        }

        @Override
        public boolean cancel() {
            return this.scheduledFuture.cancel(false);
        }
    }
}

