/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.MessageTooLargeException;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.WebSocketBehavior;

public class WebSocketPolicy {
    private int maxTextMessageSize = 65536;
    private int maxTextMessageBufferSize = 32768;
    private int maxBinaryMessageSize = 65536;
    private int maxBinaryMessageBufferSize = 32768;
    private long asyncWriteTimeout = 60000L;
    private long idleTimeout = 300000L;
    private int inputBufferSize = 4096;
    private final WebSocketBehavior behavior;

    public static WebSocketPolicy newClientPolicy() {
        return new WebSocketPolicy(WebSocketBehavior.CLIENT);
    }

    public WebSocketPolicy(WebSocketBehavior webSocketBehavior) {
        this.behavior = webSocketBehavior;
    }

    private void assertGreaterThan(String string, long l2, long l3) {
        if (l2 < l3) {
            throw new IllegalArgumentException(String.format("%s [%d] must be a greater than or equal to " + l3, string, l2));
        }
    }

    public void assertValidBinaryMessageSize(int n2) {
        if (this.maxBinaryMessageSize > 0 && n2 > this.maxBinaryMessageSize) {
            throw new MessageTooLargeException("Binary message size [" + n2 + "] exceeds maximum size [" + this.maxBinaryMessageSize + "]");
        }
    }

    public void assertValidTextMessageSize(int n2) {
        if (this.maxTextMessageSize > 0 && n2 > this.maxTextMessageSize) {
            throw new MessageTooLargeException("Text message size [" + n2 + "] exceeds maximum size [" + this.maxTextMessageSize + "]");
        }
    }

    public WebSocketPolicy clonePolicy() {
        WebSocketPolicy webSocketPolicy = new WebSocketPolicy(this.behavior);
        webSocketPolicy.idleTimeout = this.getIdleTimeout();
        webSocketPolicy.maxTextMessageSize = this.getMaxTextMessageSize();
        webSocketPolicy.maxTextMessageBufferSize = this.getMaxTextMessageBufferSize();
        webSocketPolicy.maxBinaryMessageSize = this.getMaxBinaryMessageSize();
        webSocketPolicy.maxBinaryMessageBufferSize = this.getMaxBinaryMessageBufferSize();
        webSocketPolicy.inputBufferSize = this.getInputBufferSize();
        webSocketPolicy.asyncWriteTimeout = this.getAsyncWriteTimeout();
        return webSocketPolicy;
    }

    @Deprecated
    public long getAsyncWriteTimeout() {
        return this.asyncWriteTimeout;
    }

    public WebSocketBehavior getBehavior() {
        return this.behavior;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public int getInputBufferSize() {
        return this.inputBufferSize;
    }

    public int getMaxBinaryMessageBufferSize() {
        return this.maxBinaryMessageBufferSize;
    }

    public int getMaxBinaryMessageSize() {
        return this.maxBinaryMessageSize;
    }

    public int getMaxTextMessageBufferSize() {
        return this.maxTextMessageBufferSize;
    }

    public int getMaxTextMessageSize() {
        return this.maxTextMessageSize;
    }

    public void setIdleTimeout(long l2) {
        this.assertGreaterThan("IdleTimeout", l2, 0L);
        this.idleTimeout = l2;
    }

    public void setInputBufferSize(int n2) {
        this.assertGreaterThan("InputBufferSize", n2, 1L);
        this.inputBufferSize = n2;
    }

    public void setMaxBinaryMessageSize(int n2) {
        this.assertGreaterThan("MaxBinaryMessageSize", n2, -1L);
        this.maxBinaryMessageSize = n2;
    }

    public void setMaxTextMessageSize(int n2) {
        this.assertGreaterThan("MaxTextMessageSize", n2, -1L);
        this.maxTextMessageSize = n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append("@").append(Integer.toHexString(this.hashCode()));
        stringBuilder.append("[behavior=").append((Object)this.getBehavior());
        stringBuilder.append(",maxTextMessageSize=").append(this.getMaxTextMessageSize());
        stringBuilder.append(",maxTextMessageBufferSize=").append(this.getMaxTextMessageBufferSize());
        stringBuilder.append(",maxBinaryMessageSize=").append(this.getMaxBinaryMessageSize());
        stringBuilder.append(",maxBinaryMessageBufferSize=").append(this.getMaxTextMessageBufferSize());
        stringBuilder.append(",asyncWriteTimeout=").append(this.getAsyncWriteTimeout());
        stringBuilder.append(",idleTimeout=").append(this.getIdleTimeout());
        stringBuilder.append(",inputBufferSize=").append(this.getInputBufferSize());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

