/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.extensions;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.util.QuoteUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ExtensionConfig {
    private final String name;
    private final Map<String, String> parameters;

    public static ExtensionConfig parse(String string) {
        return new ExtensionConfig(string);
    }

    public static List<ExtensionConfig> parseList(String ... stringArray) {
        ArrayList<ExtensionConfig> arrayList = new ArrayList<ExtensionConfig>();
        for (String string : stringArray) {
            Iterator<String> iterator = QuoteUtil.splitAt(string, ",");
            while (iterator.hasNext()) {
                String string2 = iterator.next();
                arrayList.add(ExtensionConfig.parse(string2));
            }
        }
        return arrayList;
    }

    public ExtensionConfig(String string) {
        Iterator<String> iterator = QuoteUtil.splitAt(string, ";");
        this.name = iterator.next();
        this.parameters = new HashMap<String, String>();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            Iterator<String> iterator2 = QuoteUtil.splitAt(string2, "=");
            String string3 = iterator2.next().trim();
            String string4 = null;
            if (iterator2.hasNext()) {
                string4 = iterator2.next();
            }
            this.parameters.put(string3, string4);
        }
    }

    public String getName() {
        return this.name;
    }

    public final String getParameterizedName() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.name);
        for (String string : this.parameters.keySet()) {
            stringBuilder.append(';');
            stringBuilder.append(string);
            String string2 = this.parameters.get(string);
            if (string2 == null) continue;
            stringBuilder.append('=');
            QuoteUtil.quoteIfNeeded(stringBuilder, string2, ";=");
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.getParameterizedName();
    }
}

