/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.jacoco.core.data;

import com.gradle.maven.extension.internal.dep.org.jacoco.core.data.ExecutionData;
import com.gradle.maven.extension.internal.dep.org.jacoco.core.data.IExecutionDataVisitor;
import com.gradle.maven.extension.internal.dep.org.jacoco.core.data.ISessionInfoVisitor;
import com.gradle.maven.extension.internal.dep.org.jacoco.core.data.SessionInfo;
import com.gradle.maven.extension.internal.dep.org.jacoco.core.internal.data.CompactDataOutput;
import java.io.IOException;
import java.io.OutputStream;

public class ExecutionDataWriter
implements IExecutionDataVisitor,
ISessionInfoVisitor {
    public static final char FORMAT_VERSION = (char)4103;
    protected final CompactDataOutput out;

    public ExecutionDataWriter(OutputStream outputStream) throws IOException {
        this.out = new CompactDataOutput(outputStream);
        this.writeHeader();
    }

    private void writeHeader() throws IOException {
        this.out.writeByte(1);
        this.out.writeChar(49344);
        this.out.writeChar(FORMAT_VERSION);
    }

    public void visitSessionInfo(SessionInfo sessionInfo) {
        try {
            this.out.writeByte(16);
            this.out.writeUTF(sessionInfo.getId());
            this.out.writeLong(sessionInfo.getStartTimeStamp());
            this.out.writeLong(sessionInfo.getDumpTimeStamp());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void visitClassExecution(ExecutionData executionData) {
        if (executionData.hasHits()) {
            try {
                this.out.writeByte(17);
                this.out.writeLong(executionData.getId());
                this.out.writeUTF(executionData.getName());
                this.out.writeBooleanArray(executionData.getProbes());
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }
}

