/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast;

import com.gradle.maven.extension.internal.dep.org.springframework.asm.MethodVisitor;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypedValue;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.CodeFlow;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.Literal;
import com.gradle.maven.extension.internal.dep.org.springframework.util.StringUtils;

public class StringLiteral
extends Literal {
    private final TypedValue value;

    public StringLiteral(String string, int n2, int n3, String string2) {
        super(string, n2, n3);
        char c2 = string2.charAt(0);
        String string3 = string2.substring(1, string2.length() - 1);
        string3 = c2 == '\'' ? StringUtils.replace(string3, "''", "'") : StringUtils.replace(string3, "\"\"", "\"");
        this.value = new TypedValue(string3);
        this.exitTypeDescriptor = "Ljava/lang/String";
    }

    @Override
    public TypedValue getLiteralValue() {
        return this.value;
    }

    @Override
    public String toString() {
        String string = String.valueOf(this.getLiteralValue().getValue());
        string = StringUtils.replace(string, "'", "''");
        return "'" + string + "'";
    }

    @Override
    public boolean isCompilable() {
        return true;
    }

    @Override
    public void generateCode(MethodVisitor methodVisitor, CodeFlow codeFlow) {
        methodVisitor.visitLdcInsn(this.value.getValue());
        codeFlow.pushDescriptor(this.exitTypeDescriptor);
    }
}

