/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.mojo;

import com.gradle.c.b;
import com.gradle.enterprise.version.buildagent.BuildAgentToolVersion;
import com.gradle.maven.common.d;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.stax.WstxInputFactory;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.stax.WstxOutputFactory;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonCreator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonRootName;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.SerializationFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.xml.XmlFactory;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.gradle.scan.plugin.internal.meta.CurrentBuildAgentVersion;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=Mojo.class, hint="gradle-enterprise-init-mojo")
public class InitMojo
extends AbstractMojo {
    @b
    private URI url;
    private final RuntimeInformation runtimeInformation;
    private final MavenSession mavenSession;

    @Inject
    public InitMojo(RuntimeInformation runtimeInformation, MavenSession mavenSession) {
        this.runtimeInformation = runtimeInformation;
        this.mavenSession = mavenSession;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.checkMavenVersion();
        Path path = this.getOrCreateMvnFolder();
        if (InitMojo.updateMavenExtensionsFile(path, this.getLog())) {
            this.updateGradleConfigurationFile(path);
            this.updateGitIgnore();
        }
    }

    private void checkMavenVersion() throws MojoFailureException {
        BuildAgentToolVersion buildAgentToolVersion = BuildAgentToolVersion.b(com.gradle.enterprise.version.buildagent.b.parse(this.runtimeInformation.getMavenVersion()), CurrentBuildAgentVersion.get());
        if (d.a(buildAgentToolVersion.toolVersion)) {
            String string = String.join((CharSequence)" ", d.a(buildAgentToolVersion.agentVersion, buildAgentToolVersion.toolVersion));
            throw new MojoFailureException(string);
        }
    }

    private Path getOrCreateMvnFolder() throws MojoFailureException {
        try {
            File file = this.mavenSession.getTopLevelProject().getBasedir();
            Path path = file.toPath().resolve(".mvn");
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createDirectory(path, new FileAttribute[0]);
            }
            return path;
        }
        catch (IOException iOException) {
            throw new MojoFailureException("Failed creating .mvn folder", (Throwable)iOException);
        }
    }

    private static boolean updateMavenExtensionsFile(Path path, Log log) throws MojoFailureException {
        try {
            return MavenExtensionsFileManager.load(path.resolve("extensions.xml"), log).insert(Objects.requireNonNull(CurrentBuildAgentVersion.get().asString()));
        }
        catch (IOException iOException) {
            throw new MojoFailureException("Failed loading extensions file", (Throwable)iOException);
        }
    }

    private void updateGradleConfigurationFile(Path path) throws MojoFailureException {
        GradleEnterpriseConfigurationManager.load(path.resolve("gradle-enterprise.xml"), this.url).createGradleConfigurationFileIfNeeded();
    }

    private void updateGitIgnore() throws MojoFailureException {
        GitIgnoreManager.load(this.mavenSession.getTopLevelProject().getBasedir().toPath().resolve(".gitignore")).insertIgnoreWorkspaceId();
    }

    static class MavenExtensionsFileManager {
        private static final String GE_GROUP_ID = "com.gradle";
        private static final String GE_ARTIFACT_ID = "gradle-enterprise-maven-extension";
        private final Path extensionsPath;
        private final Log log;

        private MavenExtensionsFileManager(Path path, Log log) {
            this.extensionsPath = path;
            this.log = log;
        }

        static MavenExtensionsFileManager load(Path path, Log log) throws IOException {
            if (!Files.exists(path, new LinkOption[0])) {
                Files.write(path, Collections.singleton("<?xml version=\"1.0\" encoding=\"UTF-8\"?><extensions></extensions>"), new OpenOption[0]);
            }
            return new MavenExtensionsFileManager(path, log);
        }

        boolean insert(String string) throws MojoFailureException {
            try {
                XmlMapper xmlMapper = new XmlMapper(new XmlFactory(new WstxInputFactory(), new WstxOutputFactory()));
                xmlMapper.enable(SerializationFeature.INDENT_OUTPUT);
                Extensions extensions = xmlMapper.readValue(this.extensionsPath.toFile(), Extensions.class);
                if (extensions.gradleEnterpriseExtensionExists()) {
                    this.log.info((CharSequence)("A Gradle Enterprise Maven extension is already configured on this project in " + this.extensionsPath));
                    return false;
                }
                extensions.addExtension(Extension.gradleEnterpriseExtension(string));
                xmlMapper.writeValue(this.extensionsPath.toFile(), (Object)extensions);
                return true;
            }
            catch (IOException iOException) {
                throw new MojoFailureException("Failed inserting Gradle Enterprise extension", (Throwable)iOException);
            }
        }

        @JacksonXmlRootElement(localName="extensions")
        @JsonRootName(value="extensions")
        static class Extensions {
            @JacksonXmlElementWrapper(useWrapping=false)
            @JacksonXmlProperty(localName="extension")
            private final List<Extension> extensions = new ArrayList<Extension>();

            Extensions() {
            }

            void addExtension(Extension extension) {
                this.extensions.add(extension);
            }

            boolean gradleEnterpriseExtensionExists() {
                return this.extensions.stream().anyMatch(extension -> MavenExtensionsFileManager.GE_ARTIFACT_ID.equals(extension.artifactId) && MavenExtensionsFileManager.GE_GROUP_ID.equals(extension.groupId));
            }
        }

        @JacksonXmlRootElement(localName="extension")
        static class Extension {
            @JacksonXmlProperty(localName="groupId")
            final String groupId;
            @JacksonXmlProperty(localName="artifactId")
            final String artifactId;
            @JacksonXmlProperty(localName="version")
            final String version;

            @JsonCreator
            public Extension(@JacksonXmlProperty(localName="groupId") String string, @JacksonXmlProperty(localName="artifactId") String string2, @JacksonXmlProperty(localName="version") String string3) {
                this.groupId = string;
                this.artifactId = string2;
                this.version = string3;
            }

            static Extension gradleEnterpriseExtension(String string) {
                return new Extension(MavenExtensionsFileManager.GE_GROUP_ID, MavenExtensionsFileManager.GE_ARTIFACT_ID, string);
            }
        }
    }

    static class GradleEnterpriseConfigurationManager {
        private static final String CONFIG = "<gradleEnterprise>\n  <server>\n    <url>%s</url>\n  </server>\n</gradleEnterprise>";
        private final Path gradleEnterpriseConfiguration;
        @b
        private final URI geUrl;

        private GradleEnterpriseConfigurationManager(Path path, @b URI uRI) {
            this.gradleEnterpriseConfiguration = path;
            this.geUrl = uRI;
        }

        static GradleEnterpriseConfigurationManager load(Path path, @b URI uRI) {
            return new GradleEnterpriseConfigurationManager(path, uRI);
        }

        void createGradleConfigurationFileIfNeeded() throws MojoFailureException {
            try {
                if (this.geUrl != null && !Files.exists(this.gradleEnterpriseConfiguration, new LinkOption[0])) {
                    Files.write(this.gradleEnterpriseConfiguration, String.format(CONFIG, this.geUrl).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }
            }
            catch (IOException iOException) {
                throw new MojoFailureException("Failed to create Gradle configuration file", (Throwable)iOException);
            }
        }
    }

    static class GitIgnoreManager {
        private final Path gitIgnore;

        private GitIgnoreManager(Path path) {
            this.gitIgnore = path;
        }

        static GitIgnoreManager load(Path path) {
            return new GitIgnoreManager(path);
        }

        void insertIgnoreWorkspaceId() throws MojoFailureException {
            try {
                if (!Files.exists(this.gitIgnore, new LinkOption[0])) {
                    Files.createFile(this.gitIgnore, new FileAttribute[0]);
                }
                String string = ".mvn/.gradle-enterprise/gradle-enterprise-workspace-id";
                String string2 = new String(Files.readAllBytes(this.gitIgnore), StandardCharsets.UTF_8);
                if (!string2.contains(string)) {
                    String string3 = string2.isEmpty() ? string : (string2.endsWith(System.lineSeparator()) ? string + System.lineSeparator() : System.lineSeparator() + string + System.lineSeparator());
                    Files.write(this.gitIgnore, string3.getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
                }
            }
            catch (IOException iOException) {
                throw new MojoFailureException("Failed updating .gitignore", (Throwable)iOException);
            }
        }
    }
}

