/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.archive.impl;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.AbstractIterator;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.zip.ZipInputStream;
import org.gradle.api.internal.file.archive.ZipEntry;
import org.gradle.api.internal.file.archive.ZipInput;
import org.gradle.api.internal.file.archive.impl.AbstractZipEntry;
import org.gradle.internal.file.FileException;
import org.gradle.internal.io.IoFunction;

public class StreamZipInput
implements ZipInput {
    private final ZipInputStream inputStream;

    public StreamZipInput(InputStream inputStream) {
        this.inputStream = new ZipInputStream(inputStream);
    }

    @Override
    public Iterator<ZipEntry> iterator() {
        return new AbstractIterator<ZipEntry>(){

            @Override
            protected ZipEntry computeNext() {
                java.util.zip.ZipEntry zipEntry;
                try {
                    zipEntry = StreamZipInput.this.inputStream.getNextEntry();
                }
                catch (IOException iOException) {
                    throw new FileException(iOException);
                }
                return zipEntry == null ? (ZipEntry)this.endOfData() : new StreamZipEntry(zipEntry);
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    private class StreamZipEntry
    extends AbstractZipEntry {
        private boolean opened;

        public StreamZipEntry(java.util.zip.ZipEntry zipEntry) {
            super(zipEntry);
        }

        @Override
        public <T> T withInputStream(IoFunction<InputStream, T> ioFunction) throws IOException {
            if (this.opened) {
                throw new IllegalStateException("The input stream for " + this.getName() + " has already been opened.  It cannot be reopened again.");
            }
            this.opened = true;
            try {
                T t2 = ioFunction.apply(StreamZipInput.this.inputStream);
                return t2;
            }
            finally {
                this.closeEntry();
            }
        }

        private void closeEntry() {
            try {
                StreamZipInput.this.inputStream.closeEntry();
            }
            catch (IOException iOException) {
                throw new FileException(iOException);
            }
        }

        @Override
        public boolean canReopen() {
            return false;
        }
    }
}

