/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.pattern;

import org.gradle.api.internal.file.pattern.PathMatcher;
import org.gradle.api.internal.file.pattern.PatternStep;

public class FixedStepPathMatcher
implements PathMatcher {
    private final PatternStep step;
    private final PathMatcher next;
    private final int minSegments;
    private final int maxSegments;

    public FixedStepPathMatcher(PatternStep patternStep, PathMatcher pathMatcher) {
        this.step = patternStep;
        this.next = pathMatcher;
        this.minSegments = 1 + pathMatcher.getMinSegments();
        this.maxSegments = pathMatcher.getMaxSegments() == Integer.MAX_VALUE ? Integer.MAX_VALUE : pathMatcher.getMaxSegments() + 1;
    }

    public String toString() {
        return "{fixed-step: " + this.step + ", next: " + this.next + "}";
    }

    @Override
    public int getMinSegments() {
        return this.minSegments;
    }

    @Override
    public int getMaxSegments() {
        return this.maxSegments;
    }

    @Override
    public boolean matches(String[] stringArray, int n2) {
        int n3 = stringArray.length - n2;
        if (n3 < this.minSegments || n3 > this.maxSegments) {
            return false;
        }
        if (!this.step.matches(stringArray[n2])) {
            return false;
        }
        return this.next.matches(stringArray, n2 + 1);
    }

    @Override
    public boolean isPrefix(String[] stringArray, int n2) {
        if (n2 == stringArray.length) {
            return true;
        }
        if (!this.step.matches(stringArray[n2])) {
            return false;
        }
        if (n2 + 1 == stringArray.length) {
            return true;
        }
        return this.next.isPrefix(stringArray, n2 + 1);
    }
}

