/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.pattern;

import com.gradle.maven.extension.internal.dep.com.google.common.base.CharMatcher;
import com.gradle.maven.extension.internal.dep.com.google.common.base.Splitter;
import java.util.List;
import org.gradle.api.internal.file.pattern.AnythingMatcher;
import org.gradle.api.internal.file.pattern.EndOfPathMatcher;
import org.gradle.api.internal.file.pattern.FixedStepPathMatcher;
import org.gradle.api.internal.file.pattern.GreedyPathMatcher;
import org.gradle.api.internal.file.pattern.PathMatcher;
import org.gradle.api.internal.file.pattern.PatternMatcher;
import org.gradle.api.internal.file.pattern.PatternStepFactory;

public class PatternMatcherFactory {
    private static final EndOfPathMatcher END_OF_PATH_MATCHER = new EndOfPathMatcher();
    private static final Splitter PATH_SPLITTER = Splitter.on(CharMatcher.anyOf("\\/")).omitEmptyStrings();

    public static PatternMatcher getPatternMatcher(boolean bl2, boolean bl3, String string) {
        PathMatcher pathMatcher = PatternMatcherFactory.compile(bl3, string);
        return new DefaultPatternMatcher(bl2, pathMatcher);
    }

    public static PathMatcher compile(boolean bl2, String string) {
        if (string.length() == 0) {
            return END_OF_PATH_MATCHER;
        }
        if (string.endsWith("/") || string.endsWith("\\")) {
            string = string + "**";
        }
        List<String> list = PATH_SPLITTER.splitToList(string);
        return PatternMatcherFactory.compile(list, 0, bl2);
    }

    private static PathMatcher compile(List<String> list, int n2, boolean bl2) {
        int n3;
        if (n2 >= list.size()) {
            return END_OF_PATH_MATCHER;
        }
        for (n3 = n2; n3 < list.size() && list.get(n3).equals("**"); ++n3) {
        }
        if (n3 > n2) {
            if (n3 == list.size()) {
                return new AnythingMatcher();
            }
            return new GreedyPathMatcher(PatternMatcherFactory.compile(list, n3, bl2));
        }
        return new FixedStepPathMatcher(PatternStepFactory.getStep(list.get(n3), bl2), PatternMatcherFactory.compile(list, n3 + 1, bl2));
    }

    static class DefaultPatternMatcher
    extends PatternMatcher {
        private final boolean partialMatchDirs;
        private final PathMatcher pathMatcher;

        public DefaultPatternMatcher(boolean bl2, PathMatcher pathMatcher) {
            this.partialMatchDirs = bl2;
            this.pathMatcher = pathMatcher;
        }

        @Override
        public boolean test(String[] stringArray, boolean bl2) {
            if (bl2 || !this.partialMatchDirs) {
                return this.pathMatcher.matches(stringArray, 0);
            }
            return this.pathMatcher.isPrefix(stringArray, 0);
        }
    }
}

