/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.normalization.java;

import com.gradle.maven.extension.internal.dep.org.objectweb.asm.ClassReader;
import com.gradle.maven.extension.internal.dep.org.objectweb.asm.ClassWriter;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.normalization.java.ApiMemberWriterFactory;
import org.gradle.internal.normalization.java.impl.ApiMemberSelector;
import org.gradle.internal.normalization.java.impl.ApiMemberWriter;
import org.gradle.internal.normalization.java.impl.MethodStubbingApiMemberAdapter;

public class ApiClassExtractor {
    private static final Pattern LOCAL_CLASS_PATTERN = Pattern.compile(".+\\$[0-9]+(?:[\\p{Alnum}_$]+)?$");
    private final Set<String> exportedPackages;
    private final boolean apiIncludesPackagePrivateMembers;
    private final ApiMemberWriterFactory apiMemberWriterFactory;

    public ApiClassExtractor(Set<String> set) {
        this(set, classWriter -> new ApiMemberWriter(new MethodStubbingApiMemberAdapter(classWriter)));
    }

    public ApiClassExtractor(Set<String> set, ApiMemberWriterFactory apiMemberWriterFactory) {
        this.exportedPackages = set.isEmpty() ? null : set;
        this.apiIncludesPackagePrivateMembers = set.isEmpty();
        this.apiMemberWriterFactory = apiMemberWriterFactory;
    }

    private boolean shouldExtractApiClassFrom(ClassReader classReader) {
        if (!ApiMemberSelector.isCandidateApiMember(classReader.getAccess(), this.apiIncludesPackagePrivateMembers)) {
            return false;
        }
        String string = classReader.getClassName();
        if (ApiClassExtractor.isLocalClass(string)) {
            return false;
        }
        return this.exportedPackages == null || this.exportedPackages.contains(ApiClassExtractor.packageNameOf(string));
    }

    public Optional<byte[]> extractApiClassFrom(ClassReader classReader) {
        if (!this.shouldExtractApiClassFrom(classReader)) {
            return Optional.empty();
        }
        ClassWriter classWriter = new ClassWriter(1);
        ApiMemberSelector apiMemberSelector = new ApiMemberSelector(classReader.getClassName(), this.apiMemberWriterFactory.makeApiMemberWriter(classWriter), this.apiIncludesPackagePrivateMembers);
        classReader.accept(apiMemberSelector, 6);
        if (apiMemberSelector.isPrivateInnerClass()) {
            return Optional.empty();
        }
        return Optional.of(classWriter.toByteArray());
    }

    public void appendConfigurationToHasher(Hasher hasher) {
        hasher.putString(this.getClass().getName());
        if (this.exportedPackages != null) {
            this.exportedPackages.forEach(hasher::putString);
        }
    }

    private static String packageNameOf(String string) {
        int n2 = string.lastIndexOf(47);
        return n2 > 0 ? string.substring(0, n2).replace('/', '.') : "";
    }

    private static boolean isLocalClass(String string) {
        return LOCAL_CLASS_PATTERN.matcher(string).matches();
    }
}

