/*
 * Decompiled with CFR 0.152.
 */
package com.groupon.maven.plugin.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.groupon.maven.plugin.json.Validation;
import com.groupon.maven.plugin.json.ValidatorExecutor;
import com.groupon.maven.plugin.json.ValidatorRequest;
import com.groupon.maven.plugin.json.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.resource.ResourceManager;
import org.codehaus.plexus.util.StringUtils;

@Component(role=ValidatorExecutor.class, hint="default", instantiationStrategy="per-lookup")
public class DefaultValidatorExecutor
implements ValidatorExecutor {
    @Requirement(hint="default")
    private ResourceManager inputLocator;
    private ValidatorRequest request;

    @Override
    public void executeValidator(ValidatorRequest requestInput) throws MojoFailureException, MojoExecutionException {
        this.request = requestInput;
        DefaultValidatorExecutor.configureInputLocator(this.request.getProject(), this.inputLocator);
        for (Validation validation : this.request.getValidations()) {
            this.performValidation(validation);
        }
    }

    private void performValidation(Validation validation) throws MojoExecutionException, MojoFailureException {
        ArrayList<String> jsonFiles = new ArrayList<String>();
        String schemaFile = null;
        if (!StringUtils.isEmpty((String)validation.getDirectory())) {
            jsonFiles.addAll(FileUtils.getListOfFiles(validation));
        }
        if (!StringUtils.isEmpty((String)validation.getJsonFile())) {
            jsonFiles.add(validation.getJsonFile());
        }
        if (!StringUtils.isEmpty((String)validation.getJsonSchema())) {
            schemaFile = FileUtils.locateInputFile(validation.getJsonSchema(), this.inputLocator);
        }
        for (String jsonFile : jsonFiles) {
            if (schemaFile != null) {
                this.validateAgainstSchema(jsonFile, schemaFile);
                continue;
            }
            this.loadJson(jsonFile);
        }
    }

    private void validateAgainstSchema(String jsonDataFile, String schemaFile) throws MojoExecutionException, MojoFailureException {
        JsonNode schemaResource = this.loadJson(schemaFile);
        JsonNode fileResouce = this.loadJson(jsonDataFile);
        JsonSchemaFactory factory = JsonSchemaFactory.byDefault();
        try {
            JsonSchema schema = factory.getJsonSchema(schemaResource);
            ProcessingReport report = schema.validate(fileResouce);
            if (!report.isSuccess()) {
                this.request.getLog().error((CharSequence)("Failed validating JSON from " + jsonDataFile + " against " + schemaFile));
                throw new MojoFailureException(report.toString());
            }
            this.request.getLog().info((CharSequence)("Successfully validated JSON from " + jsonDataFile + " against " + schemaFile));
        }
        catch (ProcessingException e) {
            this.request.getLog().error((Throwable)e);
            throw new MojoFailureException(e.getMessage());
        }
    }

    private JsonNode loadJson(String file) throws MojoExecutionException {
        try {
            JsonNode node = JsonLoader.fromPath((String)file);
            this.request.getLog().info((CharSequence)("Loaded JSON from " + file));
            return node;
        }
        catch (IOException io) {
            this.request.getLog().error((Throwable)io);
            throw new MojoExecutionException("IOException loading JSON", (Exception)io);
        }
    }

    static void configureInputLocator(MavenProject project, ResourceManager inputLocator) {
        inputLocator.setOutputDirectory(new File(project.getBuild().getDirectory()));
        for (MavenProject parent = project; parent != null && parent.getFile() != null; parent = parent.getParent()) {
            File dir = parent.getFile().getParentFile();
            inputLocator.addSearchPath("file", dir.getAbsolutePath());
        }
        inputLocator.addSearchPath("url", "");
    }
}

