/*
 * Decompiled with CFR 0.152.
 */
package com.groupon.maven.plugin.json.util;

import com.groupon.maven.plugin.json.Validation;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.resource.ResourceManager;
import org.codehaus.plexus.resource.loader.FileResourceCreationException;
import org.codehaus.plexus.resource.loader.ResourceNotFoundException;
import org.codehaus.plexus.util.StringUtils;

public final class FileUtils {
    private FileUtils() {
    }

    public static List<String> getListOfFiles(Validation validation) throws MojoExecutionException {
        File directory = new File(validation.getDirectory());
        String includes = validation.getIncludes().isEmpty() ? "**/*" : StringUtils.join(validation.getIncludes().iterator(), (String)",");
        try {
            List files = org.codehaus.plexus.util.FileUtils.getFileNames((File)directory, (String)includes, (String)StringUtils.join(validation.getExcludes().iterator(), (String)","), (boolean)true);
            return files;
        }
        catch (IOException | IllegalStateException e) {
            throw new MojoExecutionException(String.format("Exception while locating json input files; directory=%s includes=%s", directory, includes), e);
        }
    }

    public static String locateInputFile(String inputResource, ResourceManager inputLocator) throws MojoExecutionException {
        try {
            return inputLocator.getResourceAsFile(inputResource).getAbsolutePath();
        }
        catch (FileResourceCreationException | ResourceNotFoundException e) {
            throw new MojoExecutionException(String.format("Exception while locating input file; file=%s", inputResource), (Exception)e);
        }
    }
}

