/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.util.ArrayList;
import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.Right;
import org.h2.engine.RightOwner;
import org.h2.engine.Role;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.table.Table;
import org.h2.util.New;

public class GrantRevoke
extends DefineCommand {
    private ArrayList<String> roleNames;
    private int operationType;
    private int rightMask;
    private final ArrayList<Table> tables = New.arrayList();
    private RightOwner grantee;

    public GrantRevoke(Session session) {
        super(session);
    }

    public void setOperationType(int n) {
        this.operationType = n;
    }

    public void addRight(int n) {
        this.rightMask |= n;
    }

    public void addRoleName(String string) {
        if (this.roleNames == null) {
            this.roleNames = New.arrayList();
        }
        this.roleNames.add(string);
    }

    public void setGranteeName(String string) {
        Database database = this.session.getDatabase();
        this.grantee = database.findUser(string);
        if (this.grantee == null) {
            this.grantee = database.findRole(string);
            if (this.grantee == null) {
                throw DbException.get(90071, string);
            }
        }
    }

    @Override
    public int update() {
        this.session.getUser().checkAdmin();
        this.session.commit(true);
        Database database = this.session.getDatabase();
        if (this.roleNames != null) {
            for (String string : this.roleNames) {
                Role role = database.findRole(string);
                if (role == null) {
                    throw DbException.get(90070, string);
                }
                if (this.operationType == 49) {
                    this.grantRole(role);
                    continue;
                }
                if (this.operationType == 50) {
                    this.revokeRole(role);
                    continue;
                }
                DbException.throwInternalError("type=" + this.operationType);
            }
        } else if (this.operationType == 49) {
            this.grantRight();
        } else if (this.operationType == 50) {
            this.revokeRight();
        } else {
            DbException.throwInternalError("type=" + this.operationType);
        }
        return 0;
    }

    private void grantRight() {
        Database database = this.session.getDatabase();
        for (Table table : this.tables) {
            Right right = this.grantee.getRightForTable(table);
            if (right == null) {
                int n = this.getObjectId();
                right = new Right(database, n, this.grantee, this.rightMask, table);
                this.grantee.grantRight(table, right);
                database.addDatabaseObject(this.session, right);
                continue;
            }
            right.setRightMask(right.getRightMask() | this.rightMask);
            database.update(this.session, right);
        }
    }

    private void grantRole(Role role) {
        Object object;
        if (role != this.grantee && this.grantee.isRoleGranted(role)) {
            return;
        }
        if (this.grantee instanceof Role && role.isRoleGranted((Role)(object = (Role)this.grantee))) {
            throw DbException.get(90074, role.getSQL());
        }
        object = this.session.getDatabase();
        int n = this.getObjectId();
        Right right = new Right((Database)object, n, this.grantee, role);
        ((Database)object).addDatabaseObject(this.session, right);
        this.grantee.grantRole(role, right);
    }

    private void revokeRight() {
        for (Table table : this.tables) {
            Right right = this.grantee.getRightForTable(table);
            if (right == null) continue;
            int n = right.getRightMask();
            int n2 = n & ~this.rightMask;
            Database database = this.session.getDatabase();
            if (n2 == 0) {
                database.removeDatabaseObject(this.session, right);
                continue;
            }
            right.setRightMask(n2);
            database.update(this.session, right);
        }
    }

    private void revokeRole(Role role) {
        Right right = this.grantee.getRightForRole(role);
        if (right == null) {
            return;
        }
        Database database = this.session.getDatabase();
        database.removeDatabaseObject(this.session, right);
    }

    @Override
    public boolean isTransactional() {
        return false;
    }

    public void addTable(Table table) {
        this.tables.add(table);
    }

    @Override
    public int getType() {
        return this.operationType;
    }

    public boolean isRoleMode() {
        return this.roleNames != null;
    }

    public boolean isRightMode() {
        return this.rightMask != 0;
    }
}

