/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.h2.api.IntervalQualifier;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.expression.function.DateTimeFunctions;
import org.h2.message.DbException;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.util.DateTimeUtils;
import org.h2.util.IntervalUtils;
import org.h2.value.DataType;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueDate;
import org.h2.value.ValueInterval;
import org.h2.value.ValueNull;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestampTimeZone;

public class IntervalOperation
extends Expression {
    private final IntervalOpType opType;
    private Expression left;
    private Expression right;
    private TypeInfo type;

    private static BigInteger nanosFromValue(Value value) {
        long[] lArray = DateTimeUtils.dateAndTimeFromValue(value);
        return BigInteger.valueOf(DateTimeUtils.absoluteDayFromDateValue(lArray[0])).multiply(IntervalUtils.NANOS_PER_DAY_BI).add(BigInteger.valueOf(lArray[1]));
    }

    public IntervalOperation(IntervalOpType intervalOpType, Expression expression, Expression expression2) {
        this.opType = intervalOpType;
        this.left = expression;
        this.right = expression2;
        int n = expression.getType().getValueType();
        int n2 = expression2.getType().getValueType();
        switch (intervalOpType) {
            case INTERVAL_PLUS_INTERVAL: 
            case INTERVAL_MINUS_INTERVAL: {
                this.type = TypeInfo.getTypeInfo(Value.getHigherOrder(n, n2));
                break;
            }
            case DATETIME_PLUS_INTERVAL: 
            case DATETIME_MINUS_INTERVAL: 
            case INTERVAL_MULTIPLY_NUMERIC: 
            case INTERVAL_DIVIDE_NUMERIC: {
                this.type = expression.getType();
                break;
            }
            case DATETIME_MINUS_DATETIME: {
                this.type = n == 9 && n2 == 9 ? TypeInfo.TYPE_INTERVAL_HOUR_TO_SECOND : (n == 10 && n2 == 10 ? TypeInfo.TYPE_INTERVAL_DAY : TypeInfo.TYPE_INTERVAL_DAY_TO_SECOND);
            }
        }
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder) {
        stringBuilder.append('(');
        this.left.getSQL(stringBuilder).append(' ').append(this.getOperationToken()).append(' ');
        return this.right.getSQL(stringBuilder).append(')');
    }

    private char getOperationToken() {
        switch (this.opType) {
            case INTERVAL_PLUS_INTERVAL: 
            case DATETIME_PLUS_INTERVAL: {
                return '+';
            }
            case INTERVAL_MINUS_INTERVAL: 
            case DATETIME_MINUS_INTERVAL: 
            case DATETIME_MINUS_DATETIME: {
                return '-';
            }
            case INTERVAL_MULTIPLY_NUMERIC: {
                return '*';
            }
            case INTERVAL_DIVIDE_NUMERIC: {
                return '/';
            }
        }
        throw DbException.throwInternalError("opType=" + (Object)((Object)this.opType));
    }

    @Override
    public Value getValue(Session session) {
        Value value = this.left.getValue(session);
        Value value2 = this.right.getValue(session);
        if (value == ValueNull.INSTANCE || value2 == ValueNull.INSTANCE) {
            return ValueNull.INSTANCE;
        }
        int n = value.getValueType();
        int n2 = value2.getValueType();
        switch (this.opType) {
            case INTERVAL_PLUS_INTERVAL: 
            case INTERVAL_MINUS_INTERVAL: {
                BigInteger bigInteger = IntervalUtils.intervalToAbsolute((ValueInterval)value);
                BigInteger bigInteger2 = IntervalUtils.intervalToAbsolute((ValueInterval)value2);
                return IntervalUtils.intervalFromAbsolute(IntervalQualifier.valueOf(Value.getHigherOrder(n, n2) - 26), this.opType == IntervalOpType.INTERVAL_PLUS_INTERVAL ? bigInteger.add(bigInteger2) : bigInteger.subtract(bigInteger2));
            }
            case DATETIME_PLUS_INTERVAL: 
            case DATETIME_MINUS_INTERVAL: {
                return this.getDateTimeWithInterval(value, value2, n, n2);
            }
            case INTERVAL_MULTIPLY_NUMERIC: 
            case INTERVAL_DIVIDE_NUMERIC: {
                BigDecimal bigDecimal = new BigDecimal(IntervalUtils.intervalToAbsolute((ValueInterval)value));
                BigDecimal bigDecimal2 = value2.getBigDecimal();
                return IntervalUtils.intervalFromAbsolute(IntervalQualifier.valueOf(n - 26), (this.opType == IntervalOpType.INTERVAL_MULTIPLY_NUMERIC ? bigDecimal.multiply(bigDecimal2) : bigDecimal.divide(bigDecimal2)).toBigInteger());
            }
            case DATETIME_MINUS_DATETIME: {
                if (n == 9 && n2 == 9) {
                    boolean bl;
                    long l = ((ValueTime)value).getNanos() - ((ValueTime)value2).getNanos();
                    boolean bl2 = bl = l < 0L;
                    if (bl) {
                        l = -l;
                    }
                    return ValueInterval.from(IntervalQualifier.HOUR_TO_SECOND, bl, l / 3600000000000L, l % 3600000000000L);
                }
                if (n == 10 && n2 == 10) {
                    boolean bl;
                    long l = DateTimeUtils.absoluteDayFromDateValue(((ValueDate)value).getDateValue()) - DateTimeUtils.absoluteDayFromDateValue(((ValueDate)value2).getDateValue());
                    boolean bl3 = bl = l < 0L;
                    if (bl) {
                        l = -l;
                    }
                    return ValueInterval.from(IntervalQualifier.DAY, bl, l, 0L);
                }
                BigInteger bigInteger = IntervalOperation.nanosFromValue(value).subtract(IntervalOperation.nanosFromValue(value2));
                if (n == 24 || n2 == 24) {
                    value = value.convertTo(24);
                    value2 = value2.convertTo(24);
                    bigInteger = bigInteger.add(BigInteger.valueOf((long)(((ValueTimestampTimeZone)value2).getTimeZoneOffsetMins() - ((ValueTimestampTimeZone)value).getTimeZoneOffsetMins()) * 60000000000L));
                }
                return IntervalUtils.intervalFromAbsolute(IntervalQualifier.DAY_TO_SECOND, bigInteger);
            }
        }
        throw DbException.throwInternalError("type=" + (Object)((Object)this.opType));
    }

    private Value getDateTimeWithInterval(Value value, Value value2, int n, int n2) {
        switch (n) {
            case 9: {
                BigInteger bigInteger;
                if (DataType.isYearMonthIntervalType(n2)) {
                    throw DbException.throwInternalError("type=" + n2);
                }
                BigInteger bigInteger2 = BigInteger.valueOf(((ValueTime)value).getNanos());
                BigInteger bigInteger3 = IntervalUtils.intervalToAbsolute((ValueInterval)value2);
                BigInteger bigInteger4 = bigInteger = this.opType == IntervalOpType.DATETIME_PLUS_INTERVAL ? bigInteger2.add(bigInteger3) : bigInteger2.subtract(bigInteger3);
                if (bigInteger.signum() < 0 || bigInteger.compareTo(IntervalUtils.NANOS_PER_DAY_BI) >= 0) {
                    throw DbException.get(22003, bigInteger.toString());
                }
                return ValueTime.fromNanos(bigInteger.longValue());
            }
            case 10: 
            case 11: 
            case 24: {
                if (DataType.isYearMonthIntervalType(n2)) {
                    long l = IntervalUtils.intervalToAbsolute((ValueInterval)value2).longValue();
                    if (this.opType == IntervalOpType.DATETIME_MINUS_INTERVAL) {
                        l = -l;
                    }
                    return DateTimeFunctions.dateadd("MONTH", l, value);
                }
                BigInteger bigInteger = IntervalUtils.intervalToAbsolute((ValueInterval)value2);
                if (n == 10) {
                    BigInteger bigInteger5 = BigInteger.valueOf(DateTimeUtils.absoluteDayFromDateValue(((ValueDate)value).getDateValue()));
                    bigInteger = bigInteger.divide(IntervalUtils.NANOS_PER_DAY_BI);
                    BigInteger bigInteger6 = this.opType == IntervalOpType.DATETIME_PLUS_INTERVAL ? bigInteger5.add(bigInteger) : bigInteger5.subtract(bigInteger);
                    return ValueDate.fromDateValue(DateTimeUtils.dateValueFromAbsoluteDay(bigInteger6.longValue()));
                }
                long[] lArray = DateTimeUtils.dateAndTimeFromValue(value);
                long l = DateTimeUtils.absoluteDayFromDateValue(lArray[0]);
                long l2 = lArray[1];
                BigInteger[] bigIntegerArray = bigInteger.divideAndRemainder(IntervalUtils.NANOS_PER_DAY_BI);
                if (this.opType == IntervalOpType.DATETIME_PLUS_INTERVAL) {
                    l += bigIntegerArray[0].longValue();
                    l2 += bigIntegerArray[1].longValue();
                } else {
                    l -= bigIntegerArray[0].longValue();
                    l2 -= bigIntegerArray[1].longValue();
                }
                if (l2 >= 86400000000000L) {
                    l2 -= 86400000000000L;
                    ++l;
                } else if (l2 < 0L) {
                    l2 += 86400000000000L;
                    --l;
                }
                return DateTimeUtils.dateTimeToValue(value, DateTimeUtils.dateValueFromAbsoluteDay(l), l2, false);
            }
        }
        throw DbException.throwInternalError("type=" + (Object)((Object)this.opType));
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n, int n2) {
        this.left.mapColumns(columnResolver, n, n2);
        if (this.right != null) {
            this.right.mapColumns(columnResolver, n, n2);
        }
    }

    @Override
    public Expression optimize(Session session) {
        this.left = this.left.optimize(session);
        this.right = this.right.optimize(session);
        if (this.left.isConstant() && this.right.isConstant()) {
            return ValueExpression.get(this.getValue(session));
        }
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.left.setEvaluatable(tableFilter, bl);
        this.right.setEvaluatable(tableFilter, bl);
    }

    @Override
    public TypeInfo getType() {
        return this.type;
    }

    @Override
    public void updateAggregate(Session session, int n) {
        this.left.updateAggregate(session, n);
        this.right.updateAggregate(session, n);
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.left.isEverything(expressionVisitor) && this.right.isEverything(expressionVisitor);
    }

    @Override
    public int getCost() {
        return this.left.getCost() + 1 + this.right.getCost();
    }

    @Override
    public int getSubexpressionCount() {
        return 2;
    }

    @Override
    public Expression getSubexpression(int n) {
        switch (n) {
            case 0: {
                return this.left;
            }
            case 1: {
                return this.right;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public static enum IntervalOpType {
        INTERVAL_PLUS_INTERVAL,
        INTERVAL_MINUS_INTERVAL,
        DATETIME_PLUS_INTERVAL,
        DATETIME_MINUS_INTERVAL,
        INTERVAL_MULTIPLY_NUMERIC,
        INTERVAL_DIVIDE_NUMERIC,
        DATETIME_MINUS_DATETIME;

    }
}

