/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.config.MapConfig;
import java.util.concurrent.TimeUnit;

public final class ExpirationTimeSetter {
    private ExpirationTimeSetter() {
    }

    public static long calculateExpirationTime(long ttlMillis, long maxIdleMillis, long now) {
        long expiryTime = Math.min(ttlMillis, maxIdleMillis);
        if (expiryTime == Long.MAX_VALUE) {
            return expiryTime;
        }
        long nextExpiryTime = expiryTime + now;
        return nextExpiryTime <= 0L ? Long.MAX_VALUE : nextExpiryTime;
    }

    public static long pickTTLMillis(long operationTTLMillis, MapConfig mapConfig) {
        if (operationTTLMillis < 0L && mapConfig.getTimeToLiveSeconds() == 0) {
            return Long.MAX_VALUE;
        }
        if (operationTTLMillis > 0L) {
            return operationTTLMillis;
        }
        if (operationTTLMillis == 0L) {
            return Long.MAX_VALUE;
        }
        if (mapConfig.getTimeToLiveSeconds() > 0) {
            return TimeUnit.SECONDS.toMillis(mapConfig.getTimeToLiveSeconds());
        }
        return Long.MAX_VALUE;
    }

    public static long pickMaxIdleMillis(long operationMaxIdleMillis, MapConfig mapConfig) {
        if (operationMaxIdleMillis < 0L && mapConfig.getMaxIdleSeconds() == 0) {
            return Long.MAX_VALUE;
        }
        if (operationMaxIdleMillis > 0L) {
            return operationMaxIdleMillis;
        }
        if (operationMaxIdleMillis == 0L) {
            return Long.MAX_VALUE;
        }
        if (mapConfig.getMaxIdleSeconds() > 0) {
            return TimeUnit.SECONDS.toMillis(mapConfig.getMaxIdleSeconds());
        }
        return Long.MAX_VALUE;
    }
}

