/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.rel.externalize;

import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.org.apache.calcite.avatica.AvaticaUtils;
import com.hazelcast.org.apache.calcite.avatica.util.TimeUnit;
import com.hazelcast.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.org.apache.calcite.rel.RelCollation;
import com.hazelcast.org.apache.calcite.rel.RelCollationImpl;
import com.hazelcast.org.apache.calcite.rel.RelCollations;
import com.hazelcast.org.apache.calcite.rel.RelDistribution;
import com.hazelcast.org.apache.calcite.rel.RelDistributions;
import com.hazelcast.org.apache.calcite.rel.RelFieldCollation;
import com.hazelcast.org.apache.calcite.rel.RelInput;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.core.AggregateCall;
import com.hazelcast.org.apache.calcite.rel.core.CorrelationId;
import com.hazelcast.org.apache.calcite.rel.externalize.RelEnumTypes;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeField;
import com.hazelcast.org.apache.calcite.rex.RexBuilder;
import com.hazelcast.org.apache.calcite.rex.RexCall;
import com.hazelcast.org.apache.calcite.rex.RexCorrelVariable;
import com.hazelcast.org.apache.calcite.rex.RexFieldAccess;
import com.hazelcast.org.apache.calcite.rex.RexFieldCollation;
import com.hazelcast.org.apache.calcite.rex.RexLiteral;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.rex.RexOver;
import com.hazelcast.org.apache.calcite.rex.RexSlot;
import com.hazelcast.org.apache.calcite.rex.RexWindow;
import com.hazelcast.org.apache.calcite.rex.RexWindowBound;
import com.hazelcast.org.apache.calcite.rex.RexWindowBounds;
import com.hazelcast.org.apache.calcite.sql.SqlAggFunction;
import com.hazelcast.org.apache.calcite.sql.SqlFunction;
import com.hazelcast.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.org.apache.calcite.sql.SqlIntervalQualifier;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.org.apache.calcite.sql.SqlSyntax;
import com.hazelcast.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.org.apache.calcite.sql.validate.SqlNameMatchers;
import com.hazelcast.org.apache.calcite.util.ImmutableBitSet;
import com.hazelcast.org.apache.calcite.util.ImmutableIntList;
import com.hazelcast.org.apache.calcite.util.JsonBuilder;
import com.hazelcast.org.apache.calcite.util.Util;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RelJson {
    private final Map<String, Constructor> constructorMap = new HashMap<String, Constructor>();
    private final JsonBuilder jsonBuilder;
    public static final List<String> PACKAGES = ImmutableList.of("com.hazelcast.org.apache.calcite.rel.", "com.hazelcast.org.apache.calcite.rel.core.", "com.hazelcast.org.apache.calcite.rel.logical.", "com.hazelcast.org.apache.calcite.adapter.jdbc.", "com.hazelcast.org.apache.calcite.adapter.jdbc.JdbcRules$");

    public RelJson(JsonBuilder jsonBuilder) {
        this.jsonBuilder = jsonBuilder;
    }

    public RelNode create(Map<String, Object> map) {
        String type = (String)map.get("type");
        Constructor constructor = this.getConstructor(type);
        try {
            return (RelNode)constructor.newInstance(map);
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("while invoking constructor for type '" + type + "'", e);
        }
    }

    public Constructor getConstructor(String type) {
        Constructor constructor = this.constructorMap.get(type);
        if (constructor == null) {
            Class clazz = this.typeNameToClass(type);
            try {
                constructor = clazz.getConstructor(RelInput.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("class does not have required constructor, " + clazz + "(RelInput)");
            }
            this.constructorMap.put(type, constructor);
        }
        return constructor;
    }

    public Class typeNameToClass(String type) {
        if (!type.contains(".")) {
            for (String package_ : PACKAGES) {
                try {
                    return Class.forName(package_ + type);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
        }
        try {
            return Class.forName(type);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("unknown type " + type);
        }
    }

    public String classToTypeName(Class<? extends RelNode> class_) {
        String canonicalName = class_.getName();
        for (String package_ : PACKAGES) {
            String remaining;
            if (!canonicalName.startsWith(package_) || (remaining = canonicalName.substring(package_.length())).indexOf(46) >= 0 || remaining.indexOf(36) >= 0) continue;
            return remaining;
        }
        return canonicalName;
    }

    public Object toJson(RelCollationImpl node) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (RelFieldCollation fieldCollation : node.getFieldCollations()) {
            Map<String, Object> map = this.jsonBuilder.map();
            map.put("field", fieldCollation.getFieldIndex());
            map.put("direction", fieldCollation.getDirection().name());
            map.put("nulls", fieldCollation.nullDirection.name());
            list.add(map);
        }
        return list;
    }

    public RelCollation toCollation(List<Map<String, Object>> jsonFieldCollations) {
        ArrayList<RelFieldCollation> fieldCollations = new ArrayList<RelFieldCollation>();
        for (Map<String, Object> map : jsonFieldCollations) {
            fieldCollations.add(this.toFieldCollation(map));
        }
        return RelCollations.of(fieldCollations);
    }

    public RelFieldCollation toFieldCollation(Map<String, Object> map) {
        Integer field = (Integer)map.get("field");
        RelFieldCollation.Direction direction = (RelFieldCollation.Direction)((Object)Util.enumVal(RelFieldCollation.Direction.class, (String)map.get("direction")));
        RelFieldCollation.NullDirection nullDirection = (RelFieldCollation.NullDirection)((Object)Util.enumVal(RelFieldCollation.NullDirection.class, (String)map.get("nulls")));
        return new RelFieldCollation(field, direction, nullDirection);
    }

    public RelDistribution toDistribution(Map<String, Object> map) {
        RelDistribution.Type type = (RelDistribution.Type)((Object)Util.enumVal(RelDistribution.Type.class, (String)map.get("type")));
        ImmutableIntList list = RelDistributions.EMPTY;
        if (map.containsKey("keys")) {
            List keysJson = (List)map.get("keys");
            ArrayList<Integer> keys = new ArrayList<Integer>(keysJson.size());
            for (Object o : keysJson) {
                keys.add((Integer)o);
            }
            list = ImmutableIntList.copyOf(keys);
        }
        return RelDistributions.of(type, list);
    }

    private Object toJson(RelDistribution relDistribution) {
        Map<String, Object> map = this.jsonBuilder.map();
        map.put("type", relDistribution.getType().name());
        if (!relDistribution.getKeys().isEmpty()) {
            ArrayList<Object> keys = new ArrayList<Object>(relDistribution.getKeys().size());
            for (Integer key : relDistribution.getKeys()) {
                keys.add(this.toJson(key));
            }
            map.put("keys", keys);
        }
        return map;
    }

    public RelDataType toType(RelDataTypeFactory typeFactory, Object o) {
        if (o instanceof List) {
            List jsonList = (List)o;
            RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
            for (Map jsonMap : jsonList) {
                ((RelDataTypeFactory.Builder)builder).add((String)jsonMap.get("name"), this.toType(typeFactory, jsonMap));
            }
            return builder.build();
        }
        if (o instanceof Map) {
            Map map = (Map)o;
            Object fields = map.get("fields");
            if (fields != null) {
                return this.toType(typeFactory, fields);
            }
            SqlTypeName sqlTypeName = (SqlTypeName)((Object)Util.enumVal(SqlTypeName.class, (String)map.get("type")));
            Integer precision = (Integer)map.get("precision");
            Integer scale = (Integer)map.get("scale");
            if (SqlTypeName.INTERVAL_TYPES.contains((Object)sqlTypeName)) {
                TimeUnit startUnit = sqlTypeName.getStartUnit();
                TimeUnit endUnit = sqlTypeName.getEndUnit();
                return typeFactory.createSqlIntervalType(new SqlIntervalQualifier(startUnit, endUnit, SqlParserPos.ZERO));
            }
            RelDataType type = precision == null ? typeFactory.createSqlType(sqlTypeName) : (scale == null ? typeFactory.createSqlType(sqlTypeName, precision) : typeFactory.createSqlType(sqlTypeName, precision, scale));
            boolean nullable = (Boolean)map.get("nullable");
            return typeFactory.createTypeWithNullability(type, nullable);
        }
        SqlTypeName sqlTypeName = (SqlTypeName)((Object)Util.enumVal(SqlTypeName.class, (String)o));
        return typeFactory.createSqlType(sqlTypeName);
    }

    public Object toJson(AggregateCall node) {
        Map<String, Object> map = this.jsonBuilder.map();
        map.put("agg", this.toJson(node.getAggregation()));
        map.put("type", this.toJson(node.getType()));
        map.put("distinct", node.isDistinct());
        map.put("operands", node.getArgList());
        map.put("name", node.getName());
        return map;
    }

    public Object toJson(Object value) {
        if (value == null || value instanceof Number || value instanceof String || value instanceof Boolean) {
            return value;
        }
        if (value instanceof RexNode) {
            return this.toJson((RexNode)value);
        }
        if (value instanceof RexWindow) {
            return this.toJson((RexWindow)value);
        }
        if (value instanceof RexFieldCollation) {
            return this.toJson((RexFieldCollation)value);
        }
        if (value instanceof RexWindowBound) {
            return this.toJson((RexWindowBound)value);
        }
        if (value instanceof CorrelationId) {
            return this.toJson((CorrelationId)value);
        }
        if (value instanceof List) {
            List<Object> list = this.jsonBuilder.list();
            for (Object o : (List)value) {
                list.add(this.toJson(o));
            }
            return list;
        }
        if (value instanceof ImmutableBitSet) {
            List<Object> list = this.jsonBuilder.list();
            for (Integer integer : (ImmutableBitSet)value) {
                list.add(this.toJson(integer));
            }
            return list;
        }
        if (value instanceof AggregateCall) {
            return this.toJson((AggregateCall)value);
        }
        if (value instanceof RelCollationImpl) {
            return this.toJson((RelCollationImpl)value);
        }
        if (value instanceof RelDataType) {
            return this.toJson((RelDataType)value);
        }
        if (value instanceof RelDataTypeField) {
            return this.toJson((RelDataTypeField)value);
        }
        if (value instanceof RelDistribution) {
            return this.toJson((RelDistribution)value);
        }
        throw new UnsupportedOperationException("type not serializable: " + value + " (type " + value.getClass().getCanonicalName() + ")");
    }

    private Object toJson(RelDataType node) {
        if (node.isStruct()) {
            List<Object> list = this.jsonBuilder.list();
            for (RelDataTypeField field : node.getFieldList()) {
                list.add(this.toJson(field));
            }
            return list;
        }
        Map<String, Object> map = this.jsonBuilder.map();
        map.put("type", node.getSqlTypeName().name());
        map.put("nullable", node.isNullable());
        if (node.getSqlTypeName().allowsPrec()) {
            map.put("precision", node.getPrecision());
        }
        if (node.getSqlTypeName().allowsScale()) {
            map.put("scale", node.getScale());
        }
        return map;
    }

    private Object toJson(RelDataTypeField node) {
        Map map;
        if (node.getType().isStruct()) {
            map = this.jsonBuilder.map();
            map.put("fields", this.toJson(node.getType()));
        } else {
            map = (Map)this.toJson(node.getType());
        }
        map.put("name", node.getName());
        return map;
    }

    private Object toJson(CorrelationId node) {
        return node.getId();
    }

    private Object toJson(RexNode node) {
        switch (node.getKind()) {
            case FIELD_ACCESS: {
                Map<String, Object> map = this.jsonBuilder.map();
                RexFieldAccess fieldAccess = (RexFieldAccess)node;
                map.put("field", fieldAccess.getField().getName());
                map.put("expr", this.toJson(fieldAccess.getReferenceExpr()));
                return map;
            }
            case LITERAL: {
                RexLiteral literal = (RexLiteral)node;
                Object value = literal.getValue3();
                Map<String, Object> map = this.jsonBuilder.map();
                map.put("literal", RelEnumTypes.fromEnum(value));
                map.put("type", this.toJson(node.getType()));
                return map;
            }
            case INPUT_REF: {
                Map<String, Object> map = this.jsonBuilder.map();
                map.put("input", ((RexSlot)node).getIndex());
                map.put("name", ((RexSlot)node).getName());
                return map;
            }
            case LOCAL_REF: {
                Map<String, Object> map = this.jsonBuilder.map();
                map.put("input", ((RexSlot)node).getIndex());
                map.put("name", ((RexSlot)node).getName());
                map.put("type", this.toJson(node.getType()));
                return map;
            }
            case CORREL_VARIABLE: {
                Map<String, Object> map = this.jsonBuilder.map();
                map.put("correl", ((RexCorrelVariable)node).getName());
                map.put("type", this.toJson(node.getType()));
                return map;
            }
        }
        if (node instanceof RexCall) {
            RexCall call = (RexCall)node;
            Map<String, Object> map = this.jsonBuilder.map();
            map.put("op", this.toJson(call.getOperator()));
            List<Object> list = this.jsonBuilder.list();
            for (RexNode operand : call.getOperands()) {
                list.add(this.toJson(operand));
            }
            map.put("operands", list);
            switch (node.getKind()) {
                case CAST: {
                    map.put("type", this.toJson(node.getType()));
                }
            }
            if (call.getOperator() instanceof SqlFunction && ((SqlFunction)call.getOperator()).getFunctionType().isUserDefined()) {
                SqlOperator op = call.getOperator();
                map.put("class", op.getClass().getName());
                map.put("type", this.toJson(node.getType()));
                map.put("deterministic", op.isDeterministic());
                map.put("dynamic", op.isDynamicFunction());
            }
            if (call instanceof RexOver) {
                RexOver over = (RexOver)call;
                map.put("distinct", over.isDistinct());
                map.put("type", this.toJson(node.getType()));
                map.put("window", this.toJson(over.getWindow()));
            }
            return map;
        }
        throw new UnsupportedOperationException("unknown rex " + node);
    }

    private Object toJson(RexWindow window) {
        Map<String, Object> map = this.jsonBuilder.map();
        if (window.partitionKeys.size() > 0) {
            map.put("partition", this.toJson(window.partitionKeys));
        }
        if (window.orderKeys.size() > 0) {
            map.put("order", this.toJson(window.orderKeys));
        }
        if (window.getLowerBound() != null) {
            if (window.getUpperBound() == null) {
                if (window.isRows()) {
                    map.put("rows-lower", this.toJson(window.getLowerBound()));
                } else {
                    map.put("range-lower", this.toJson(window.getLowerBound()));
                }
            } else if (window.isRows()) {
                map.put("rows-lower", this.toJson(window.getLowerBound()));
                map.put("rows-upper", this.toJson(window.getUpperBound()));
            } else {
                map.put("range-lower", this.toJson(window.getLowerBound()));
                map.put("range-upper", this.toJson(window.getUpperBound()));
            }
        }
        return map;
    }

    private Object toJson(RexFieldCollation collation) {
        Map<String, Object> map = this.jsonBuilder.map();
        map.put("expr", this.toJson((RexNode)collation.left));
        map.put("direction", collation.getDirection().name());
        map.put("null-direction", collation.getNullDirection().name());
        return map;
    }

    private Object toJson(RexWindowBound windowBound) {
        Map<String, Object> map = this.jsonBuilder.map();
        if (windowBound.isCurrentRow()) {
            map.put("type", "CURRENT_ROW");
        } else if (windowBound.isUnbounded()) {
            map.put("type", windowBound.isPreceding() ? "UNBOUNDED_PRECEDING" : "UNBOUNDED_FOLLOWING");
        } else {
            map.put("type", windowBound.isPreceding() ? "PRECEDING" : "FOLLOWING");
            map.put("offset", this.toJson(windowBound.getOffset()));
        }
        return map;
    }

    RexNode toRex(RelInput relInput, Object o) {
        RelOptCluster cluster = relInput.getCluster();
        RexBuilder rexBuilder = cluster.getRexBuilder();
        if (o == null) {
            return null;
        }
        if (o instanceof Map) {
            Map map = (Map)o;
            Map opMap = (Map)map.get("op");
            RelDataTypeFactory typeFactory = cluster.getTypeFactory();
            if (opMap != null) {
                if (map.containsKey("class")) {
                    opMap.put("class", map.get("class"));
                }
                List operands = (List)map.get("operands");
                List<RexNode> rexOperands = this.toRexList(relInput, operands);
                Object jsonType = map.get("type");
                Map window = (Map)map.get("window");
                if (window != null) {
                    boolean physical;
                    RexWindowBound upperBound;
                    RexWindowBound lowerBound;
                    SqlAggFunction operator = this.toAggregation(opMap);
                    RelDataType type = this.toType(typeFactory, jsonType);
                    ArrayList<RexNode> partitionKeys = new ArrayList();
                    if (window.containsKey("partition")) {
                        partitionKeys = this.toRexList(relInput, (List)window.get("partition"));
                    }
                    List<Object> orderKeys = new ArrayList();
                    if (window.containsKey("order")) {
                        orderKeys = this.toRexFieldCollationList(relInput, (List)window.get("order"));
                    }
                    if (window.get("rows-lower") != null) {
                        lowerBound = this.toRexWindowBound(relInput, (Map)window.get("rows-lower"));
                        upperBound = this.toRexWindowBound(relInput, (Map)window.get("rows-upper"));
                        physical = true;
                    } else if (window.get("range-lower") != null) {
                        lowerBound = this.toRexWindowBound(relInput, (Map)window.get("range-lower"));
                        upperBound = this.toRexWindowBound(relInput, (Map)window.get("range-upper"));
                        physical = false;
                    } else {
                        lowerBound = null;
                        upperBound = null;
                        physical = false;
                    }
                    boolean distinct = (Boolean)map.get("distinct");
                    return rexBuilder.makeOver(type, operator, rexOperands, partitionKeys, ImmutableList.copyOf(orderKeys), lowerBound, upperBound, physical, true, false, distinct, false);
                }
                SqlOperator operator = this.toOp(opMap);
                RelDataType type = jsonType != null ? this.toType(typeFactory, jsonType) : rexBuilder.deriveReturnType(operator, rexOperands);
                return rexBuilder.makeCall(type, operator, rexOperands);
            }
            Integer input = (Integer)map.get("input");
            if (input != null) {
                if (map.containsKey("type")) {
                    RelDataType type = this.toType(typeFactory, map.get("type"));
                    return rexBuilder.makeLocalRef(type, input);
                }
                List<RelNode> inputNodes = relInput.getInputs();
                int i = input;
                for (RelNode inputNode : inputNodes) {
                    RelDataType rowType = inputNode.getRowType();
                    if (i < rowType.getFieldCount()) {
                        RelDataTypeField field = rowType.getFieldList().get(i);
                        return rexBuilder.makeInputRef(field.getType(), (int)input);
                    }
                    i -= rowType.getFieldCount();
                }
                throw new RuntimeException("input field " + input + " is out of range");
            }
            String field = (String)map.get("field");
            if (field != null) {
                Object jsonExpr = map.get("expr");
                RexNode expr = this.toRex(relInput, jsonExpr);
                return rexBuilder.makeFieldAccess(expr, field, true);
            }
            String correl = (String)map.get("correl");
            if (correl != null) {
                Object jsonType = map.get("type");
                RelDataType type = this.toType(typeFactory, jsonType);
                return rexBuilder.makeCorrel(type, new CorrelationId(correl));
            }
            if (map.containsKey("literal")) {
                Object literal = map.get("literal");
                RelDataType type = this.toType(typeFactory, map.get("type"));
                if (literal == null) {
                    return rexBuilder.makeNullLiteral(type);
                }
                if (type == null) {
                    return this.toRex(relInput, literal);
                }
                if (type.getSqlTypeName() == SqlTypeName.SYMBOL) {
                    literal = RelEnumTypes.toEnum((String)literal);
                }
                return rexBuilder.makeLiteral(literal, type, false);
            }
            throw new UnsupportedOperationException("cannot convert to rex " + o);
        }
        if (o instanceof Boolean) {
            return rexBuilder.makeLiteral((Boolean)o);
        }
        if (o instanceof String) {
            return rexBuilder.makeLiteral((String)o);
        }
        if (o instanceof Number) {
            Number number = (Number)o;
            if (number instanceof Double || number instanceof Float) {
                return rexBuilder.makeApproxLiteral(BigDecimal.valueOf(number.doubleValue()));
            }
            return rexBuilder.makeExactLiteral(BigDecimal.valueOf(number.longValue()));
        }
        throw new UnsupportedOperationException("cannot convert to rex " + o);
    }

    private List<RexFieldCollation> toRexFieldCollationList(RelInput relInput, List<Map<String, Object>> order) {
        if (order == null) {
            return null;
        }
        ArrayList<RexFieldCollation> list = new ArrayList<RexFieldCollation>();
        for (Map<String, Object> o : order) {
            RexNode expr = this.toRex(relInput, o.get("expr"));
            HashSet<SqlKind> directions = new HashSet<SqlKind>();
            if (RelFieldCollation.Direction.valueOf((String)o.get("direction")) == RelFieldCollation.Direction.DESCENDING) {
                directions.add(SqlKind.DESCENDING);
            }
            if (RelFieldCollation.NullDirection.valueOf((String)o.get("null-direction")) == RelFieldCollation.NullDirection.FIRST) {
                directions.add(SqlKind.NULLS_FIRST);
            } else {
                directions.add(SqlKind.NULLS_LAST);
            }
            list.add(new RexFieldCollation(expr, (Set<SqlKind>)directions));
        }
        return list;
    }

    private RexWindowBound toRexWindowBound(RelInput input, Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        String type = (String)map.get("type");
        RexBuilder rexBuilder = input.getCluster().getRexBuilder();
        switch (type) {
            case "CURRENT_ROW": {
                return RexWindowBounds.CURRENT_ROW;
            }
            case "UNBOUNDED_PRECEDING": {
                return RexWindowBounds.UNBOUNDED_PRECEDING;
            }
            case "UNBOUNDED_FOLLOWING": {
                return RexWindowBounds.UNBOUNDED_FOLLOWING;
            }
            case "PRECEDING": {
                return RexWindowBounds.preceding(this.toRex(input, map.get("offset")));
            }
            case "FOLLOWING": {
                return RexWindowBounds.following(this.toRex(input, map.get("offset")));
            }
        }
        throw new UnsupportedOperationException("cannot convert type to rex window bound " + type);
    }

    private List<RexNode> toRexList(RelInput relInput, List operands) {
        ArrayList<RexNode> list = new ArrayList<RexNode>();
        for (Object operand : operands) {
            list.add(this.toRex(relInput, operand));
        }
        return list;
    }

    SqlOperator toOp(Map<String, Object> map) {
        String name = map.get("name").toString();
        String kind = map.get("kind").toString();
        String syntax = map.get("syntax").toString();
        SqlKind sqlKind = SqlKind.valueOf(kind);
        SqlSyntax sqlSyntax = SqlSyntax.valueOf(syntax);
        ArrayList<SqlOperator> operators = new ArrayList<SqlOperator>();
        SqlStdOperatorTable.instance().lookupOperatorOverloads(new SqlIdentifier(name, new SqlParserPos(0, 0)), null, sqlSyntax, operators, SqlNameMatchers.liberal());
        for (SqlOperator operator : operators) {
            if (operator.kind != sqlKind) continue;
            return operator;
        }
        String class_ = (String)map.get("class");
        if (class_ != null) {
            return AvaticaUtils.instantiatePlugin(SqlOperator.class, class_);
        }
        return null;
    }

    SqlAggFunction toAggregation(Map<String, Object> map) {
        return (SqlAggFunction)this.toOp(map);
    }

    private Map toJson(SqlOperator operator) {
        Map<String, Object> map = this.jsonBuilder.map();
        map.put("name", operator.getName());
        map.put("kind", operator.kind.toString());
        map.put("syntax", operator.getSyntax().toString());
        return map;
    }
}

