/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql;

import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlNodeList;
import com.hazelcast.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.org.apache.calcite.sql.SqlSpecialOperator;
import com.hazelcast.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParserPos;
import java.util.List;

public class SqlTableRef
extends SqlCall {
    private final SqlIdentifier tableName;
    private final SqlNodeList hints;
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("TABLE_REF", SqlKind.TABLE_REF);

    public SqlTableRef(SqlParserPos pos, SqlIdentifier tableName, SqlNodeList hints) {
        super(pos);
        this.tableName = tableName;
        this.hints = hints;
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableList.of(this.tableName, this.hints);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        this.tableName.unparse(writer, leftPrec, rightPrec);
        if (this.hints != null && this.hints.size() > 0) {
            writer.newlineAndIndent();
            writer.keyword("/*+");
            this.hints.unparse(writer, 0, 0);
            writer.keyword("*/");
        }
    }
}

