/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite;

import com.hazelcast.cluster.Member;
import com.hazelcast.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.org.apache.calcite.prepare.Prepare;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParserImplFactory;
import com.hazelcast.org.apache.calcite.sql.util.SqlVisitor;
import com.hazelcast.org.apache.calcite.sql.validate.SqlConformance;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.org.apache.calcite.sql2rel.SqlRexConvertletTable;
import com.hazelcast.org.apache.calcite.sql2rel.SqlToRelConverter;
import com.hazelcast.org.apache.calcite.sql2rel.StandardConvertletTable;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.impl.QueryParameterMetadata;
import com.hazelcast.sql.impl.QueryUtils;
import com.hazelcast.sql.impl.calcite.HazelcastSqlToRelConverter;
import com.hazelcast.sql.impl.calcite.OptimizerContext;
import com.hazelcast.sql.impl.calcite.SqlBackend;
import com.hazelcast.sql.impl.calcite.opt.OptUtils;
import com.hazelcast.sql.impl.calcite.opt.logical.LogicalRules;
import com.hazelcast.sql.impl.calcite.opt.logical.RootLogicalRel;
import com.hazelcast.sql.impl.calcite.opt.physical.PhysicalRel;
import com.hazelcast.sql.impl.calcite.opt.physical.PhysicalRules;
import com.hazelcast.sql.impl.calcite.opt.physical.visitor.NodeIdVisitor;
import com.hazelcast.sql.impl.calcite.opt.physical.visitor.PlanCreateVisitor;
import com.hazelcast.sql.impl.calcite.parse.QueryConvertResult;
import com.hazelcast.sql.impl.calcite.parse.QueryParseResult;
import com.hazelcast.sql.impl.calcite.parse.UnsupportedOperationVisitor;
import com.hazelcast.sql.impl.calcite.validate.HazelcastSqlValidator;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeFactory;
import com.hazelcast.sql.impl.optimizer.OptimizationTask;
import com.hazelcast.sql.impl.optimizer.SqlPlan;
import com.hazelcast.sql.impl.plan.cache.PlanCacheKey;
import java.util.List;
import java.util.Map;

public class HazelcastSqlBackend
implements SqlBackend {
    private final NodeEngine nodeEngine;

    public HazelcastSqlBackend(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
    }

    @Override
    public SqlParserImplFactory parserFactory() {
        return null;
    }

    @Override
    public SqlValidator validator(Prepare.CatalogReader catalogReader, HazelcastTypeFactory typeFactory, SqlConformance conformance) {
        return new HazelcastSqlValidator(catalogReader, typeFactory, conformance);
    }

    @Override
    public SqlVisitor<Void> unsupportedOperationVisitor(Prepare.CatalogReader catalogReader) {
        return new UnsupportedOperationVisitor(catalogReader);
    }

    @Override
    public SqlToRelConverter converter(RelOptTable.ViewExpander viewExpander, SqlValidator validator, Prepare.CatalogReader catalogReader, RelOptCluster cluster, SqlRexConvertletTable convertletTable, SqlToRelConverter.Config config) {
        return new HazelcastSqlToRelConverter(null, validator, catalogReader, cluster, StandardConvertletTable.INSTANCE, config);
    }

    @Override
    public SqlPlan createPlan(OptimizationTask task, QueryParseResult parseResult, OptimizerContext context) {
        QueryConvertResult convertResult = context.convert(parseResult);
        PhysicalRel physicalRel = this.optimize(context, convertResult.getRel(), parseResult.getParameterMetadata());
        String sql = task.getSql();
        NodeIdVisitor idVisitor = new NodeIdVisitor();
        physicalRel.visit(idVisitor);
        Map<PhysicalRel, List<Integer>> relIdMap = idVisitor.getIdMap();
        Member localMember = this.nodeEngine.getLocalMember();
        PlanCreateVisitor visitor = new PlanCreateVisitor(localMember.getUuid(), QueryUtils.createPartitionMap(this.nodeEngine, localMember.getVersion(), true), relIdMap, new PlanCacheKey(task.getSearchPaths(), sql), convertResult.getFieldNames(), parseResult.getParameterMetadata());
        physicalRel.visit(visitor);
        return visitor.getPlan();
    }

    private PhysicalRel optimize(OptimizerContext context, RelNode rel, QueryParameterMetadata parameterMetadata) {
        context.setParameterMetadata(parameterMetadata);
        RelNode logicalRel = context.optimize(rel, LogicalRules.getRuleSet(), OptUtils.toLogicalConvention(rel.getTraitSet()));
        RootLogicalRel logicalRootRel = new RootLogicalRel(logicalRel.getCluster(), logicalRel.getTraitSet(), logicalRel);
        RelTraitSet physicalTraitSet = OptUtils.toPhysicalConvention(logicalRootRel.getTraitSet(), OptUtils.getDistributionDef(logicalRootRel).getTraitRoot());
        return (PhysicalRel)context.optimize(logicalRootRel, PhysicalRules.getRuleSet(), physicalTraitSet);
    }
}

