/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.exec.sort;

import com.hazelcast.sql.impl.exec.sort.SortKey;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Comparator;

@SuppressFBWarnings(value={"SE_COMPARATOR_SHOULD_BE_SERIALIZABLE", "EI_EXPOSE_REP2"})
public class SortKeyComparator
implements Comparator<SortKey> {
    private final boolean[] ascs;

    public SortKeyComparator(boolean[] ascs) {
        this.ascs = ascs;
    }

    @Override
    public int compare(SortKey o1, SortKey o2) {
        Object[] key1 = o1.getKey();
        Object[] key2 = o2.getKey();
        for (int i = 0; i < this.ascs.length; ++i) {
            Object item1 = key1[i];
            Comparable item1Comp = (Comparable)item1;
            Object item2 = key2[i];
            Comparable item2Comp = (Comparable)item2;
            boolean asc = this.ascs[i];
            int res = this.compare(item1Comp, item2Comp, asc);
            if (res == 0) continue;
            return res;
        }
        return Long.compare(o1.getIndex(), o2.getIndex());
    }

    private int compare(Comparable o1, Comparable o2, boolean asc) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return asc ? -1 : 1;
        }
        if (o2 == null) {
            return asc ? 1 : -1;
        }
        return asc ? o1.compareTo(o2) : o2.compareTo(o1);
    }
}

