/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.builtin;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class EntryListUUIDLongCodec {
    private static final int ENTRY_SIZE_IN_BYTES = 25;

    private EntryListUUIDLongCodec() {
    }

    public static void encode(ClientMessage clientMessage, Collection<Map.Entry<UUID, Long>> collection) {
        int itemCount = collection.size();
        ClientMessage.Frame frame = new ClientMessage.Frame(new byte[itemCount * 25]);
        Iterator<Map.Entry<UUID, Long>> iterator = collection.iterator();
        for (int i = 0; i < itemCount; ++i) {
            Map.Entry<UUID, Long> entry = iterator.next();
            FixedSizeTypesCodec.encodeUUID(frame.content, i * 25, entry.getKey());
            FixedSizeTypesCodec.encodeLong(frame.content, i * 25 + 17, entry.getValue());
        }
        clientMessage.add(frame);
    }

    public static List<Map.Entry<UUID, Long>> decode(ClientMessage.ForwardFrameIterator iterator) {
        ClientMessage.Frame frame = iterator.next();
        int itemCount = frame.content.length / 25;
        ArrayList<Map.Entry<UUID, Long>> result = new ArrayList<Map.Entry<UUID, Long>>(itemCount);
        for (int i = 0; i < itemCount; ++i) {
            UUID key = FixedSizeTypesCodec.decodeUUID(frame.content, i * 25);
            Long value = FixedSizeTypesCodec.decodeLong(frame.content, i * 25 + 17);
            result.add(new AbstractMap.SimpleEntry<UUID, Long>(key, value));
        }
        return result;
    }
}

