/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.NamedConfig;
import com.hazelcast.internal.config.ConfigDataSerializerHook;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Objects;

public class FlakeIdGeneratorConfig
implements IdentifiedDataSerializable,
NamedConfig {
    public static final int DEFAULT_PREFETCH_COUNT = 100;
    public static final long DEFAULT_PREFETCH_VALIDITY_MILLIS = 600000L;
    public static final long DEFAULT_EPOCH_START = 1514764800000L;
    public static final int DEFAULT_BITS_SEQUENCE = 6;
    public static final int DEFAULT_BITS_NODE_ID = 16;
    public static final long DEFAULT_ALLOWED_FUTURE_MILLIS = 15000L;
    public static final int MAXIMUM_PREFETCH_COUNT = 100000;
    private static final int MAX_BITS = 63;
    private String name;
    private int prefetchCount = 100;
    private long prefetchValidityMillis = 600000L;
    private long epochStart = 1514764800000L;
    private long nodeIdOffset;
    private int bitsSequence = 6;
    private int bitsNodeId = 16;
    private long allowedFutureMillis = 15000L;
    private boolean statisticsEnabled = true;

    public FlakeIdGeneratorConfig() {
    }

    public FlakeIdGeneratorConfig(String name) {
        this.name = name;
    }

    public FlakeIdGeneratorConfig(FlakeIdGeneratorConfig other) {
        this.name = other.name;
        this.prefetchCount = other.prefetchCount;
        this.prefetchValidityMillis = other.prefetchValidityMillis;
        this.epochStart = other.epochStart;
        this.nodeIdOffset = other.nodeIdOffset;
        this.bitsSequence = other.bitsSequence;
        this.bitsNodeId = other.bitsNodeId;
        this.allowedFutureMillis = other.allowedFutureMillis;
        this.statisticsEnabled = other.statisticsEnabled;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public FlakeIdGeneratorConfig setName(String name) {
        this.name = name;
        return this;
    }

    public int getPrefetchCount() {
        return this.prefetchCount;
    }

    public FlakeIdGeneratorConfig setPrefetchCount(int prefetchCount) {
        Preconditions.checkTrue(prefetchCount > 0 && prefetchCount <= 100000, "prefetch-count must be 1..100000, but is " + prefetchCount);
        this.prefetchCount = prefetchCount;
        return this;
    }

    public long getPrefetchValidityMillis() {
        return this.prefetchValidityMillis;
    }

    public FlakeIdGeneratorConfig setPrefetchValidityMillis(long prefetchValidityMs) {
        this.prefetchValidityMillis = prefetchValidityMs;
        return this;
    }

    public FlakeIdGeneratorConfig setEpochStart(long epochStart) {
        this.epochStart = epochStart;
        return this;
    }

    public long getEpochStart() {
        return this.epochStart;
    }

    public long getNodeIdOffset() {
        return this.nodeIdOffset;
    }

    public FlakeIdGeneratorConfig setNodeIdOffset(long nodeIdOffset) {
        Preconditions.checkNotNegative(nodeIdOffset, "node id offset must be non-negative");
        this.nodeIdOffset = nodeIdOffset;
        return this;
    }

    public int getBitsSequence() {
        return this.bitsSequence;
    }

    public FlakeIdGeneratorConfig setBitsSequence(int bitsSequence) {
        Preconditions.checkTrue(bitsSequence >= 0 && bitsSequence < 63, "sequence bit-length must be 0..63");
        this.bitsSequence = bitsSequence;
        return this;
    }

    public int getBitsNodeId() {
        return this.bitsNodeId;
    }

    public FlakeIdGeneratorConfig setBitsNodeId(int bitsNodeId) {
        Preconditions.checkTrue(bitsNodeId >= 0 && bitsNodeId < 63, "node ID bit-length must be 0..63");
        this.bitsNodeId = bitsNodeId;
        return this;
    }

    public long getAllowedFutureMillis() {
        return this.allowedFutureMillis;
    }

    public FlakeIdGeneratorConfig setAllowedFutureMillis(long allowedFutureMillis) {
        Preconditions.checkNotNegative(allowedFutureMillis, "allowedFutureMillis must be non-negative");
        this.allowedFutureMillis = allowedFutureMillis;
        return this;
    }

    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public FlakeIdGeneratorConfig setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlakeIdGeneratorConfig that = (FlakeIdGeneratorConfig)o;
        return this.prefetchCount == that.prefetchCount && this.prefetchValidityMillis == that.prefetchValidityMillis && this.epochStart == that.epochStart && this.nodeIdOffset == that.nodeIdOffset && this.bitsSequence == that.bitsSequence && this.bitsNodeId == that.bitsNodeId && this.allowedFutureMillis == that.allowedFutureMillis && Objects.equals(this.name, that.name) && this.statisticsEnabled == that.statisticsEnabled;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.prefetchCount, this.prefetchValidityMillis, this.epochStart, this.nodeIdOffset, this.bitsSequence, this.bitsNodeId, this.allowedFutureMillis, this.statisticsEnabled);
    }

    public String toString() {
        return "FlakeIdGeneratorConfig{name='" + this.name + '\'' + ", prefetchCount=" + this.prefetchCount + ", prefetchValidityMillis=" + this.prefetchValidityMillis + ", epochStart=" + this.epochStart + ", nodeIdOffset=" + this.nodeIdOffset + ", bitsSequence=" + this.bitsSequence + ", bitsNodeId=" + this.bitsNodeId + ", allowedFutureMillis=" + this.allowedFutureMillis + ", statisticsEnabled=" + this.statisticsEnabled + '}';
    }

    @Override
    public int getFactoryId() {
        return ConfigDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 47;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.name);
        out.writeInt(this.prefetchCount);
        out.writeLong(this.prefetchValidityMillis);
        out.writeLong(this.epochStart);
        out.writeLong(this.nodeIdOffset);
        out.writeInt(this.bitsSequence);
        out.writeInt(this.bitsNodeId);
        out.writeLong(this.allowedFutureMillis);
        out.writeBoolean(this.statisticsEnabled);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readString();
        this.prefetchCount = in.readInt();
        this.prefetchValidityMillis = in.readLong();
        this.epochStart = in.readLong();
        this.nodeIdOffset = in.readLong();
        this.bitsSequence = in.readInt();
        this.bitsNodeId = in.readInt();
        this.allowedFutureMillis = in.readLong();
        this.statisticsEnabled = in.readBoolean();
    }
}

