/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.monitor.impl;

import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeUnit;
import com.hazelcast.internal.monitor.impl.LocalIndexStatsImpl;
import com.hazelcast.internal.monitor.impl.OnDemandIndexStats;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.TimeUtil;
import com.hazelcast.map.LocalMapStats;
import com.hazelcast.nearcache.NearCacheStats;
import com.hazelcast.query.LocalIndexStats;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class LocalMapStatsImpl
implements LocalMapStats {
    private static final AtomicLongFieldUpdater<LocalMapStatsImpl> LAST_ACCESS_TIME = AtomicLongFieldUpdater.newUpdater(LocalMapStatsImpl.class, "lastAccessTime");
    private static final AtomicLongFieldUpdater<LocalMapStatsImpl> LAST_UPDATE_TIME = AtomicLongFieldUpdater.newUpdater(LocalMapStatsImpl.class, "lastUpdateTime");
    private static final AtomicLongFieldUpdater<LocalMapStatsImpl> NUMBER_OF_OTHER_OPERATIONS = AtomicLongFieldUpdater.newUpdater(LocalMapStatsImpl.class, "numberOfOtherOperations");
    private static final AtomicLongFieldUpdater<LocalMapStatsImpl> NUMBER_OF_EVENTS = AtomicLongFieldUpdater.newUpdater(LocalMapStatsImpl.class, "numberOfEvents");
    private static final AtomicLongFieldUpdater<LocalMapStatsImpl> GET_COUNT = AtomicLongFieldUpdater.newUpdater(LocalMapStatsImpl.class, "getCount");
    private static final AtomicLongFieldUpdater<LocalMapStatsImpl> PUT_COUNT = AtomicLongFieldUpdater.newUpdater(LocalMapStatsImpl.class, "putCount");
    private static final AtomicLongFieldUpdater<LocalMapStatsImpl> SET_COUNT = AtomicLongFieldUpdater.newUpdater(LocalMapStatsImpl.class, "setCount");
    private static final AtomicLongFieldUpdater<LocalMapStatsImpl> REMOVE_COUNT = AtomicLongFieldUpdater.newUpdater(LocalMapStatsImpl.class, "removeCount");
    private static final AtomicLongFieldUpdater<LocalMapStatsImpl> TOTAL_GET_LATENCIES = AtomicLongFieldUpdater.newUpdater(LocalMapStatsImpl.class, "totalGetLatenciesNanos");
    private static final AtomicLongFieldUpdater<LocalMapStatsImpl> TOTAL_PUT_LATENCIES = AtomicLongFieldUpdater.newUpdater(LocalMapStatsImpl.class, "totalPutLatenciesNanos");
    private static final AtomicLongFieldUpdater<LocalMapStatsImpl> TOTAL_SET_LATENCIES = AtomicLongFieldUpdater.newUpdater(LocalMapStatsImpl.class, "totalSetLatenciesNanos");
    private static final AtomicLongFieldUpdater<LocalMapStatsImpl> TOTAL_REMOVE_LATENCIES = AtomicLongFieldUpdater.newUpdater(LocalMapStatsImpl.class, "totalRemoveLatenciesNanos");
    private static final AtomicLongFieldUpdater<LocalMapStatsImpl> MAX_GET_LATENCY = AtomicLongFieldUpdater.newUpdater(LocalMapStatsImpl.class, "maxGetLatency");
    private static final AtomicLongFieldUpdater<LocalMapStatsImpl> MAX_PUT_LATENCY = AtomicLongFieldUpdater.newUpdater(LocalMapStatsImpl.class, "maxPutLatency");
    private static final AtomicLongFieldUpdater<LocalMapStatsImpl> MAX_SET_LATENCY = AtomicLongFieldUpdater.newUpdater(LocalMapStatsImpl.class, "maxSetLatency");
    private static final AtomicLongFieldUpdater<LocalMapStatsImpl> MAX_REMOVE_LATENCY = AtomicLongFieldUpdater.newUpdater(LocalMapStatsImpl.class, "maxRemoveLatency");
    private final ConcurrentMap<String, LocalIndexStatsImpl> mutableIndexStats = new ConcurrentHashMap<String, LocalIndexStatsImpl>();
    private final Map<String, LocalIndexStats> indexStats = Collections.unmodifiableMap(this.mutableIndexStats);
    @Probe(name="lastAccessTime", unit=ProbeUnit.MS)
    private volatile long lastAccessTime;
    @Probe(name="lastUpdateTime", unit=ProbeUnit.MS)
    private volatile long lastUpdateTime;
    @Probe(name="hits")
    private volatile long hits;
    @Probe(name="numberOfOtherOperations")
    private volatile long numberOfOtherOperations;
    @Probe(name="numberOfEvents")
    private volatile long numberOfEvents;
    @Probe(name="getCount")
    private volatile long getCount;
    @Probe(name="putCount")
    private volatile long putCount;
    @Probe(name="setCount")
    private volatile long setCount;
    @Probe(name="removeCount")
    private volatile long removeCount;
    private volatile long totalGetLatenciesNanos;
    private volatile long totalPutLatenciesNanos;
    private volatile long totalSetLatenciesNanos;
    private volatile long totalRemoveLatenciesNanos;
    private volatile long maxGetLatency;
    private volatile long maxPutLatency;
    private volatile long maxSetLatency;
    private volatile long maxRemoveLatency;
    @Probe(name="creationTime", unit=ProbeUnit.MS)
    private final long creationTime = Clock.currentTimeMillis();
    @Probe(name="ownedEntryCount")
    private volatile long ownedEntryCount;
    @Probe(name="backupEntryCount")
    private volatile long backupEntryCount;
    @Probe(name="ownedEntryMemoryCost", unit=ProbeUnit.BYTES)
    private volatile long ownedEntryMemoryCost;
    @Probe(name="backupEntryMemoryCost", unit=ProbeUnit.BYTES)
    private volatile long backupEntryMemoryCost;
    @Probe(name="heapCost")
    private volatile long heapCost;
    @Probe(name="merkleTreesCost")
    private volatile long merkleTreesCost;
    @Probe(name="lockedEntryCount")
    private volatile long lockedEntryCount;
    @Probe(name="dirtyEntryCount")
    private volatile long dirtyEntryCount;
    @Probe(name="backupCount")
    private volatile int backupCount;
    private volatile NearCacheStats nearCacheStats;
    @Probe(name="queryCount")
    private volatile long queryCount;
    @Probe(name="indexedQueryCount")
    private volatile long indexedQueryCount;

    @Override
    public long getOwnedEntryCount() {
        return this.ownedEntryCount;
    }

    public void setOwnedEntryCount(long ownedEntryCount) {
        this.ownedEntryCount = ownedEntryCount;
    }

    @Override
    public long getBackupEntryCount() {
        return this.backupEntryCount;
    }

    public void setBackupEntryCount(long backupEntryCount) {
        this.backupEntryCount = backupEntryCount;
    }

    @Override
    public int getBackupCount() {
        return this.backupCount;
    }

    public void setBackupCount(int backupCount) {
        this.backupCount = backupCount;
    }

    @Override
    public long getOwnedEntryMemoryCost() {
        return this.ownedEntryMemoryCost;
    }

    public void setOwnedEntryMemoryCost(long ownedEntryMemoryCost) {
        this.ownedEntryMemoryCost = ownedEntryMemoryCost;
    }

    @Override
    public long getBackupEntryMemoryCost() {
        return this.backupEntryMemoryCost;
    }

    public void setBackupEntryMemoryCost(long backupEntryMemoryCost) {
        this.backupEntryMemoryCost = backupEntryMemoryCost;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTime(long lastAccessTime) {
        ConcurrencyUtil.setMax(this, LAST_ACCESS_TIME, lastAccessTime);
    }

    @Override
    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(long lastUpdateTime) {
        ConcurrencyUtil.setMax(this, LAST_UPDATE_TIME, lastUpdateTime);
    }

    @Override
    public long getHits() {
        return this.hits;
    }

    public void setHits(long hits) {
        this.hits = hits;
    }

    @Override
    public long getLockedEntryCount() {
        return this.lockedEntryCount;
    }

    public void setLockedEntryCount(long lockedEntryCount) {
        this.lockedEntryCount = lockedEntryCount;
    }

    @Override
    public long getDirtyEntryCount() {
        return this.dirtyEntryCount;
    }

    public void setDirtyEntryCount(long dirtyEntryCount) {
        this.dirtyEntryCount = dirtyEntryCount;
    }

    @Override
    public long getPutOperationCount() {
        return this.putCount;
    }

    @Override
    public long getSetOperationCount() {
        return this.setCount;
    }

    @Override
    public long getGetOperationCount() {
        return this.getCount;
    }

    @Override
    public long getRemoveOperationCount() {
        return this.removeCount;
    }

    @Override
    @Probe(name="totalPutLatency", unit=ProbeUnit.MS)
    public long getTotalPutLatency() {
        return TimeUtil.convertNanosToMillis(this.totalPutLatenciesNanos);
    }

    @Override
    @Probe(name="totalSetLatency", unit=ProbeUnit.MS)
    public long getTotalSetLatency() {
        return TimeUtil.convertNanosToMillis(this.totalSetLatenciesNanos);
    }

    @Override
    @Probe(name="totalGetLatency", unit=ProbeUnit.MS)
    public long getTotalGetLatency() {
        return TimeUtil.convertNanosToMillis(this.totalGetLatenciesNanos);
    }

    @Override
    @Probe(name="totalRemoveLatency", unit=ProbeUnit.MS)
    public long getTotalRemoveLatency() {
        return TimeUtil.convertNanosToMillis(this.totalRemoveLatenciesNanos);
    }

    @Override
    @Probe(name="totalMaxPutLatency", unit=ProbeUnit.MS)
    public long getMaxPutLatency() {
        return TimeUtil.convertNanosToMillis(this.maxPutLatency);
    }

    @Override
    @Probe(name="totalMaxSetLatency", unit=ProbeUnit.MS)
    public long getMaxSetLatency() {
        return TimeUtil.convertNanosToMillis(this.maxSetLatency);
    }

    @Override
    @Probe(name="totalMaxGetLatency", unit=ProbeUnit.MS)
    public long getMaxGetLatency() {
        return TimeUtil.convertNanosToMillis(this.maxGetLatency);
    }

    @Override
    @Probe(name="totalMaxRemoveLatency", unit=ProbeUnit.MS)
    public long getMaxRemoveLatency() {
        return TimeUtil.convertNanosToMillis(this.maxRemoveLatency);
    }

    @Override
    public long getEventOperationCount() {
        return this.numberOfEvents;
    }

    @Override
    public long getOtherOperationCount() {
        return this.numberOfOtherOperations;
    }

    @Override
    public long total() {
        return this.putCount + this.getCount + this.removeCount + this.numberOfOtherOperations;
    }

    @Override
    public long getHeapCost() {
        return this.heapCost;
    }

    public void setHeapCost(long heapCost) {
        this.heapCost = heapCost;
    }

    @Override
    public long getMerkleTreesCost() {
        return this.merkleTreesCost;
    }

    public void setMerkleTreesCost(long merkleTreeCost) {
        this.merkleTreesCost = merkleTreeCost;
    }

    @Override
    public NearCacheStats getNearCacheStats() {
        return this.nearCacheStats;
    }

    public void setNearCacheStats(NearCacheStats nearCacheStats) {
        this.nearCacheStats = nearCacheStats;
    }

    @Override
    public long getQueryCount() {
        return this.queryCount;
    }

    public void setQueryCount(long queryCount) {
        this.queryCount = queryCount;
    }

    @Override
    public long getIndexedQueryCount() {
        return this.indexedQueryCount;
    }

    public void setIndexedQueryCount(long indexedQueryCount) {
        this.indexedQueryCount = indexedQueryCount;
    }

    @Override
    public Map<String, LocalIndexStats> getIndexStats() {
        return this.indexStats;
    }

    public void setIndexStats(Map<String, LocalIndexStatsImpl> indexStats) {
        this.mutableIndexStats.clear();
        if (indexStats != null) {
            this.mutableIndexStats.putAll(indexStats);
        }
    }

    public void incrementPutLatencyNanos(long latencyNanos) {
        this.incrementPutLatencyNanos(1L, latencyNanos);
    }

    public void incrementPutLatencyNanos(long delta, long latencyNanos) {
        PUT_COUNT.addAndGet(this, delta);
        TOTAL_PUT_LATENCIES.addAndGet(this, latencyNanos);
        ConcurrencyUtil.setMax(this, MAX_PUT_LATENCY, latencyNanos);
    }

    public void incrementSetLatencyNanos(long latencyNanos) {
        SET_COUNT.incrementAndGet(this);
        TOTAL_SET_LATENCIES.addAndGet(this, latencyNanos);
        ConcurrencyUtil.setMax(this, MAX_SET_LATENCY, latencyNanos);
    }

    public void incrementGetLatencyNanos(long latencyNanos) {
        this.incrementGetLatencyNanos(1L, latencyNanos);
    }

    public void incrementGetLatencyNanos(long delta, long latencyNanos) {
        GET_COUNT.addAndGet(this, delta);
        TOTAL_GET_LATENCIES.addAndGet(this, latencyNanos);
        ConcurrencyUtil.setMax(this, MAX_GET_LATENCY, latencyNanos);
    }

    public void incrementRemoveLatencyNanos(long latencyNanos) {
        REMOVE_COUNT.incrementAndGet(this);
        TOTAL_REMOVE_LATENCIES.addAndGet(this, latencyNanos);
        ConcurrencyUtil.setMax(this, MAX_REMOVE_LATENCY, latencyNanos);
    }

    public void incrementOtherOperations() {
        NUMBER_OF_OTHER_OPERATIONS.incrementAndGet(this);
    }

    public void incrementReceivedEvents() {
        NUMBER_OF_EVENTS.incrementAndGet(this);
    }

    public void updateIndexStats(Map<String, OnDemandIndexStats> freshIndexStats) {
        if (freshIndexStats == null) {
            return;
        }
        for (Map.Entry<String, OnDemandIndexStats> freshIndexEntry : freshIndexStats.entrySet()) {
            String indexName = freshIndexEntry.getKey();
            LocalIndexStatsImpl indexStats = (LocalIndexStatsImpl)this.mutableIndexStats.get(indexName);
            if (indexStats == null) {
                indexStats = new LocalIndexStatsImpl();
                indexStats.setAllFrom(freshIndexEntry.getValue());
                this.mutableIndexStats.putIfAbsent(indexName, indexStats);
                continue;
            }
            indexStats.setAllFrom(freshIndexEntry.getValue());
        }
    }

    public String toString() {
        return "LocalMapStatsImpl{lastAccessTime=" + this.lastAccessTime + ", lastUpdateTime=" + this.lastUpdateTime + ", hits=" + this.hits + ", numberOfOtherOperations=" + this.numberOfOtherOperations + ", numberOfEvents=" + this.numberOfEvents + ", getCount=" + this.getCount + ", putCount=" + this.putCount + ", setCount=" + this.setCount + ", removeCount=" + this.removeCount + ", totalGetLatencies=" + TimeUtil.convertNanosToMillis(this.totalGetLatenciesNanos) + ", totalPutLatencies=" + TimeUtil.convertNanosToMillis(this.totalPutLatenciesNanos) + ", totalSetLatencies=" + TimeUtil.convertNanosToMillis(this.totalSetLatenciesNanos) + ", totalRemoveLatencies=" + TimeUtil.convertNanosToMillis(this.totalRemoveLatenciesNanos) + ", maxGetLatency=" + TimeUtil.convertNanosToMillis(this.maxGetLatency) + ", maxPutLatency=" + TimeUtil.convertNanosToMillis(this.maxPutLatency) + ", maxSetLatency=" + TimeUtil.convertNanosToMillis(this.maxSetLatency) + ", maxRemoveLatency=" + TimeUtil.convertNanosToMillis(this.maxRemoveLatency) + ", ownedEntryCount=" + this.ownedEntryCount + ", backupEntryCount=" + this.backupEntryCount + ", backupCount=" + this.backupCount + ", ownedEntryMemoryCost=" + this.ownedEntryMemoryCost + ", backupEntryMemoryCost=" + this.backupEntryMemoryCost + ", creationTime=" + this.creationTime + ", lockedEntryCount=" + this.lockedEntryCount + ", dirtyEntryCount=" + this.dirtyEntryCount + ", heapCost=" + this.heapCost + ", merkleTreesCost=" + this.merkleTreesCost + ", nearCacheStats=" + (this.nearCacheStats != null ? this.nearCacheStats : "") + ", queryCount=" + this.queryCount + ", indexedQueryCount=" + this.indexedQueryCount + ", indexStats=" + this.indexStats + '}';
    }
}

