/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.opt.physical;

import com.hazelcast.org.apache.calcite.config.CalciteSystemProperty;
import com.hazelcast.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.plan.RelTrait;
import com.hazelcast.org.apache.calcite.plan.RelTraitDef;
import com.hazelcast.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.org.apache.calcite.plan.volcano.AbstractConverter;
import com.hazelcast.org.apache.calcite.plan.volcano.VolcanoPlanner;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.core.RelFactories;
import com.hazelcast.org.apache.calcite.tools.RelBuilderFactory;

public class ExpandConversionRule
extends RelOptRule {
    public static final ExpandConversionRule INSTANCE = new ExpandConversionRule(RelFactories.LOGICAL_BUILDER);

    public ExpandConversionRule(RelBuilderFactory relBuilderFactory) {
        super(ExpandConversionRule.operand(AbstractConverter.class, ExpandConversionRule.any()), relBuilderFactory, null);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        AbstractConverter converter;
        RelNode child;
        VolcanoPlanner planner = (VolcanoPlanner)call.getPlanner();
        RelNode converted = this.changeTraitsUsingConverters(planner, child = (converter = (AbstractConverter)call.rel(0)).getInput(), converter.getTraitSet());
        if (converted != null) {
            call.transformTo(converted);
        }
    }

    private RelNode changeTraitsUsingConverters(VolcanoPlanner planner, RelNode rel, RelTraitSet toTraits) {
        RelTraitSet fromTraits = rel.getTraitSet();
        assert (fromTraits.size() >= toTraits.size());
        boolean allowInfiniteCostConverters = CalciteSystemProperty.ALLOW_INFINITE_COST_CONVERTERS.value();
        RelNode converted = rel;
        for (int i = 0; converted != null && i < toTraits.size(); ++i) {
            RelTrait fromTrait = converted.getTraitSet().getTrait(i);
            RelTraitDef traitDef = fromTrait.getTraitDef();
            RelTrait toTrait = toTraits.getTrait(i);
            if (toTrait == null) continue;
            assert (traitDef == toTrait.getTraitDef());
            if (fromTrait.satisfies(toTrait)) continue;
            rel = traitDef.convert(planner, converted, toTrait, allowInfiniteCostConverters);
            if (rel != null) {
                assert (rel.getTraitSet().getTrait(traitDef).satisfies(toTrait));
                planner.register(rel, converted);
            }
            converted = rel;
        }
        if (converted != null) assert (converted.getTraitSet().satisfies(toTraits));
        return converted;
    }
}

