/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.parse;

import com.hazelcast.org.apache.calcite.plan.Contexts;
import com.hazelcast.org.apache.calcite.plan.HazelcastRelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelOptCostImpl;
import com.hazelcast.org.apache.calcite.plan.hep.HepPlanner;
import com.hazelcast.org.apache.calcite.plan.hep.HepProgramBuilder;
import com.hazelcast.org.apache.calcite.prepare.Prepare;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.RelRoot;
import com.hazelcast.org.apache.calcite.rel.rules.SubQueryRemoveRule;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql2rel.SqlToRelConverter;
import com.hazelcast.org.apache.calcite.sql2rel.StandardConvertletTable;
import com.hazelcast.org.apache.calcite.util.Pair;
import com.hazelcast.sql.impl.calcite.parse.QueryConvertResult;
import com.hazelcast.sql.impl.calcite.parse.QueryParseResult;

public class QueryConverter {
    private static final boolean EXPAND = false;
    private static final boolean TRIM_UNUSED_FIELDS = true;
    private static final SqlToRelConverter.Config CONFIG;
    private final Prepare.CatalogReader catalogReader;
    private final RelOptCluster cluster;

    public QueryConverter(Prepare.CatalogReader catalogReader, HazelcastRelOptCluster cluster) {
        this.catalogReader = catalogReader;
        this.cluster = cluster;
    }

    public QueryConvertResult convert(QueryParseResult parseResult) {
        SqlNode node = parseResult.getNode();
        SqlToRelConverter converter = parseResult.getSqlBackend().converter(null, parseResult.getValidator(), this.catalogReader, this.cluster, StandardConvertletTable.INSTANCE, CONFIG);
        RelRoot root = converter.convertQuery(node, false, true);
        RelNode relNoSubqueries = QueryConverter.rewriteSubqueries(root.project());
        RelNode relDecorrelated = converter.decorrelate(node, relNoSubqueries);
        RelNode relTrimmed = converter.trimUnusedFields(true, relDecorrelated);
        return new QueryConvertResult(relTrimmed, Pair.right(root.fields));
    }

    private static RelNode rewriteSubqueries(RelNode rel) {
        HepProgramBuilder hepPgmBldr = new HepProgramBuilder();
        hepPgmBldr.addRuleInstance(SubQueryRemoveRule.FILTER);
        hepPgmBldr.addRuleInstance(SubQueryRemoveRule.PROJECT);
        hepPgmBldr.addRuleInstance(SubQueryRemoveRule.JOIN);
        HepPlanner planner = new HepPlanner(hepPgmBldr.build(), Contexts.empty(), true, null, RelOptCostImpl.FACTORY);
        planner.setRoot(rel);
        return planner.findBestExp();
    }

    public Prepare.CatalogReader getCatalogReader() {
        return this.catalogReader;
    }

    static {
        SqlToRelConverter.ConfigBuilder configBuilder = SqlToRelConverter.configBuilder().withExpand(false).withTrimUnusedFields(true);
        CONFIG = configBuilder.build();
    }
}

