/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.exec;

import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.exec.Exec;
import com.hazelcast.sql.impl.exec.IterationResult;
import com.hazelcast.sql.impl.row.EmptyRowBatch;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.row.RowBatch;
import com.hazelcast.sql.impl.worker.QueryFragmentContext;
import java.util.Iterator;

public class UpstreamState
implements Iterable<Row> {
    private final Exec upstream;
    private final UpstreamIterator iter;
    private RowBatch currentBatch = EmptyRowBatch.INSTANCE;
    private int currentBatchPos;
    private IterationResult state;

    public UpstreamState(Exec upstream) {
        this.upstream = upstream;
        this.iter = new UpstreamIterator();
    }

    public boolean advance() {
        if (this.isNextAvailable()) {
            return true;
        }
        if (this.state == IterationResult.FETCHED_DONE) {
            return true;
        }
        this.state = this.upstream.advance();
        switch (this.state) {
            case FETCHED_DONE: 
            case FETCHED: {
                this.currentBatch = this.upstream.currentBatch();
                assert (this.currentBatch != null);
                this.currentBatchPos = 0;
                return true;
            }
        }
        assert (this.state == IterationResult.WAIT);
        this.currentBatch = EmptyRowBatch.INSTANCE;
        this.currentBatchPos = 0;
        return false;
    }

    public void setup(QueryFragmentContext ctx) {
        this.upstream.setup(ctx);
    }

    public RowBatch consumeBatch() {
        if (this.currentBatchPos != 0) {
            throw QueryException.error("Batch can be consumed only as a whole: " + this.upstream);
        }
        RowBatch batch = this.currentBatch;
        this.currentBatchPos = batch.getRowCount();
        return batch;
    }

    public boolean isDone() {
        return this.state == IterationResult.FETCHED_DONE && !this.iter.hasNext();
    }

    @Override
    public Iterator<Row> iterator() {
        return this.iter;
    }

    public Row nextIfExists() {
        return this.isNextAvailable() ? this.iter.next() : null;
    }

    public boolean isNextAvailable() {
        return this.currentBatchPos < this.currentBatch.getRowCount();
    }

    Exec getUpstream() {
        return this.upstream;
    }

    private class UpstreamIterator
    implements Iterator<Row> {
        private UpstreamIterator() {
        }

        @Override
        public boolean hasNext() {
            return UpstreamState.this.isNextAvailable();
        }

        @Override
        public Row next() {
            return UpstreamState.this.currentBatch.getRow(UpstreamState.this.currentBatchPos++);
        }
    }
}

