/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.row;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.sql.impl.SqlDataSerializerHook;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.row.RowBatch;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ListRowBatch
implements RowBatch,
IdentifiedDataSerializable {
    private List<Row> rows;

    public ListRowBatch() {
    }

    public ListRowBatch(List<Row> rows) {
        this.rows = rows;
    }

    @Override
    public Row getRow(int index) {
        return this.rows.get(index);
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public int getFactoryId() {
        return SqlDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 5;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.rows.size());
        for (Row row : this.rows) {
            out.writeObject(row);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int size = in.readInt();
        this.rows = new ArrayList<Row>(size);
        for (int i = 0; i < size; ++i) {
            this.rows.add((Row)in.readObject());
        }
    }
}

