/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring.jet;

import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.pipeline.ServiceFactory;
import com.hazelcast.spring.context.SpringAware;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public final class JetSpringServiceFactories {
    private JetSpringServiceFactories() {
    }

    public static <T> ServiceFactory<?, T> bean(@Nonnull String beanName, @Nonnull Class<T> requiredType) {
        return ServiceFactory.withCreateContextFn((FunctionEx & Serializable)ctx -> new BeanExtractor()).withCreateServiceFn((BiFunctionEx & Serializable)(c, g) -> g.getBean(beanName, requiredType));
    }

    public static <T> ServiceFactory<?, T> bean(@Nonnull Class<T> requiredType) {
        return ServiceFactory.withCreateContextFn((FunctionEx & Serializable)ctx -> new BeanExtractor()).withCreateServiceFn((BiFunctionEx & Serializable)(c, g) -> g.getBean(requiredType));
    }

    public static <T> ServiceFactory<?, T> bean(@Nonnull String beanName) {
        return ServiceFactory.withCreateContextFn((FunctionEx & Serializable)ctx -> new BeanExtractor()).withCreateServiceFn((BiFunctionEx & Serializable)(c, g) -> g.getBean(beanName));
    }

    @SpringAware
    private static final class BeanExtractor {
        @Autowired
        private transient ApplicationContext context;

        private BeanExtractor() {
        }

        public <T> T getBean(String name) {
            this.checkContext();
            return (T)this.context.getBean(name);
        }

        public <T> T getBean(String name, Class<T> type) {
            this.checkContext();
            return (T)this.context.getBean(name, type);
        }

        public <T> T getBean(Class<T> type) {
            this.checkContext();
            return (T)this.context.getBean(type);
        }

        private void checkContext() {
            if (this.context == null) {
                throw new IllegalStateException("The spring managed context is not configured properly");
            }
        }
    }
}

