/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.crypto;

import com.helger.as2lib.crypto.ECryptoAlgorithmCrypt;
import com.helger.as2lib.crypto.ECryptoAlgorithmSign;
import com.helger.as2lib.crypto.MIC;
import com.helger.as2lib.exception.AS2Exception;
import com.helger.as2lib.util.AS2ResourceHelper;
import com.helger.mail.cte.EContentTransferEncoding;
import com.helger.security.keystore.IKeyStoreType;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import javax.mail.internet.MimeBodyPart;

public interface ICryptoHelper {
    @Nonnull
    public KeyStore createNewKeyStore(@Nonnull IKeyStoreType var1) throws GeneralSecurityException;

    @Nonnull
    public KeyStore loadKeyStore(@Nonnull IKeyStoreType var1, @Nonnull @WillNotClose InputStream var2, @Nonnull char[] var3) throws Exception;

    public boolean isEncrypted(@Nonnull MimeBodyPart var1) throws Exception;

    public boolean isSigned(@Nonnull MimeBodyPart var1) throws Exception;

    public boolean isCompressed(@Nonnull String var1) throws AS2Exception;

    @Nonnull
    public MIC calculateMIC(@Nonnull MimeBodyPart var1, @Nonnull ECryptoAlgorithmSign var2, boolean var3) throws Exception;

    @Nonnull
    public MimeBodyPart encrypt(@Nonnull MimeBodyPart var1, @Nonnull X509Certificate var2, @Nonnull ECryptoAlgorithmCrypt var3, @Nonnull EContentTransferEncoding var4) throws Exception;

    @Nonnull
    public MimeBodyPart decrypt(@Nonnull MimeBodyPart var1, @Nonnull X509Certificate var2, @Nonnull PrivateKey var3, boolean var4, @Nonnull AS2ResourceHelper var5) throws Exception;

    @Nonnull
    public MimeBodyPart sign(@Nonnull MimeBodyPart var1, @Nonnull X509Certificate var2, @Nonnull PrivateKey var3, @Nonnull ECryptoAlgorithmSign var4, boolean var5, boolean var6, @Nonnull EContentTransferEncoding var7) throws Exception;

    @Nonnull
    public MimeBodyPart verify(@Nonnull MimeBodyPart var1, @Nullable X509Certificate var2, boolean var3, boolean var4, @Nullable Consumer<X509Certificate> var5, @Nonnull AS2ResourceHelper var6) throws Exception;
}

