/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.disposition;

import com.helger.as2lib.disposition.DispositionType;
import com.helger.as2lib.exception.AS2Exception;
import com.helger.as2lib.processor.AS2ProcessorException;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.ICommonsList;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AS2DispositionException
extends AS2Exception {
    private final transient DispositionType m_aDisposition;
    private final String m_sText;

    public AS2DispositionException(@Nonnull DispositionType dispositionType, @Nullable String string, @Nullable Throwable throwable) {
        super(dispositionType.getAsString(), throwable);
        this.m_aDisposition = dispositionType;
        this.m_sText = string;
    }

    @Nonnull
    public final DispositionType getDisposition() {
        return this.m_aDisposition;
    }

    @Nullable
    public final String getText() {
        return this.m_sText;
    }

    @Nonnull
    public static AS2DispositionException wrap(@Nonnull Exception exception, @Nonnull Supplier<DispositionType> supplier, @Nonnull Supplier<String> supplier2) {
        AS2Exception aS2Exception;
        ICommonsList<AS2Exception> iCommonsList;
        ValueEnforcer.notNull((Object)exception, (String)"Exception");
        ValueEnforcer.notNull(supplier, (String)"DispositionTypeSupplier");
        ValueEnforcer.notNull(supplier2, (String)"TextSupplier");
        if (exception instanceof AS2DispositionException) {
            return (AS2DispositionException)exception;
        }
        if (exception instanceof AS2ProcessorException && (iCommonsList = ((AS2ProcessorException)exception).getAllCauses()).size() == 1 && (aS2Exception = (AS2Exception)iCommonsList.getFirst()) instanceof AS2DispositionException) {
            return (AS2DispositionException)aS2Exception;
        }
        return new AS2DispositionException(supplier.get(), supplier2.get(), exception);
    }
}

