/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.util.http;

import com.helger.as2lib.exception.AS2Exception;
import com.helger.as2lib.util.AS2IOHelper;
import com.helger.as2lib.util.AS2ResourceHelper;
import com.helger.as2lib.util.dump.IHTTPOutgoingDumper;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.http.EHttpMethod;
import com.helger.commons.http.HttpHeaderMap;
import com.helger.commons.io.stream.CountingInputStream;
import com.helger.mail.cte.EContentTransferEncoding;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.mail.MessagingException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AS2HttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(AS2HttpClient.class);
    private final RequestBuilder m_aRequestBuilder;
    private final CloseableHttpClient m_aCloseableHttpClient;
    private CloseableHttpResponse m_aCloseableHttpResponse;

    public AS2HttpClient(@Nonnull @Nonempty String string, int n, int n2, @Nonnull EHttpMethod eHttpMethod, @Nullable Proxy proxy, @Nullable SSLContext sSLContext, @Nullable HostnameVerifier hostnameVerifier) {
        RequestConfig.Builder builder = RequestConfig.custom().setConnectionRequestTimeout(n).setConnectTimeout(n).setSocketTimeout(n2);
        AS2HttpClient._setProxyToRequestConfig(builder, proxy);
        RequestConfig requestConfig = builder.build();
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        if (sSLContext != null) {
            httpClientBuilder.setSSLContext(sSLContext);
        }
        if (hostnameVerifier != null) {
            httpClientBuilder.setSSLHostnameVerifier(hostnameVerifier);
        }
        this.m_aCloseableHttpClient = httpClientBuilder.build();
        this.m_aRequestBuilder = RequestBuilder.create((String)eHttpMethod.getName()).setUri(string).setConfig(requestConfig);
    }

    public void setHttpHeader(@Nonnull String string, @Nonnull String string2) {
        ValueEnforcer.notNull((Object)string, (String)"Name");
        ValueEnforcer.notNull((Object)string2, (String)"Value");
        this.m_aRequestBuilder.setHeader(string, string2);
    }

    @Nonnull
    public URL getURL() throws AS2Exception {
        URI uRI = this.m_aRequestBuilder.getUri();
        try {
            return uRI.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Failed to get URL from connection, URI: " + uRI.toASCIIString(), (Throwable)malformedURLException);
            }
            throw new AS2Exception(malformedURLException.getCause());
        }
    }

    @Nonnegative
    public long send(@Nonnull InputStream inputStream, final @Nullable EContentTransferEncoding eContentTransferEncoding, final @Nullable IHTTPOutgoingDumper iHTTPOutgoingDumper, @Nonnull AS2ResourceHelper aS2ResourceHelper) throws IOException {
        CountingInputStream countingInputStream = new CountingInputStream(inputStream);
        InputStreamEntity inputStreamEntity = new InputStreamEntity((InputStream)countingInputStream){

            public InputStream getContent() throws IOException {
                throw new UnsupportedOperationException();
            }

            public void writeTo(@Nonnull OutputStream outputStream) throws IOException {
                try (OutputStream outputStream2 = iHTTPOutgoingDumper != null ? iHTTPOutgoingDumper.getDumpOS(outputStream) : outputStream;
                     OutputStream outputStream3 = eContentTransferEncoding != null ? AS2IOHelper.getContentTransferEncodingAwareOutputStream(outputStream2, eContentTransferEncoding.getID()) : outputStream2;){
                    super.writeTo(outputStream3);
                }
                catch (MessagingException messagingException) {
                    throw new IllegalStateException("Failed to encode OutputStream with CTE '" + eContentTransferEncoding + "'", messagingException);
                }
            }
        };
        HttpEntity httpEntity = aS2ResourceHelper.createRepeatableHttpEntity((HttpEntity)inputStreamEntity);
        this.m_aRequestBuilder.setEntity(httpEntity);
        HttpUriRequest httpUriRequest = this.m_aRequestBuilder.build();
        this.m_aCloseableHttpResponse = this.m_aCloseableHttpClient.execute(httpUriRequest);
        return countingInputStream.getBytesRead();
    }

    public InputStream getInputStream() throws AS2Exception, IOException {
        if (this.m_aCloseableHttpResponse == null) {
            throw new AS2Exception("No response as message was yet sent");
        }
        return this.m_aCloseableHttpResponse.getEntity().getContent();
    }

    public int getResponseCode() throws AS2Exception {
        if (this.m_aCloseableHttpResponse == null) {
            throw new AS2Exception("No response as message was yet sent");
        }
        try {
            StatusLine statusLine = this.m_aCloseableHttpResponse.getStatusLine();
            return statusLine.getStatusCode();
        }
        catch (Exception exception) {
            throw new AS2Exception(exception);
        }
    }

    public String getResponseMessage() throws AS2Exception {
        if (this.m_aCloseableHttpResponse == null) {
            throw new AS2Exception("No response as message was yet sent");
        }
        StatusLine statusLine = this.m_aCloseableHttpResponse.getStatusLine();
        return statusLine.getReasonPhrase();
    }

    @Nonnull
    @ReturnsMutableCopy
    public HttpHeaderMap getResponseHeaderFields() throws AS2Exception {
        if (this.m_aCloseableHttpResponse == null) {
            throw new AS2Exception("No response as message was yet sent");
        }
        Header[] headerArray = this.m_aCloseableHttpResponse.getAllHeaders();
        HttpHeaderMap httpHeaderMap = new HttpHeaderMap();
        for (Header header : headerArray) {
            httpHeaderMap.addHeader(header.getName(), header.getValue());
        }
        return httpHeaderMap;
    }

    public void disconnect() {
        block4: {
            try {
                if (this.m_aCloseableHttpResponse != null) {
                    this.m_aCloseableHttpResponse.close();
                }
                if (this.m_aCloseableHttpClient != null) {
                    this.m_aCloseableHttpClient.close();
                }
            }
            catch (Exception exception) {
                if (!LOGGER.isErrorEnabled()) break block4;
                LOGGER.error("Exception while closing HttpClient connection: " + this.toString(), (Throwable)exception);
            }
        }
    }

    private static void _setProxyToRequestConfig(@Nonnull RequestConfig.Builder builder, @Nullable Proxy proxy) {
        block6: {
            try {
                SocketAddress socketAddress;
                if (proxy != null && (socketAddress = proxy.address()) instanceof InetSocketAddress) {
                    InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
                    InetAddress inetAddress = inetSocketAddress.getAddress();
                    if (inetAddress != null) {
                        HttpHost httpHost = new HttpHost(inetAddress, inetSocketAddress.getPort());
                        builder.setProxy(httpHost);
                    } else if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("No address in proxy:" + proxy.address() + "-" + (null != proxy.type() ? proxy.type().name() : "null"));
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                if (!LOGGER.isErrorEnabled()) break block6;
                LOGGER.error("Exception while setting proxy. Continue without proxy. aProxy:" + proxy.address() + "-" + (null != proxy.type() ? proxy.type().name() : "null"), (Throwable)runtimeException);
            }
        }
    }

    public static boolean isErrorResponseCode(int n) {
        return n != 200 && n != 201 && n != 202 && n != 204 && n != 206;
    }
}

