/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.client;

import com.helger.as2lib.message.IMessageMDN;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.string.ToStringGenerator;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.time.Duration;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AS2ClientResponse
implements Serializable {
    private String m_sOriginalMessageID;
    private Throwable m_aThrowable;
    private IMessageMDN m_aMDN;
    private Duration m_aExecutionDuration;
    private X509Certificate m_aMDNVerificationCertificate;

    public void setOriginalMessageID(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"OriginalMessageID");
        this.m_sOriginalMessageID = string;
    }

    @Nullable
    public String getOriginalMessageID() {
        return this.m_sOriginalMessageID;
    }

    public void setException(@Nonnull Throwable throwable) {
        ValueEnforcer.notNull((Object)throwable, (String)"Throwable");
        this.m_aThrowable = throwable;
    }

    public boolean hasException() {
        return this.m_aThrowable != null;
    }

    @Nullable
    public Throwable getException() {
        return this.m_aThrowable;
    }

    public void setMDN(@Nonnull IMessageMDN iMessageMDN) {
        ValueEnforcer.notNull((Object)iMessageMDN, (String)"MDN");
        this.m_aMDN = iMessageMDN;
    }

    public boolean hasMDN() {
        return this.m_aMDN != null;
    }

    @Nullable
    public IMessageMDN getMDN() {
        return this.m_aMDN;
    }

    @Nullable
    public String getMDNMessageID() {
        return this.m_aMDN == null ? null : this.m_aMDN.getMessageID();
    }

    @Nullable
    public String getMDNText() {
        return this.m_aMDN == null ? null : this.m_aMDN.getText();
    }

    @Nullable
    public String getMDNDisposition() {
        return this.m_aMDN == null ? null : this.m_aMDN.attrs().getAsString((Object)"DISPOSITION");
    }

    @Nullable
    public X509Certificate getMDNVerificationCertificate() {
        return this.m_aMDNVerificationCertificate;
    }

    public void setMDNVerificationCertificate(@Nullable X509Certificate x509Certificate) {
        this.m_aMDNVerificationCertificate = x509Certificate;
    }

    public void setExecutionDuration(@Nonnull Duration duration) {
        ValueEnforcer.notNull((Object)duration, (String)"ExecutionDuration");
        this.m_aExecutionDuration = duration;
    }

    public boolean hasExecutionDuration() {
        return this.m_aExecutionDuration != null;
    }

    @Nullable
    public Duration getExecutionDuration() {
        return this.m_aExecutionDuration;
    }

    @Nonnull
    public String getAsString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\n');
        if (this.m_sOriginalMessageID != null) {
            stringBuilder.append("OriginalMessageID: ").append(this.m_sOriginalMessageID).append('\n');
        }
        if (this.getMDNMessageID() != null) {
            stringBuilder.append("MDN MessageID: ").append(this.getMDNMessageID()).append('\n');
        }
        if (this.getMDNDisposition() != null) {
            stringBuilder.append("MDN Disposition: ").append(this.getMDNDisposition()).append('\n');
        }
        if (this.hasException()) {
            stringBuilder.append("Error message: ").append(this.m_aThrowable.getMessage()).append('\n');
        }
        if (this.getMDNText() != null) {
            stringBuilder.append("MDN Text: ").append(this.getMDNText()).append('\n');
        }
        if (this.hasExecutionDuration()) {
            stringBuilder.append("Sending duration: ").append(this.m_aExecutionDuration.toString()).append('\n');
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("OriginalMessageID", (Object)this.m_sOriginalMessageID).append("Throwable", (Object)this.m_aThrowable).append("MDN", (Object)this.m_aMDN).append("MDNVerificationCertificate", (Object)this.m_aMDNVerificationCertificate).append("ExecutionDuration", (Object)this.m_aExecutionDuration).getToString();
    }
}

