/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.processor.receiver;

import com.helger.as2lib.exception.AS2Exception;
import com.helger.as2lib.processor.receiver.AbstractActiveReceiverModule;
import com.helger.as2lib.session.IAS2Session;
import com.helger.commons.collection.attr.IStringMap;
import java.util.Timer;
import java.util.TimerTask;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractActivePollingModule
extends AbstractActiveReceiverModule {
    public static final String ATTR_POLLING_INTERVAL = "interval";
    private static final Logger LOGGER = LoggerFactory.getLogger(PollTask.class);
    private Timer m_aTimer;
    private boolean m_bBusy;

    @Override
    @OverridingMethodsMustInvokeSuper
    public void initDynamicComponent(@Nonnull IAS2Session iAS2Session, @Nullable IStringMap iStringMap) throws AS2Exception {
        super.initDynamicComponent(iAS2Session, iStringMap);
        this.getAttributeAsStringRequired(ATTR_POLLING_INTERVAL);
    }

    public void setInterval(long l) {
        this.attrs().putIn(ATTR_POLLING_INTERVAL, l);
    }

    public long getInterval() {
        return this.attrs().getAsLong((Object)ATTR_POLLING_INTERVAL, 0L);
    }

    public abstract void poll();

    @Override
    public void doStart() throws AS2Exception {
        this.m_aTimer = new Timer(true);
        this.m_aTimer.scheduleAtFixedRate((TimerTask)new PollTask(), 0L, this.getInterval() * 1000L);
    }

    @Override
    public void doStop() throws AS2Exception {
        if (this.m_aTimer != null) {
            this.m_aTimer.cancel();
            this.m_aTimer = null;
        }
    }

    public boolean isBusy() {
        return this.m_bBusy;
    }

    public void setBusy(boolean bl) {
        this.m_bBusy = bl;
    }

    private class PollTask
    extends TimerTask {
        private PollTask() {
        }

        @Override
        public void run() {
            if (!AbstractActivePollingModule.this.isBusy()) {
                AbstractActivePollingModule.this.setBusy(true);
                AbstractActivePollingModule.this.poll();
                AbstractActivePollingModule.this.setBusy(false);
            } else {
                LOGGER.info("Miss tick");
            }
        }
    }
}

