/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.processor.receiver.net;

import com.helger.as2lib.cert.ECertificatePartnershipType;
import com.helger.as2lib.cert.ICertificateFactory;
import com.helger.as2lib.crypto.IMICMatchingHandler;
import com.helger.as2lib.crypto.LoggingMICMatchingHandler;
import com.helger.as2lib.crypto.MIC;
import com.helger.as2lib.disposition.AS2DispositionException;
import com.helger.as2lib.disposition.DispositionType;
import com.helger.as2lib.exception.AS2Exception;
import com.helger.as2lib.exception.WrappedAS2Exception;
import com.helger.as2lib.message.AS2Message;
import com.helger.as2lib.message.AS2MessageMDN;
import com.helger.as2lib.processor.AS2NoModuleException;
import com.helger.as2lib.processor.receiver.AS2MDNReceiverModule;
import com.helger.as2lib.processor.receiver.AbstractActiveNetModule;
import com.helger.as2lib.processor.receiver.net.AS2NetException;
import com.helger.as2lib.processor.receiver.net.AbstractReceiverHandler;
import com.helger.as2lib.session.AS2ComponentNotFoundException;
import com.helger.as2lib.util.AS2Helper;
import com.helger.as2lib.util.AS2HttpHelper;
import com.helger.as2lib.util.AS2IOHelper;
import com.helger.as2lib.util.AS2ResourceHelper;
import com.helger.as2lib.util.dump.IHTTPIncomingDumper;
import com.helger.as2lib.util.http.AS2HttpClient;
import com.helger.as2lib.util.http.AS2HttpResponseHandlerSocket;
import com.helger.as2lib.util.http.AS2InputStreamProviderSocket;
import com.helger.as2lib.util.http.HTTPHelper;
import com.helger.as2lib.util.http.IAS2HttpResponseHandler;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.io.stream.NonBlockingByteArrayOutputStream;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.state.ETriState;
import com.helger.commons.string.StringParser;
import com.helger.mail.datasource.ByteArrayDataSource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.activation.DataSource;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AS2MDNReceiverHandler
extends AbstractReceiverHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AS2MDNReceiverHandler.class);
    private final AS2MDNReceiverModule m_aModule;
    private IMICMatchingHandler m_aMICMatchingHandler = new LoggingMICMatchingHandler();

    public AS2MDNReceiverHandler(@Nonnull AS2MDNReceiverModule aS2MDNReceiverModule) {
        this.m_aModule = (AS2MDNReceiverModule)ValueEnforcer.notNull((Object)aS2MDNReceiverModule, (String)"Module");
    }

    @Nonnull
    public final AS2MDNReceiverModule getModule() {
        return this.m_aModule;
    }

    @Nonnull
    public final IMICMatchingHandler getMICMatchingHandler() {
        return this.m_aMICMatchingHandler;
    }

    public final void setMICMatchingHandler(@Nonnull IMICMatchingHandler iMICMatchingHandler) {
        ValueEnforcer.notNull((Object)iMICMatchingHandler, (String)"MICMatchingHandler");
        this.m_aMICMatchingHandler = iMICMatchingHandler;
    }

    @Override
    public void handle(@Nonnull AbstractActiveNetModule abstractActiveNetModule, @Nonnull Socket socket) {
        String string = this.getClientInfo(socket);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("incoming connection [" + string + "]");
        }
        AS2Message aS2Message = new AS2Message();
        boolean bl = this.m_aModule.isQuoteHeaderValues();
        AS2HttpResponseHandlerSocket aS2HttpResponseHandlerSocket = new AS2HttpResponseHandlerSocket(socket, bl);
        byte[] byArray = null;
        try (AS2ResourceHelper aS2ResourceHelper = new AS2ResourceHelper();){
            IHTTPIncomingDumper iHTTPIncomingDumper = this.getEffectiveHttpIncomingDumper();
            DataSource dataSource = this.readAndDecodeHttpRequest(new AS2InputStreamProviderSocket(socket), aS2HttpResponseHandlerSocket, aS2Message, iHTTPIncomingDumper);
            byArray = StreamHelper.getAllBytes((InputStream)dataSource.getInputStream());
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("incoming connection for receiving AsyncMDN [" + string + "]" + aS2Message.getLoggingText());
            }
            String string2 = AS2HttpHelper.getCleanContentType(aS2Message.getHeader("Content-Type"));
            MimeBodyPart mimeBodyPart = new MimeBodyPart(AS2HttpHelper.getAsInternetHeaders(aS2Message.headers()), byArray);
            aS2Message.setData(mimeBodyPart);
            mimeBodyPart.setDataHandler(new ByteArrayDataSource(byArray, string2, null).getAsDataHandler());
            mimeBodyPart.setHeader("Content-Type", string2);
            aS2Message.setData(mimeBodyPart);
            this.receiveMDN(aS2Message, byArray, aS2HttpResponseHandlerSocket, aS2ResourceHelper);
        }
        catch (Exception exception) {
            AS2NetException aS2NetException = new AS2NetException(socket.getInetAddress(), socket.getPort(), exception);
            aS2NetException.terminate();
        }
    }

    protected final void receiveMDN(@Nonnull AS2Message aS2Message, byte[] byArray, @Nonnull IAS2HttpResponseHandler iAS2HttpResponseHandler, @Nonnull AS2ResourceHelper aS2ResourceHelper) throws AS2Exception, IOException {
        block10: {
            try {
                AS2MessageMDN aS2MessageMDN = new AS2MessageMDN(aS2Message);
                aS2MessageMDN.headers().setAllHeaders(aS2Message.headers());
                MimeBodyPart mimeBodyPart = new MimeBodyPart(AS2HttpHelper.getAsInternetHeaders(aS2MessageMDN.headers()), byArray);
                aS2Message.getMDN().setData(mimeBodyPart);
                aS2MessageMDN.partnership().setSenderAS2ID(aS2MessageMDN.getHeader("AS2-From"));
                aS2MessageMDN.partnership().setReceiverAS2ID(aS2MessageMDN.getHeader("AS2-To"));
                aS2MessageMDN.partnership().setSenderX509Alias(aS2Message.partnership().getReceiverX509Alias());
                aS2MessageMDN.partnership().setReceiverX509Alias(aS2Message.partnership().getSenderX509Alias());
                this.getModule().getSession().getPartnershipFactory().updatePartnership(aS2MessageMDN, false);
                ICertificateFactory iCertificateFactory = this.getModule().getSession().getCertificateFactory();
                X509Certificate x509Certificate = iCertificateFactory.getCertificate(aS2MessageMDN, ECertificatePartnershipType.SENDER);
                ETriState eTriState = aS2Message.partnership().getVerifyUseCertificateInBodyPart();
                boolean bl = eTriState.isDefined() ? eTriState.getAsBooleanValue() : this.getModule().getSession().isCryptoVerifyUseCertificateInBodyPart();
                AS2Helper.parseMDN(aS2Message, x509Certificate, bl, this.getVerificationCertificateConsumer(), aS2ResourceHelper);
                aS2Message.partnership().setSenderAS2ID(aS2MessageMDN.getHeader("AS2-To"));
                aS2Message.partnership().setReceiverAS2ID(aS2MessageMDN.getHeader("AS2-From"));
                this.getModule().getSession().getPartnershipFactory().updatePartnership(aS2Message, false);
                aS2Message.setMessageID(aS2Message.getMDN().attrs().getAsString((Object)"ORIGINAL_MESSAGE_ID"));
                try {
                    this.getModule().getSession().getMessageProcessor().handle("storemdn", aS2Message, null);
                }
                catch (AS2NoModuleException | AS2ComponentNotFoundException aS2Exception) {
                    // empty catch block
                }
                if (this.checkAsyncMDN(aS2Message)) {
                    HTTPHelper.sendSimpleHTTPResponse(iAS2HttpResponseHandler, 200);
                } else {
                    HTTPHelper.sendSimpleHTTPResponse(iAS2HttpResponseHandler, 404);
                }
                String string = aS2Message.getMDN().attrs().getAsString((Object)"DISPOSITION");
                try {
                    DispositionType.createFromString(string).validate();
                }
                catch (AS2DispositionException aS2DispositionException) {
                    aS2DispositionException.setText(aS2Message.getMDN().getText());
                    if (aS2DispositionException.getDisposition().isWarning()) {
                        aS2DispositionException.setSourceMsg(aS2Message).terminate();
                        break block10;
                    }
                    throw aS2DispositionException;
                }
            }
            catch (IOException iOException) {
                HTTPHelper.sendSimpleHTTPResponse(iAS2HttpResponseHandler, 400);
                throw iOException;
            }
            catch (Exception exception) {
                HTTPHelper.sendSimpleHTTPResponse(iAS2HttpResponseHandler, 400);
                throw WrappedAS2Exception.wrap(exception).setSourceMsg(aS2Message);
            }
        }
    }

    public boolean checkAsyncMDN(@Nonnull AS2Message aS2Message) throws AS2Exception {
        try {
            File file;
            MIC mIC;
            String string;
            String string2 = aS2Message.getMDN().attrs().getAsString((Object)"MIC");
            MIC mIC2 = MIC.parse(string2);
            String string3 = aS2Message.getMDN().attrs().getAsString((Object)"ORIGINAL_MESSAGE_ID");
            String string4 = AS2IOHelper.getSafeFileAndFolderName(this.getModule().getSession().getMessageProcessor().attrs().getAsString((Object)"pendingmdninfo"));
            String string5 = string4 + FilenameHelper.UNIX_SEPARATOR_STR + AS2IOHelper.getFilenameFromMessageID(string3);
            Object object = FileHelper.getBufferedReader((File)new File(string5), (Charset)StandardCharsets.ISO_8859_1);
            Serializable serializable = null;
            try {
                string = object.readLine();
                mIC = MIC.parse(string);
                file = new File(object.readLine());
            }
            catch (Throwable throwable) {
                serializable = throwable;
                throw throwable;
            }
            finally {
                if (object != null) {
                    if (serializable != null) {
                        try {
                            object.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)serializable).addSuppressed(throwable);
                        }
                    } else {
                        object.close();
                    }
                }
            }
            object = aS2Message.getMDN().attrs().getAsString((Object)"DISPOSITION");
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("received MDN [" + (String)object + "]" + aS2Message.getLoggingText());
            }
            if (mIC == null || mIC2 == null || !mIC2.equals(mIC)) {
                this.m_aMICMatchingHandler.onMICMismatch(aS2Message, string, string2);
                return false;
            }
            this.m_aMICMatchingHandler.onMICMatch(aS2Message, string2);
            serializable = new File(string5);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("delete pendinginfo file : " + ((File)serializable).getName() + " from pending folder : " + string4 + aS2Message.getLoggingText());
            }
            if (!((File)serializable).delete() && LOGGER.isErrorEnabled()) {
                LOGGER.error("Error delete pendinginfo file " + file);
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("delete pending file : " + file.getName() + " from pending folder : " + file.getParent() + aS2Message.getLoggingText());
            }
            if (!file.delete() && LOGGER.isErrorEnabled()) {
                LOGGER.error("Error delete pending file " + file);
            }
        }
        catch (AS2ComponentNotFoundException | IOException exception) {
            LOGGER.error("Error checking async MDN", (Throwable)exception);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reparse(@Nonnull AS2Message aS2Message, @Nonnull AS2HttpClient aS2HttpClient, @Nullable IHTTPIncomingDumper iHTTPIncomingDumper) throws AS2Exception {
        InputStream inputStream;
        NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream;
        AS2MessageMDN aS2MessageMDN;
        block9: {
            aS2MessageMDN = new AS2MessageMDN(aS2Message);
            aS2MessageMDN.headers().addAllHeaders(aS2HttpClient.getResponseHeaderFields());
            nonBlockingByteArrayOutputStream = null;
            try {
                inputStream = aS2HttpClient.getInputStream();
                nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();
                long l = StringParser.parseLong((String)aS2MessageMDN.getHeader("Content-Length"), (long)-1L);
                if (l >= 0L) {
                    StreamHelper.copyInputStreamToOutputStreamWithLimit((InputStream)inputStream, (OutputStream)nonBlockingByteArrayOutputStream, (long)l);
                    break block9;
                }
                StreamHelper.copyInputStreamToOutputStream((InputStream)inputStream, (OutputStream)nonBlockingByteArrayOutputStream);
            }
            catch (IOException iOException) {
                try {
                    LOGGER.error("Error reparsing", (Throwable)iOException);
                }
                catch (Throwable throwable) {
                    StreamHelper.close(nonBlockingByteArrayOutputStream);
                    throw throwable;
                }
                StreamHelper.close((AutoCloseable)nonBlockingByteArrayOutputStream);
            }
        }
        StreamHelper.close((AutoCloseable)nonBlockingByteArrayOutputStream);
        if (iHTTPIncomingDumper != null) {
            iHTTPIncomingDumper.dumpIncomingRequest((List<String>)aS2MessageMDN.headers().getAllHeaderLines(true), nonBlockingByteArrayOutputStream != null ? nonBlockingByteArrayOutputStream.toByteArray() : ArrayHelper.EMPTY_BYTE_ARRAY, aS2MessageMDN);
        }
        inputStream = null;
        if (nonBlockingByteArrayOutputStream != null) {
            try {
                inputStream = new MimeBodyPart(AS2HttpHelper.getAsInternetHeaders(aS2MessageMDN.headers()), nonBlockingByteArrayOutputStream.toByteArray());
            }
            catch (MessagingException messagingException) {
                LOGGER.error("Error creating MimeBodyPart", (Throwable)messagingException);
            }
        }
        aS2Message.getMDN().setData((MimeBodyPart)inputStream);
        aS2MessageMDN.partnership().setSenderAS2ID(aS2MessageMDN.getHeader("AS2-From"));
        aS2MessageMDN.partnership().setReceiverAS2ID(aS2MessageMDN.getHeader("AS2-To"));
    }
}

