/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.processor.resender;

import com.helger.as2lib.message.IMessage;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.datetime.PDTFactory;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ResendItem
implements Serializable {
    private final String m_sResendAction;
    private final int m_nRetries;
    private final IMessage m_aMsg;
    private final LocalDateTime m_aEarliestResendDT;

    public ResendItem(@Nonnull @Nonempty String string, @Nonnegative int n, @Nonnull IMessage iMessage, @Nonnegative long l) {
        this.m_sResendAction = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"ResendAction");
        this.m_nRetries = ValueEnforcer.isGE0((int)n, (String)"Retries");
        this.m_aMsg = (IMessage)ValueEnforcer.notNull((Object)iMessage, (String)"Message");
        ValueEnforcer.isGE0((long)l, (String)"ResendDelayMS");
        this.m_aEarliestResendDT = PDTFactory.getCurrentLocalDateTime().plus(l, ChronoUnit.MILLIS);
    }

    @Nonnull
    @Nonempty
    public String getResendAction() {
        return this.m_sResendAction;
    }

    @Nonnegative
    public int getRetries() {
        return this.m_nRetries;
    }

    @Nonnull
    public IMessage getMessage() {
        return this.m_aMsg;
    }

    @Nonnull
    public LocalDateTime getEarliestResendDate() {
        return this.m_aEarliestResendDT;
    }

    public boolean isTimeToSend() {
        return this.m_aEarliestResendDT.compareTo(PDTFactory.getCurrentLocalDateTime()) <= 0;
    }
}

