/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.processor.storage;

import com.helger.as2lib.exception.AS2Exception;
import com.helger.as2lib.message.IMessage;
import com.helger.as2lib.params.AS2InvalidParameterException;
import com.helger.as2lib.processor.module.AbstractProcessorModule;
import com.helger.as2lib.processor.storage.IProcessorStorageModule;
import com.helger.as2lib.session.IAS2Session;
import com.helger.as2lib.util.AS2IOHelper;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.charset.CharsetHelper;
import com.helger.commons.collection.attr.IStringMap;
import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.system.SystemHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;

public abstract class AbstractStorageModule
extends AbstractProcessorModule
implements IProcessorStorageModule {
    public static final String ATTR_FILENAME = "filename";
    public static final String ATTR_PROTOCOL = "protocol";
    public static final String ATTR_TEMPDIR = "tempdir";
    public static final String ATTR_CHARSET = "charset";
    private final String m_sModuleAction;

    protected AbstractStorageModule(@Nonnull @Nonempty String string) {
        this.m_sModuleAction = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"ModuleAction");
    }

    @Nullable
    public final String getFilename() {
        return this.attrs().getAsString((Object)ATTR_FILENAME);
    }

    public final void setFilename(@Nullable String string) {
        if (string == null) {
            this.attrs().remove((Object)ATTR_FILENAME);
        } else {
            this.attrs().putIn((Object)ATTR_FILENAME, (Object)string);
        }
    }

    @Nullable
    public final String getProtocol() {
        return this.attrs().getAsString((Object)ATTR_PROTOCOL);
    }

    public final void setProtocol(@Nullable String string) {
        if (string == null) {
            this.attrs().remove((Object)ATTR_PROTOCOL);
        } else {
            this.attrs().putIn((Object)ATTR_PROTOCOL, (Object)string);
        }
    }

    @Nullable
    public final String getTempDir() {
        return this.attrs().getAsString((Object)ATTR_TEMPDIR);
    }

    public final void setTempDir(@Nullable String string) {
        if (string == null) {
            this.attrs().remove((Object)ATTR_TEMPDIR);
        } else {
            this.attrs().putIn((Object)ATTR_TEMPDIR, (Object)string);
        }
    }

    @Nullable
    public final String getCharsetName() {
        return this.attrs().getAsString((Object)ATTR_CHARSET);
    }

    @Nonnull
    protected Charset getCharset() {
        Charset charset = CharsetHelper.getCharsetFromNameOrNull((String)this.getCharsetName());
        return charset != null ? charset : SystemHelper.getSystemCharset();
    }

    public final void setCharsetName(@Nullable String string) {
        if (string == null) {
            this.attrs().remove((Object)ATTR_CHARSET);
        } else {
            this.attrs().putIn((Object)ATTR_CHARSET, (Object)string);
        }
    }

    @Override
    public final boolean canHandle(@Nonnull String string, @Nonnull IMessage iMessage, @Nullable Map<String, Object> map) {
        if (!string.equals(this.m_sModuleAction)) {
            return false;
        }
        String string2 = this.getProtocol();
        if (string2 == null) {
            return false;
        }
        return string2.equals(iMessage.getProtocol());
    }

    @Override
    public final void initDynamicComponent(@Nonnull IAS2Session iAS2Session, @Nullable IStringMap iStringMap) throws AS2Exception {
        super.initDynamicComponent(iAS2Session, iStringMap);
        this.getAttributeAsStringRequired(ATTR_FILENAME);
    }

    protected abstract String getFilename(IMessage var1, String var2) throws AS2InvalidParameterException;

    @Nonnull
    @OverrideOnDemand
    protected File getFile(@Nonnull IMessage iMessage, @Nullable String string) throws IOException, AS2Exception {
        String string2 = this.getFilename(iMessage, string);
        File file = new File(string2);
        AS2IOHelper.getFileOperationManager().createDirRecursiveIfNotExisting(file.getParentFile());
        return AS2IOHelper.getUniqueFile(file.getParentFile(), FilenameHelper.getAsSecureValidFilename((String)file.getName()));
    }

    private static void _writeStreamToFile(@Nonnull @WillClose InputStream inputStream, @Nonnull File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        if (StreamHelper.copyInputStreamToOutputStreamAndCloseOS((InputStream)inputStream, (OutputStream)fileOutputStream).isFailure()) {
            throw new IOException("Failed to write content to " + file.getAbsolutePath());
        }
    }

    protected void store(@Nonnull File file, @Nonnull @WillClose InputStream inputStream) throws IOException {
        String string = this.getTempDir();
        if (string != null) {
            File file2 = AS2IOHelper.getDirectoryFile(string);
            File file3 = AS2IOHelper.getUniqueFile(file2, file.getName());
            AbstractStorageModule._writeStreamToFile(inputStream, file3);
            if (AS2IOHelper.getFileOperationManager().renameFile(file3, file).isFailure()) {
                throw new IOException("Rename from " + file3.getAbsolutePath() + " to " + file.getAbsolutePath() + " failed!");
            }
        } else {
            AbstractStorageModule._writeStreamToFile(inputStream, file);
        }
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

