/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.util;

import com.helger.as2lib.CAS2Info;
import com.helger.as2lib.cert.AS2CertificateNotFoundException;
import com.helger.as2lib.cert.AS2KeyNotFoundException;
import com.helger.as2lib.cert.ECertificatePartnershipType;
import com.helger.as2lib.crypto.BCCryptoHelper;
import com.helger.as2lib.crypto.ECryptoAlgorithmSign;
import com.helger.as2lib.crypto.ICryptoHelper;
import com.helger.as2lib.crypto.MIC;
import com.helger.as2lib.disposition.DispositionOptions;
import com.helger.as2lib.disposition.DispositionType;
import com.helger.as2lib.message.AS2Message;
import com.helger.as2lib.message.AS2MessageMDN;
import com.helger.as2lib.message.IMessage;
import com.helger.as2lib.message.IMessageMDN;
import com.helger.as2lib.params.MessageParameters;
import com.helger.as2lib.partner.AS2PartnershipNotFoundException;
import com.helger.as2lib.partner.Partnership;
import com.helger.as2lib.session.IAS2Session;
import com.helger.as2lib.util.AS2DateHelper;
import com.helger.as2lib.util.AS2HttpHelper;
import com.helger.as2lib.util.AS2IOHelper;
import com.helger.as2lib.util.AS2ResourceHelper;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.mime.CMimeType;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.state.ETriState;
import com.helger.commons.wrapper.Wrapper;
import com.helger.mail.cte.EContentTransferEncoding;
import com.helger.security.certificate.CertificateHelper;
import java.io.InputStream;
import java.io.Serializable;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.mail.BodyPart;
import javax.mail.Multipart;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class AS2Helper {
    private static final Logger LOGGER = LoggerFactory.getLogger(AS2Helper.class);
    private static final String HEADER_RECEIVED_CONTENT_MIC = "Received-Content-MIC";
    private static final String HEADER_DISPOSITION = "Disposition";
    private static final String HEADER_ORIGINAL_MESSAGE_ID = "Original-Message-ID";
    private static final String HEADER_FINAL_RECIPIENT = "Final-Recipient";
    private static final String HEADER_ORIGINAL_RECIPIENT = "Original-Recipient";
    private static final String HEADER_REPORTING_UA = "Reporting-UA";

    private AS2Helper() {
    }

    @Nonnull
    public static ICryptoHelper getCryptoHelper() {
        return SingletonHolder.s_aInstance;
    }

    public static void createMDNData(@Nonnull IAS2Session iAS2Session, @Nonnull IMessageMDN iMessageMDN, boolean bl, boolean bl2, @Nullable ECryptoAlgorithmSign eCryptoAlgorithmSign, boolean bl3) throws Exception {
        ValueEnforcer.notNull((Object)iAS2Session, (String)"AS2Session");
        ValueEnforcer.notNull((Object)iMessageMDN, (String)"MDN");
        if (bl) {
            ValueEnforcer.notNull((Object)eCryptoAlgorithmSign, (String)"MICAlg");
        }
        MimeMultipart mimeMultipart = new MimeMultipart();
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        String string = iMessageMDN.getText() + "\r\n";
        mimeBodyPart.setContent((Object)string, CMimeType.TEXT_PLAIN.getAsString());
        mimeBodyPart.setHeader("Content-Type", CMimeType.TEXT_PLAIN.getAsString());
        mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
        MimeBodyPart mimeBodyPart2 = new MimeBodyPart();
        InternetHeaders internetHeaders = new InternetHeaders();
        internetHeaders.setHeader(HEADER_REPORTING_UA, iMessageMDN.attrs().getAsString((Object)"REPORTING_UA"));
        internetHeaders.setHeader(HEADER_ORIGINAL_RECIPIENT, iMessageMDN.attrs().getAsString((Object)"ORIGINAL_RECIPIENT"));
        internetHeaders.setHeader(HEADER_FINAL_RECIPIENT, iMessageMDN.attrs().getAsString((Object)"FINAL_RECIPIENT"));
        internetHeaders.setHeader(HEADER_ORIGINAL_MESSAGE_ID, iMessageMDN.attrs().getAsString((Object)"ORIGINAL_MESSAGE_ID"));
        internetHeaders.setHeader(HEADER_DISPOSITION, iMessageMDN.attrs().getAsString((Object)"DISPOSITION"));
        internetHeaders.setHeader(HEADER_RECEIVED_CONTENT_MIC, iMessageMDN.attrs().getAsString((Object)"MIC"));
        Serializable serializable = new StringBuilder();
        Object object = internetHeaders.getAllHeaderLines();
        while (object.hasMoreElements()) {
            ((StringBuilder)serializable).append((String)object.nextElement()).append("\r\n");
        }
        ((StringBuilder)serializable).append("\r\n");
        mimeBodyPart2.setContent((Object)((StringBuilder)serializable).toString(), "message/disposition-notification");
        mimeBodyPart2.setHeader("Content-Type", "message/disposition-notification");
        mimeMultipart.addBodyPart((BodyPart)mimeBodyPart2);
        internetHeaders = new MimeBodyPart();
        mimeMultipart.setSubType("report; report-type=disposition-notification");
        internetHeaders.setContent((Multipart)mimeMultipart);
        internetHeaders.setHeader("Content-Type", mimeMultipart.getContentType());
        if (bl) {
            serializable = iAS2Session.getCertificateFactory();
            try {
                object = serializable.getCertificate(iMessageMDN, ECertificatePartnershipType.SENDER);
                PrivateKey privateKey = serializable.getPrivateKey((X509Certificate)object);
                MimeBodyPart mimeBodyPart3 = AS2Helper.getCryptoHelper().sign((MimeBodyPart)internetHeaders, (X509Certificate)object, privateKey, eCryptoAlgorithmSign, bl2, bl3, EContentTransferEncoding.BASE64);
                iMessageMDN.setData(mimeBodyPart3);
            }
            catch (AS2CertificateNotFoundException | AS2KeyNotFoundException aS2Exception) {
                aS2Exception.terminate();
                LOGGER.warn("Failed to sign MDN - using an unsigned MDN instead");
                iMessageMDN.setData((MimeBodyPart)internetHeaders);
            }
        } else {
            iMessageMDN.setData((MimeBodyPart)internetHeaders);
        }
        serializable = iMessageMDN.getData();
        iMessageMDN.headers().setContentType(serializable.getContentType());
    }

    @Nonnull
    public static IMessageMDN createMDN(@Nonnull IAS2Session iAS2Session, @Nonnull AS2Message aS2Message, @Nonnull DispositionType dispositionType, @Nonnull String string) throws Exception {
        boolean bl;
        Object object;
        ValueEnforcer.notNull((Object)iAS2Session, (String)"AS2Session");
        ValueEnforcer.notNull((Object)aS2Message, (String)"AS2Message");
        ValueEnforcer.notNull((Object)dispositionType, (String)HEADER_DISPOSITION);
        ValueEnforcer.notNull((Object)string, (String)"Text");
        Partnership partnership = aS2Message.partnership();
        AS2MessageMDN aS2MessageMDN = new AS2MessageMDN(aS2Message);
        aS2MessageMDN.headers().setHeader("AS2-Version", "1.1");
        aS2MessageMDN.headers().setHeader("Date", AS2DateHelper.getFormattedDateNow("EEE, dd MMM uuuu HH:mm:ss Z"));
        aS2MessageMDN.headers().setHeader("Server", CAS2Info.NAME_VERSION);
        aS2MessageMDN.headers().setHeader("Mime-Version", "1.0");
        aS2MessageMDN.headers().setHeader("AS2-From", partnership.getReceiverAS2ID());
        aS2MessageMDN.headers().setHeader("AS2-To", partnership.getSenderAS2ID());
        aS2MessageMDN.partnership().setSenderAS2ID(aS2MessageMDN.getHeader("AS2-From"));
        aS2MessageMDN.partnership().setReceiverAS2ID(aS2MessageMDN.getHeader("AS2-To"));
        aS2MessageMDN.partnership().setSenderX509Alias(partnership.getReceiverX509Alias());
        aS2MessageMDN.partnership().setReceiverX509Alias(partnership.getSenderX509Alias());
        try {
            iAS2Session.getPartnershipFactory().updatePartnership(aS2MessageMDN, true);
        }
        catch (AS2PartnershipNotFoundException aS2PartnershipNotFoundException) {
            // empty catch block
        }
        aS2MessageMDN.headers().setHeader("From", partnership.getReceiverEmail());
        String string2 = aS2MessageMDN.partnership().getMDNSubject();
        if (string2 != null) {
            aS2MessageMDN.headers().setHeader("Subject", new MessageParameters(aS2Message).format(string2));
        } else {
            aS2MessageMDN.headers().setHeader("Subject", "Your Requested MDN Response");
        }
        String string3 = partnership.getContentTransferEncodingSend(EContentTransferEncoding.AS2_DEFAULT.getID());
        aS2MessageMDN.headers().addHeader("Content-Transfer-Encoding", string3);
        aS2MessageMDN.setText(new MessageParameters(aS2Message).format(string));
        aS2MessageMDN.attrs().putIn((Object)"REPORTING_UA", (Object)(CAS2Info.NAME_VERSION + "@" + aS2Message.attrs().getAsString((Object)"destination_ip") + ":" + aS2Message.attrs().getAsString((Object)"destination_port")));
        aS2MessageMDN.attrs().putIn((Object)"ORIGINAL_RECIPIENT", (Object)("rfc822; " + aS2Message.getHeader("AS2-To")));
        aS2MessageMDN.attrs().putIn((Object)"FINAL_RECIPIENT", (Object)("rfc822; " + partnership.getReceiverAS2ID()));
        aS2MessageMDN.attrs().putIn((Object)"ORIGINAL_MESSAGE_ID", (Object)aS2Message.getHeader("Message-ID"));
        aS2MessageMDN.attrs().putIn((Object)"DISPOSITION", (Object)dispositionType.getAsString());
        String string4 = aS2Message.getHeader("Disposition-Notification-Options");
        DispositionOptions dispositionOptions = DispositionOptions.createFromString(string4);
        ECryptoAlgorithmSign eCryptoAlgorithmSign = dispositionOptions.getFirstMICAlg();
        if (eCryptoAlgorithmSign == null && (eCryptoAlgorithmSign = ECryptoAlgorithmSign.getFromIDOrNull((String)(object = partnership.getSigningAlgorithm()))) == null && LOGGER.isWarnEnabled()) {
            LOGGER.warn("The partnership signing algorithm name '" + (String)object + "' is unknown.");
        }
        object = null;
        if (eCryptoAlgorithmSign != null) {
            bl = partnership.getSigningAlgorithm() != null || partnership.getEncryptAlgorithm() != null || partnership.getCompressionType() != null;
            object = AS2Helper.getCryptoHelper().calculateMIC(aS2Message.getData(), eCryptoAlgorithmSign, bl);
        }
        if (object != null) {
            aS2MessageMDN.attrs().putIn((Object)"MIC", (Object)((MIC)object).getAsAS2String());
        }
        bl = false;
        boolean bl2 = false;
        if (dispositionOptions.getProtocol() != null && (dispositionOptions.isProtocolRequired() || dispositionOptions.hasMICAlg())) {
            bl = true;
            ETriState eTriState = partnership.getIncludeCertificateInSignedContent();
            bl2 = eTriState.isDefined() ? eTriState.getAsBooleanValue() : iAS2Session.isCryptoSignIncludeCertificateInBodyPart();
        }
        boolean bl3 = partnership.isRFC3851MICAlgs();
        AS2Helper.createMDNData(iAS2Session, aS2MessageMDN, bl, bl2, dispositionOptions.getFirstMICAlg(), bl3);
        aS2MessageMDN.updateMessageID();
        aS2Message.setMDN(aS2MessageMDN);
        return aS2MessageMDN;
    }

    public static void parseMDN(@Nonnull IMessage iMessage, @Nullable X509Certificate x509Certificate, boolean bl, @Nullable Consumer<X509Certificate> consumer, @Nonnull AS2ResourceHelper aS2ResourceHelper) throws Exception {
        MimeMultipart mimeMultipart;
        String string = iMessage.getLoggingText();
        LOGGER.info("Start parsing MDN of" + string);
        IMessageMDN iMessageMDN = iMessage.getMDN();
        MimeBodyPart mimeBodyPart = iMessageMDN.getData();
        ICryptoHelper iCryptoHelper = AS2Helper.getCryptoHelper();
        boolean bl2 = iMessage.partnership().isDisableVerify();
        boolean bl3 = iCryptoHelper.isSigned(mimeBodyPart);
        boolean bl4 = iMessage.partnership().isForceVerify();
        if (bl3 && bl2) {
            LOGGER.info("Message claims to be signed but signature validation is disabled" + string);
        } else if (bl3 || bl4) {
            if (bl4 && !bl3) {
                LOGGER.info("Forced verify MDN signature" + string);
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Verifying MDN signature" + string);
            }
            mimeMultipart = new Wrapper();
            mimeBodyPart = iCryptoHelper.verify(mimeBodyPart, x509Certificate, bl, bl4, arg_0 -> ((Wrapper)mimeMultipart).set(arg_0), aS2ResourceHelper);
            if (consumer != null) {
                consumer.accept((X509Certificate)mimeMultipart.get());
            }
            iMessageMDN.attrs().putIn("as2msg.received.signed", true);
            iMessage.attrs().putIn((Object)"as2msg.received.signature.certificate", (Object)CertificateHelper.getPEMEncodedCertificate((Certificate)((Certificate)mimeMultipart.get())));
            LOGGER.info("Successfully verified signature of MDN of message" + string);
        }
        mimeMultipart = new MimeMultipart(mimeBodyPart.getDataHandler().getDataSource());
        ContentType contentType = AS2HttpHelper.parseContentType(mimeMultipart.getContentType());
        if (contentType != null && contentType.getBaseType().equalsIgnoreCase("multipart/report")) {
            int n = mimeMultipart.getCount();
            for (int i = 0; i < n; ++i) {
                Object object;
                MimeBodyPart mimeBodyPart2 = (MimeBodyPart)mimeMultipart.getBodyPart(i);
                if (mimeBodyPart2.isMimeType(CMimeType.TEXT_PLAIN.getAsString())) {
                    object = mimeBodyPart2.getContent();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(object == null ? "Report part content is null" : "Report part content is a " + object.getClass().getName());
                    }
                    iMessageMDN.setText(object.toString());
                    continue;
                }
                if (mimeBodyPart2.isMimeType("message/disposition-notification")) {
                    object = mimeBodyPart2.getHeader("Content-Transfer-Encoding", null);
                    try (InputStream inputStream = AS2IOHelper.getContentTransferEncodingAwareInputStream(mimeBodyPart2.getInputStream(), (String)object);){
                        InternetHeaders internetHeaders = new InternetHeaders(inputStream);
                        iMessageMDN.attrs().putIn((Object)"REPORTING_UA", (Object)internetHeaders.getHeader(HEADER_REPORTING_UA, ", "));
                        iMessageMDN.attrs().putIn((Object)"ORIGINAL_RECIPIENT", (Object)internetHeaders.getHeader(HEADER_ORIGINAL_RECIPIENT, ", "));
                        iMessageMDN.attrs().putIn((Object)"FINAL_RECIPIENT", (Object)internetHeaders.getHeader(HEADER_FINAL_RECIPIENT, ", "));
                        iMessageMDN.attrs().putIn((Object)"ORIGINAL_MESSAGE_ID", (Object)internetHeaders.getHeader(HEADER_ORIGINAL_MESSAGE_ID, ", "));
                        iMessageMDN.attrs().putIn((Object)"DISPOSITION", (Object)internetHeaders.getHeader(HEADER_DISPOSITION, ", "));
                        iMessageMDN.attrs().putIn((Object)"MIC", (Object)internetHeaders.getHeader(HEADER_RECEIVED_CONTENT_MIC, ", "));
                        continue;
                    }
                }
                LOGGER.info("Got unsupported MDN body part MIME type: " + mimeBodyPart2.getContentType());
            }
        }
    }

    @Nonnull
    public static String getWithoutSpaces(@Nonnull String string) {
        return RegExHelper.stringReplacePattern((String)"\\s+", (String)string, (String)"");
    }

    private static final class SingletonHolder {
        static final BCCryptoHelper s_aInstance = new BCCryptoHelper();

        private SingletonHolder() {
        }
    }
}

