/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.util;

import com.helger.as2lib.exception.AS2Exception;
import com.helger.as2lib.processor.receiver.AS2InvalidMessageException;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.base64.Base64InputStream;
import com.helger.commons.base64.Base64OutputStream;
import com.helger.commons.callback.ICallback;
import com.helger.commons.io.file.FileIOError;
import com.helger.commons.io.file.FileOperationManager;
import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.io.file.LoggingFileOperationCallback;
import com.helger.commons.string.StringHelper;
import com.helger.commons.timing.StopWatch;
import com.sun.mail.util.QPDecoderStream;
import com.sun.mail.util.QPEncoderStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.mail.MessagingException;

@Immutable
public final class AS2IOHelper {
    private static final byte[] EOL_BYTES = AS2IOHelper.getAllAsciiBytes("\r\n");
    private static final FileOperationManager FOM = new FileOperationManager();

    private AS2IOHelper() {
    }

    @Nonnull
    public static FileOperationManager getFileOperationManager() {
        return FOM;
    }

    @Nonnull
    public static File getDirectoryFile(@Nonnull String string) {
        File file = new File(string);
        FOM.createDirRecursiveIfNotExisting(file);
        return file;
    }

    @Nonnull
    @Nonempty
    public static String getTransferRate(long l, @Nonnull StopWatch stopWatch) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(l).append(" bytes in ").append((double)stopWatch.getMillis() / 1000.0).append(" seconds at ");
        long l2 = stopWatch.getMillis();
        if (l2 != 0L) {
            double d = (double)l2 / 1000.0;
            long l3 = Math.round((double)l / d);
            stringBuilder.append(AS2IOHelper._getTransferRate(l3));
        } else {
            stringBuilder.append(AS2IOHelper._getTransferRate(l));
        }
        return stringBuilder.toString();
    }

    @Nonnull
    @Nonempty
    private static String _getTransferRate(long l) {
        StringBuilder stringBuilder = new StringBuilder();
        if (l < 1024L) {
            stringBuilder.append(l).append(" Bps");
        } else {
            long l2 = l / 1024L;
            if (l2 < 1024L) {
                stringBuilder.append(l2).append('.').append(l % 1024L).append(" KBps");
            } else {
                stringBuilder.append(l2 / 1024L).append('.').append(l2 % 1024L).append(" MBps");
            }
        }
        return stringBuilder.toString();
    }

    @Nonnull
    public static File getUniqueFile(@Nonnull File file, @Nullable String string) {
        String string2 = FilenameHelper.getAsSecureValidFilename((String)string);
        int n = -1;
        File file2;
        while ((file2 = new File(file, n == -1 ? string2 : string2 + "." + Integer.toString(n))).exists()) {
            ++n;
        }
        return file2;
    }

    public static void handleError(@Nonnull File file, @Nonnull String string) throws AS2Exception {
        Serializable serializable;
        File file2 = null;
        try {
            serializable = AS2IOHelper.getDirectoryFile(string);
            file2 = new File((File)serializable, file.getName());
            file2 = AS2IOHelper.moveFile(file, file2, false, true);
        }
        catch (IOException iOException) {
            AS2InvalidMessageException aS2InvalidMessageException = new AS2InvalidMessageException("Failed to move " + file.getAbsolutePath() + " to error directory " + file2.getAbsolutePath());
            aS2InvalidMessageException.initCause(iOException);
            throw aS2InvalidMessageException;
        }
        serializable = new AS2InvalidMessageException("Moved " + file.getAbsolutePath() + " to " + file2.getAbsolutePath());
        ((AS2Exception)serializable).terminate();
    }

    @Nonnull
    public static File moveFile(@Nonnull File file, @Nonnull File file2, boolean bl, boolean bl2) throws IOException {
        FileIOError fileIOError;
        File file3 = file2;
        if (!bl && file3.exists()) {
            if (!bl2) {
                throw new IOException("File already exists: " + file3);
            }
            file3 = AS2IOHelper.getUniqueFile(file3.getAbsoluteFile().getParentFile(), file3.getName());
        }
        if ((fileIOError = FOM.copyFile(file, file3)).isFailure()) {
            throw new IOException("Copy failed: " + fileIOError.toString());
        }
        fileIOError = FOM.deleteFile(file);
        if (fileIOError.isFailure()) {
            FOM.deleteFile(file3);
            throw new IOException("Move failed, unable to delete " + file + ": " + fileIOError.toString());
        }
        return file3;
    }

    @Nullable
    public static String getFilenameFromMessageID(@Nonnull String string) {
        String string2 = StringHelper.removeAll((String)string, (char)'<');
        string2 = StringHelper.removeAll((String)string2, (char)'>');
        return FilenameHelper.getAsSecureValidASCIIFilename((String)string2);
    }

    @Nullable
    public static String getSafeFileAndFolderName(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return string;
        }
        File file = new File(FilenameHelper.getPathUsingUnixSeparator((String)string));
        StringBuilder stringBuilder = new StringBuilder();
        for (File file2 = file; file2 != null; file2 = file2.getParentFile()) {
            String string2 = file2.getName();
            if (string2.length() == 0) {
                stringBuilder.insert(0, FilenameHelper.getPathUsingUnixSeparator((String)file2.getPath()));
                continue;
            }
            String string3 = FilenameHelper.getAsSecureValidASCIIFilename((String)string2);
            stringBuilder.insert(0, StringHelper.getNotNull((String)string3, (String)"") + '/');
        }
        return stringBuilder.deleteCharAt(stringBuilder.length() - 1).toString();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static byte[] getAllAsciiBytes(@Nonnull String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)cArray[i];
        }
        return byArray;
    }

    @Nonnull
    public static OutputStream getContentTransferEncodingAwareOutputStream(@Nonnull OutputStream outputStream, @Nullable String string) throws MessagingException {
        if (string == null) {
            return outputStream;
        }
        if (string.equalsIgnoreCase("base64")) {
            Base64OutputStream base64OutputStream = new Base64OutputStream(outputStream, 9);
            base64OutputStream.setNewLineBytes(EOL_BYTES);
            return base64OutputStream;
        }
        if (string.equalsIgnoreCase("quoted-printable")) {
            return new QPEncoderStream(outputStream);
        }
        if (string.equalsIgnoreCase("binary") || string.equalsIgnoreCase("7bit") || string.equalsIgnoreCase("8bit")) {
            return outputStream;
        }
        throw new MessagingException("Unknown Content-Transfer-Encoding '" + string + "'");
    }

    @Nonnull
    public static InputStream getContentTransferEncodingAwareInputStream(@Nonnull InputStream inputStream, @Nullable String string) throws MessagingException {
        if (string == null) {
            return inputStream;
        }
        if (string.equalsIgnoreCase("base64")) {
            return new Base64InputStream(inputStream);
        }
        if (string.equalsIgnoreCase("quoted-printable")) {
            return new QPDecoderStream(inputStream);
        }
        if (string.equalsIgnoreCase("binary") || string.equalsIgnoreCase("7bit") || string.equalsIgnoreCase("8bit")) {
            return inputStream;
        }
        throw new MessagingException("Unknown Content-Transfer-Encoding '" + string + "'");
    }

    static {
        FOM.callbacks().add((ICallback)new LoggingFileOperationCallback());
    }
}

