/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.util;

import com.helger.as2lib.CAS2Info;
import com.helger.as2lib.util.AS2IOHelper;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.file.FileIOError;
import com.helger.commons.io.stream.NonBlockingBufferedOutputStream;
import com.helger.commons.io.stream.StreamHelper;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.http.HttpEntity;
import org.apache.http.entity.FileEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AS2ResourceHelper
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AS2ResourceHelper.class);
    private static File s_aTempDir;
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    private final AtomicBoolean m_aInClose = new AtomicBoolean(false);
    @GuardedBy(value="m_aRWLock")
    private final ICommonsList<File> m_aTempFiles = new CommonsArrayList();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsList<Closeable> m_aCloseables = new CommonsArrayList();

    @Nullable
    public static File getTempDir() {
        return s_aTempDir;
    }

    public static void setTempDir(@Nullable File file) {
        if (file != null && !file.isDirectory()) {
            throw new IllegalArgumentException("Temporary directory '" + file.getAbsolutePath() + "' is not a directory");
        }
        s_aTempDir = file;
    }

    @Nonnull
    public File createTempFile() throws IOException {
        if (this.m_aInClose.get()) {
            throw new IllegalStateException("ResourceManager is already closing/closed!");
        }
        File file = File.createTempFile("as2-lib-res-", ".tmp", s_aTempDir);
        this.m_aRWLock.writeLockedBoolean(() -> this.m_aTempFiles.add((Object)file));
        return file;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<File> getAllTempFiles() {
        return (ICommonsList)this.m_aRWLock.readLockedGet(() -> this.m_aTempFiles.getClone());
    }

    public void addCloseable(@Nonnull Closeable closeable) {
        ValueEnforcer.notNull((Object)closeable, (String)"Closeable");
        if (this.m_aInClose.get()) {
            throw new IllegalStateException("AS4ResourceHelper is already closing/closed!");
        }
        this.m_aCloseables.add((Object)closeable);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<Closeable> getAllCloseables() {
        return (ICommonsList)this.m_aRWLock.readLockedGet(() -> this.m_aCloseables.getClone());
    }

    @Override
    public void close() {
        if (!this.m_aInClose.getAndSet(true)) {
            Object object;
            Iterator iterator;
            ICommonsList iCommonsList = (ICommonsList)this.m_aRWLock.writeLockedGet(() -> {
                ICommonsList iCommonsList = (ICommonsList)this.m_aCloseables.getClone();
                this.m_aCloseables.clear();
                return iCommonsList;
            });
            if (iCommonsList.isNotEmpty()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Closing " + iCommonsList.size() + " " + CAS2Info.NAME_VERSION + " stream handles");
                }
                iterator = iCommonsList.iterator();
                while (iterator.hasNext()) {
                    object = (Closeable)iterator.next();
                    StreamHelper.close((AutoCloseable)object);
                }
            }
            if ((iterator = (ICommonsList)this.m_aRWLock.writeLockedGet(() -> {
                ICommonsList iCommonsList = (ICommonsList)this.m_aTempFiles.getClone();
                this.m_aTempFiles.clear();
                return iCommonsList;
            })).isNotEmpty()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Deleting " + iterator.size() + " temporary " + CAS2Info.NAME_VERSION + " files");
                }
                object = iterator.iterator();
                while (object.hasNext()) {
                    FileIOError fileIOError;
                    File file = (File)object.next();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Deleting temporary file '" + file.getAbsolutePath() + "'");
                    }
                    if (!(fileIOError = AS2IOHelper.getFileOperationManager().deleteFileIfExisting(file)).isFailure()) continue;
                    LOGGER.warn("  Failed to delete temporary " + CAS2Info.NAME_VERSION + " file " + file.getAbsolutePath() + ": " + fileIOError.toString());
                }
            }
        }
    }

    @Nonnull
    public HttpEntity createRepeatableHttpEntity(@Nonnull HttpEntity httpEntity) throws IOException {
        ValueEnforcer.notNull((Object)httpEntity, (String)"SrcEntity");
        if (httpEntity.isRepeatable()) {
            return httpEntity;
        }
        File file = this.createTempFile();
        LOGGER.info("Converting " + httpEntity + " to a repeatable HTTP entity using file " + file.getAbsolutePath());
        try (NonBlockingBufferedOutputStream nonBlockingBufferedOutputStream = FileHelper.getBufferedOutputStream((File)file);){
            httpEntity.writeTo((OutputStream)nonBlockingBufferedOutputStream);
        }
        nonBlockingBufferedOutputStream = new FileEntity(file);
        nonBlockingBufferedOutputStream.setContentType(httpEntity.getContentType());
        nonBlockingBufferedOutputStream.setContentEncoding(httpEntity.getContentEncoding());
        nonBlockingBufferedOutputStream.setChunked(httpEntity.isChunked());
        return nonBlockingBufferedOutputStream;
    }
}

