/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.util.http;

import com.helger.as2lib.message.IMessage;
import com.helger.as2lib.util.AS2Helper;
import com.helger.as2lib.util.AS2HttpHelper;
import com.helger.as2lib.util.AS2IOHelper;
import com.helger.as2lib.util.dump.HTTPIncomingDumperDirectoryBased;
import com.helger.as2lib.util.dump.IHTTPIncomingDumper;
import com.helger.as2lib.util.http.ChunkedInputStream;
import com.helger.as2lib.util.http.IAS2HttpResponseHandler;
import com.helger.as2lib.util.http.IAS2InputStreamProvider;
import com.helger.as2lib.util.http.TempSharedFileInputStream;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.functional.ISupplier;
import com.helger.commons.http.CHttp;
import com.helger.commons.http.HttpHeaderMap;
import com.helger.commons.io.IWriteToStream;
import com.helger.commons.io.stream.NonBlockingByteArrayOutputStream;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.StringParser;
import com.helger.commons.system.SystemProperties;
import com.helger.mail.datasource.ByteArrayDataSource;
import com.helger.mail.datasource.InputStreamDataSource;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import javax.activation.DataSource;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class HTTPHelper {
    public static final String MA_HTTP_REQ_TYPE = "HTTP_REQUEST_TYPE";
    public static final String MA_HTTP_REQ_URL = "HTTP_REQUEST_URL";
    public static final String MA_HTTP_REQ_VERSION = "HTTP_REQUEST_VERSION";
    private static final Logger LOGGER = LoggerFactory.getLogger(HTTPHelper.class);
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static ISupplier<? extends IHTTPIncomingDumper> s_aHTTPIncomingDumperFactory = (ISupplier & Serializable)() -> null;

    private HTTPHelper() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<String> getAllHTTPHeaderLines(@Nonnull InternetHeaders internetHeaders) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        Enumeration enumeration = internetHeaders.getAllHeaderLines();
        while (enumeration.hasMoreElements()) {
            commonsArrayList.add((Object)((String)enumeration.nextElement()));
        }
        return commonsArrayList;
    }

    @Nonnull
    @Nonempty
    private static String[] _readRequestInfo(@Nonnull InputStream inputStream) throws IOException {
        StringTokenizer stringTokenizer;
        int n;
        int n2 = inputStream.read();
        StringBuilder stringBuilder = new StringBuilder();
        while (n2 != -1 && n2 != 13) {
            stringBuilder.append((char)n2);
            n2 = inputStream.read();
        }
        if (n2 != -1) {
            inputStream.read();
        }
        if ((n = (stringTokenizer = new StringTokenizer(stringBuilder.toString(), " ")).countTokens()) >= 3) {
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = stringTokenizer.nextToken();
            }
            return stringArray;
        }
        if (n == 2) {
            String[] stringArray = new String[]{stringTokenizer.nextToken(), "/", stringTokenizer.nextToken()};
            return stringArray;
        }
        throw new IOException("Invalid HTTP Request (" + stringBuilder.toString() + ")");
    }

    @Nullable
    public static IHTTPIncomingDumper getHTTPIncomingDumper() {
        return (IHTTPIncomingDumper)s_aRWLock.readLockedGet(() -> (IHTTPIncomingDumper)s_aHTTPIncomingDumperFactory.get());
    }

    @Nonnull
    public static ISupplier<? extends IHTTPIncomingDumper> getHTTPIncomingDumperFactory() {
        return (ISupplier)s_aRWLock.readLockedGet(() -> s_aHTTPIncomingDumperFactory);
    }

    public static void setHTTPIncomingDumperFactory(@Nonnull ISupplier<? extends IHTTPIncomingDumper> iSupplier) {
        ValueEnforcer.notNull(iSupplier, (String)"HttpDumperFactory");
        s_aRWLock.writeLockedGet(() -> {
            s_aHTTPIncomingDumperFactory = iSupplier;
            return s_aHTTPIncomingDumperFactory;
        });
    }

    @Nonnull
    public static DataSource readHttpRequest(@Nonnull IAS2InputStreamProvider iAS2InputStreamProvider, @Nonnull IAS2HttpResponseHandler iAS2HttpResponseHandler, @Nonnull IMessage iMessage, @Nullable IHTTPIncomingDumper iHTTPIncomingDumper) throws IOException, MessagingException {
        ByteArrayDataSource byteArrayDataSource;
        Object object;
        InputStream inputStream = iAS2InputStreamProvider.getInputStream();
        String[] stringArray = HTTPHelper._readRequestInfo(inputStream);
        iMessage.attrs().putIn((Object)MA_HTTP_REQ_TYPE, (Object)stringArray[0]);
        iMessage.attrs().putIn((Object)MA_HTTP_REQ_URL, (Object)stringArray[1]);
        iMessage.attrs().putIn((Object)MA_HTTP_REQ_VERSION, (Object)stringArray[2]);
        InternetHeaders internetHeaders = new InternetHeaders(inputStream);
        Enumeration enumeration = internetHeaders.getAllHeaders();
        while (enumeration.hasMoreElements()) {
            object = (Header)enumeration.nextElement();
            iMessage.headers().addHeader(object.getName(), object.getValue());
        }
        object = AS2HttpHelper.getCleanContentType(iMessage.getHeader("Content-Type"));
        byte[] byArray = null;
        String string = iMessage.getHeader("Content-Length");
        if (string == null) {
            TempSharedFileInputStream tempSharedFileInputStream;
            String string2 = iMessage.getHeader("Transfer-Encoding");
            if (string2 != null) {
                if (!AS2Helper.getWithoutSpaces(string2).equalsIgnoreCase("chunked")) {
                    HTTPHelper.sendSimpleHTTPResponse(iAS2HttpResponseHandler, 411);
                    throw new IOException("Transfer-Encoding unimplemented: " + string2);
                }
            } else {
                HTTPHelper.sendSimpleHTTPResponse(iAS2HttpResponseHandler, 411);
                throw new IOException("Content-Length missing");
            }
            TempSharedFileInputStream tempSharedFileInputStream2 = tempSharedFileInputStream = TempSharedFileInputStream.getTempSharedFileInputStream(new ChunkedInputStream(inputStream), iMessage.getMessageID());
            iMessage.setTempSharedFileInputStream(tempSharedFileInputStream);
            byteArrayDataSource = new InputStreamDataSource((InputStream)((Object)tempSharedFileInputStream2), iMessage.getAS2From() == null ? "" : iMessage.getAS2From(), (String)object, true);
        } else {
            long l = StringParser.parseLong((String)string, (long)-1L);
            if (l < 0L || l > Integer.MAX_VALUE) {
                HTTPHelper.sendSimpleHTTPResponse(iAS2HttpResponseHandler, 411);
                throw new IOException("Content-Length '" + string + "' is invalid. Only values between 0 and " + Integer.MAX_VALUE + " are allowed.");
            }
            byArray = new byte[(int)l];
            try (DataInputStream dataInputStream = new DataInputStream(inputStream);){
                dataInputStream.readFully(byArray);
            }
            byteArrayDataSource = new ByteArrayDataSource(byArray, (String)object, null);
        }
        if (iHTTPIncomingDumper != null) {
            iHTTPIncomingDumper.dumpIncomingRequest((List<String>)HTTPHelper.getAllHTTPHeaderLines(internetHeaders), byArray != null ? byArray : "Payload body was not read yet, and therefore it cannot be dumped (yet) - sorry".getBytes(StandardCharsets.ISO_8859_1), iMessage);
        }
        return byteArrayDataSource;
    }

    public static void sendSimpleHTTPResponse(@Nonnull IAS2HttpResponseHandler iAS2HttpResponseHandler, @Nonnegative int n) throws IOException {
        try (NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();){
            String string = Integer.toString(n) + " " + CHttp.getHttpResponseMessage((int)n) + "\r\n";
            nonBlockingByteArrayOutputStream.write(string.getBytes(CHttp.HTTP_CHARSET));
            iAS2HttpResponseHandler.sendHttpResponse(n, new HttpHeaderMap(), (IWriteToStream)nonBlockingByteArrayOutputStream);
        }
    }

    public static int readChunkLen(@Nonnull @WillNotClose InputStream inputStream) throws IOException {
        int n = 0;
        boolean bl = false;
        while (true) {
            int n2;
            if ((n2 = inputStream.read()) < 0) {
                throw new EOFException();
            }
            if (n2 == 10) break;
            if (n2 >= 97 && n2 <= 102) {
                n2 -= 87;
            } else if (n2 >= 65 && n2 <= 70) {
                n2 -= 55;
            } else if (n2 >= 48 && n2 <= 57) {
                n2 -= 48;
            } else {
                if (n2 != 59) continue;
                bl = true;
            }
            if (bl) continue;
            n = n * 16 + n2;
        }
        return n;
    }

    public static void readTillNexLine(@Nonnull @WillNotClose InputStream inputStream) throws IOException {
        int n;
        do {
            if ((n = inputStream.read()) >= 0) continue;
            throw new EOFException();
        } while (n != 10);
    }

    static {
        String string = SystemProperties.getPropertyValueOrNull((String)"AS2.httpDumpDirectoryIncoming");
        if (StringHelper.hasNoText((String)string) && StringHelper.hasText((String)(string = SystemProperties.getPropertyValueOrNull((String)"AS2.httpDumpDirectory")))) {
            LOGGER.warn("You are using a legacy system property name `AS2.httpDumpDirectory`. Please use `AS2.httpDumpDirectoryIncoming` instead.");
        }
        if (StringHelper.hasText((String)string)) {
            File file = new File(string);
            AS2IOHelper.getFileOperationManager().createDirIfNotExisting(file);
            HTTPHelper.setHTTPIncomingDumperFactory((ISupplier<? extends IHTTPIncomingDumper>)(ISupplier & Serializable)() -> new HTTPIncomingDumperDirectoryBased(file));
        }
    }
}

