/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.params;

import com.helger.as2lib.exception.AS2Exception;
import com.helger.as2lib.exception.WrappedAS2Exception;
import com.helger.as2lib.params.AS2InvalidParameterException;
import com.helger.as2lib.params.AbstractParameterParser;
import com.helger.commons.lang.StackTraceHelper;
import javax.annotation.Nonnull;

@Deprecated
public class ExceptionParameters
extends AbstractParameterParser {
    public static final String KEY_NAME = "name";
    public static final String KEY_MESSAGE = "message";
    public static final String KEY_TRACE = "trace";
    public static final String KEY_TERMINATED = "terminated";
    private final AS2Exception m_aTarget;
    private final boolean m_bTerminated;

    public ExceptionParameters(AS2Exception aS2Exception, boolean bl) {
        this.m_aTarget = aS2Exception;
        this.m_bTerminated = bl;
    }

    @Override
    public void setParameter(@Nonnull String string, String string2) throws AS2InvalidParameterException {
        if (string == null) {
            throw new AS2InvalidParameterException("Invalid key", this, string, string2);
        }
        if (string.equals(KEY_NAME) || string.equals(KEY_MESSAGE) || string.equals(KEY_TRACE) || string.equals(KEY_TERMINATED)) {
            throw new AS2InvalidParameterException("Parameter is read-only", this, string, string2);
        }
        throw new AS2InvalidParameterException("Invalid key", this, string, string2);
    }

    @Override
    @Nonnull
    public String getParameter(@Nonnull String string) throws AS2InvalidParameterException {
        Throwable throwable;
        if (string == null) {
            throw new AS2InvalidParameterException("Invalid key", this, string, null);
        }
        if (this.m_aTarget instanceof WrappedAS2Exception) {
            throwable = this.m_aTarget.getCause();
            if (throwable == null) {
                throwable = this.m_aTarget;
            }
        } else {
            throwable = this.m_aTarget;
        }
        if (string.equals(KEY_NAME)) {
            return throwable.getClass().getName();
        }
        if (string.equals(KEY_MESSAGE)) {
            return throwable.getMessage();
        }
        if (string.equals(KEY_TRACE)) {
            return StackTraceHelper.getStackAsString((Throwable)this.m_aTarget);
        }
        if (string.equals(KEY_TERMINATED)) {
            return this.m_bTerminated ? KEY_TERMINATED : "";
        }
        throw new AS2InvalidParameterException("Invalid key", this, string, null);
    }
}

